/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryReporter;

class GroupTelemetryReporter
implements TelemetryReporter {
    @NonNull
    private final Collection<TelemetryReporter> reporters;

    public GroupTelemetryReporter(@NonNull Collection<TelemetryReporter> reporters) {
        if (reporters == null) {
            throw new NullPointerException("reporters is marked non-null but is null");
        }
        this.reporters = Collections.unmodifiableCollection(reporters);
    }

    @Override
    public void reportStart(long epochTimestampNanos, Operation operation) {
        for (TelemetryReporter reporter : this.reporters) {
            reporter.reportStart(epochTimestampNanos, operation);
        }
    }

    @Override
    public void reportComplete(TelemetryDatapointMeasurement datapointMeasurement) {
        for (TelemetryReporter reporter : this.reporters) {
            reporter.reportComplete(datapointMeasurement);
        }
    }

    @Override
    public void flush() {
        for (TelemetryReporter reporter : this.reporters) {
            reporter.flush();
        }
    }

    @Override
    public void close() {
        for (TelemetryReporter reporter : this.reporters) {
            reporter.close();
        }
    }

    @NonNull
    @Generated
    public Collection<TelemetryReporter> getReporters() {
        return this.reporters;
    }
}

