/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.functional;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.functional.FunctionalIO;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestFunctionalIO
extends AbstractHadoopTestBase {
    @Test
    public void testUncheckIOExceptions() throws Throwable {
        IOException raised = new IOException("text");
        UncheckedIOException ex = LambdaTestUtils.intercept(UncheckedIOException.class, "text", () -> FunctionalIO.uncheckIOExceptions(() -> {
            throw raised;
        }));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ex.getCause()).describedAs("Cause of %s", new Object[]{ex})).isSameAs((Object)raised);
    }

    @Test
    public void testUncheckIOExceptionsUnchecked() throws Throwable {
        UncheckedIOException raised = new UncheckedIOException(new IOException("text"));
        UncheckedIOException ex = LambdaTestUtils.intercept(UncheckedIOException.class, "text", () -> FunctionalIO.uncheckIOExceptions(() -> {
            throw raised;
        }));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ex).describedAs("Propagated Exception %s", new Object[]{ex})).isSameAs((Object)raised);
    }

    @Test
    public void testUncheckedSupplier() throws Throwable {
        LambdaTestUtils.intercept(UncheckedIOException.class, "text", () -> FunctionalIO.toUncheckedIOExceptionSupplier(() -> {
            throw new IOException("text");
        }).get());
    }

    @Test
    public void testUncheckAndExtract() throws Throwable {
        IOException raised = new IOException("text");
        IOException ex = LambdaTestUtils.intercept(IOException.class, "text", () -> FunctionalIO.extractIOExceptions((Supplier)FunctionalIO.toUncheckedIOExceptionSupplier(() -> {
            throw raised;
        })));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ex).describedAs("Propagated Exception %s", new Object[]{ex})).isSameAs((Object)raised);
    }

    @Test
    public void testUncheckedFunction() throws Throwable {
        Function fn = FunctionalIO.toUncheckedFunction(a -> {
            throw new FileNotFoundException((String)a);
        });
        LambdaTestUtils.intercept(UncheckedIOException.class, "missing", () -> fn.apply("missing"));
    }
}

