/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.buffer;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.mapred.nativetask.buffer.DataInputStream;
import org.apache.hadoop.mapred.nativetask.buffer.InputBuffer;

@InterfaceAudience.Private
public class ByteBufferDataReader
extends DataInputStream {
    private ByteBuffer byteBuffer;
    private java.io.DataInputStream javaReader;

    public ByteBufferDataReader(InputBuffer buffer) {
        if (buffer != null) {
            this.reset(buffer);
        }
        this.javaReader = new java.io.DataInputStream(this);
    }

    public void reset(InputBuffer buffer) {
        this.byteBuffer = buffer.getByteBuffer();
    }

    @Override
    public int read() throws IOException {
        return this.byteBuffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.byteBuffer.get(b, off, len);
        return len;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.byteBuffer.get(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.byteBuffer.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int remains = this.byteBuffer.remaining();
        int skip = remains < n ? remains : n;
        int current = this.byteBuffer.position();
        this.byteBuffer.position(current + skip);
        return skip;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.byteBuffer.get() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        return this.byteBuffer.get();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        byte ch = this.byteBuffer.get();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public short readShort() throws IOException {
        return this.byteBuffer.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.byteBuffer.getShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.byteBuffer.getChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.byteBuffer.getInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.byteBuffer.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.byteBuffer.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.byteBuffer.getDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.javaReader.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.javaReader.readUTF();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public boolean hasUnReadData() {
        return null != this.byteBuffer && this.byteBuffer.hasRemaining();
    }
}

