/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.container;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.org.apache.commons.lang3.SerializationException;
import org.apache.hadoop.shaded.org.apache.commons.lang3.SerializationUtils;

public class ResourceMappings {
    private Map<String, AssignedResources> assignedResourcesMap = new HashMap<String, AssignedResources>();

    public List<Serializable> getAssignedResources(String resourceType) {
        AssignedResources ar = this.assignedResourcesMap.get(resourceType);
        if (null == ar) {
            return Collections.emptyList();
        }
        return ar.getAssignedResources();
    }

    public void addAssignedResources(String resourceType, AssignedResources assigned) {
        this.assignedResourcesMap.put(resourceType, assigned);
    }

    public static class AssignedResources
    implements Serializable {
        private static final long serialVersionUID = -1059491941955757926L;
        private List<Serializable> resources = Collections.emptyList();

        public List<Serializable> getAssignedResources() {
            return Collections.unmodifiableList(this.resources);
        }

        public void updateAssignedResources(List<Serializable> list) {
            this.resources = new ArrayList<Serializable>(list);
        }

        public static AssignedResources fromBytes(byte[] bytes) throws IOException {
            List resources;
            try {
                resources = (List)SerializationUtils.deserialize((byte[])bytes);
            }
            catch (SerializationException e) {
                throw new IOException(e);
            }
            AssignedResources ar = new AssignedResources();
            ar.updateAssignedResources(resources);
            return ar;
        }

        public byte[] toBytes() throws IOException {
            byte[] bytes;
            try {
                bytes = SerializationUtils.serialize((Serializable)((Serializable)((Object)this.resources)));
            }
            catch (SerializationException e) {
                throw new IOException(e);
            }
            return bytes;
        }
    }
}

