/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;

@InterfaceAudience.Private
@Metrics(about="Performance and usage metrics for YARN AMRMClientRelayer", context="fedr")
public final class AMRMClientRelayerMetrics
implements MetricsSource {
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"AMRMClientRelayerMetrics", (String)"Metrics for the Yarn AMRMClientRelayer");
    private static volatile AMRMClientRelayerMetrics instance = null;
    private static MetricsRegistry registry;
    private final Map<String, Map<RequestType, MutableGaugeLong>> rmClientPending = new ConcurrentHashMap<String, Map<RequestType, MutableGaugeLong>>();
    private final Map<String, Map<RequestType, MutableQuantiles>> fulfillLatency = new ConcurrentHashMap<String, Map<RequestType, MutableQuantiles>>();
    private final Map<String, Map<RequestType, MutableGaugeLong>> requestedQps = new ConcurrentHashMap<String, Map<RequestType, MutableGaugeLong>>();
    private final Map<String, Map<RequestType, MutableGaugeLong>> fulfilledQps = new ConcurrentHashMap<String, Map<RequestType, MutableGaugeLong>>();
    private final Map<String, MutableGaugeLong> rmMasterSlaveSwitch = new ConcurrentHashMap<String, MutableGaugeLong>();
    private final Map<String, MutableGaugeLong> heartbeatFailure = new ConcurrentHashMap<String, MutableGaugeLong>();
    private final Map<String, MutableGaugeLong> heartbeatSuccess = new ConcurrentHashMap<String, MutableGaugeLong>();
    private final Map<String, MutableQuantiles> heartbeatLatency = new ConcurrentHashMap<String, MutableQuantiles>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AMRMClientRelayerMetrics getInstance() {
        if (isInitialized.get()) return instance;
        Class<AMRMClientRelayerMetrics> clazz = AMRMClientRelayerMetrics.class;
        synchronized (AMRMClientRelayerMetrics.class) {
            if (instance != null) return instance;
            instance = new AMRMClientRelayerMetrics();
            DefaultMetricsSystem.instance().register(RECORD_INFO.name(), RECORD_INFO.description(), (Object)instance);
            isInitialized.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AMRMClientRelayerMetrics() {
        registry = new MetricsRegistry(RECORD_INFO);
        registry.tag(RECORD_INFO, "AMRMClientRelayer");
    }

    public static RequestType getRequestType(ExecutionType execType) {
        if (execType == null || execType.equals((Object)ExecutionType.GUARANTEED)) {
            return RequestType.Guaranteed;
        }
        return RequestType.Opportunistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected MutableGaugeLong getPendingMetric(String instanceId, RequestType type) {
        Map<String, Map<RequestType, MutableGaugeLong>> map = this.rmClientPending;
        synchronized (map) {
            if (!this.rmClientPending.containsKey(instanceId)) {
                this.rmClientPending.put(instanceId, new ConcurrentHashMap());
            }
            if (!this.rmClientPending.get(instanceId).containsKey((Object)type)) {
                this.rmClientPending.get(instanceId).put(type, registry.newGauge(type.toString() + "Pending" + instanceId, "Remove pending of " + (Object)((Object)type) + " for " + instanceId, 0L));
            }
        }
        return this.rmClientPending.get(instanceId).get((Object)type);
    }

    public void incrClientPending(String instanceId, RequestType type, int diff) {
        this.getPendingMetric(instanceId, type).incr((long)diff);
    }

    public void decrClientPending(String instanceId, RequestType type, int diff) {
        this.getPendingMetric(instanceId, type).decr((long)diff);
    }

    @VisibleForTesting
    protected void setClientPending(String instanceId, RequestType type, int val) {
        this.getPendingMetric(instanceId, type).set((long)val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected MutableQuantiles getFulfillLatencyMetric(String instanceId, RequestType type) {
        Map<String, Map<RequestType, MutableQuantiles>> map = this.fulfillLatency;
        synchronized (map) {
            if (!this.fulfillLatency.containsKey(instanceId)) {
                this.fulfillLatency.put(instanceId, new ConcurrentHashMap());
            }
            if (!this.fulfillLatency.get(instanceId).containsKey((Object)type)) {
                this.fulfillLatency.get(instanceId).put(type, registry.newQuantiles(type.toString() + "FulfillLatency" + instanceId, "FulfillLatency of " + (Object)((Object)type) + " for " + instanceId, "ops", "latency", 60));
            }
        }
        return this.fulfillLatency.get(instanceId).get((Object)type);
    }

    public void addFulfillLatency(String instanceId, RequestType type, long latency) {
        this.getFulfillLatencyMetric(instanceId, type).add(latency);
    }

    public void addFulfillLatency(String instanceId, ContainerUpdateType type, long latency) {
        switch (type) {
            case DEMOTE_EXECUTION_TYPE: {
                this.addFulfillLatency(instanceId, RequestType.Demote, latency);
                break;
            }
            case PROMOTE_EXECUTION_TYPE: {
                this.addFulfillLatency(instanceId, RequestType.Promote, latency);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected MutableGaugeLong getRequestedQPSMetric(String instanceId, RequestType type) {
        Map<String, Map<RequestType, MutableGaugeLong>> map = this.requestedQps;
        synchronized (map) {
            if (!this.requestedQps.containsKey(instanceId)) {
                this.requestedQps.put(instanceId, new ConcurrentHashMap());
            }
            if (!this.requestedQps.get(instanceId).containsKey((Object)type)) {
                this.requestedQps.get(instanceId).put(type, registry.newGauge(Interns.info((String)(type.toString() + "RequestedOps" + instanceId), (String)("Requested operations of " + (Object)((Object)type) + " for " + instanceId)), 0L));
            }
        }
        return this.requestedQps.get(instanceId).get((Object)type);
    }

    public void addRequestedQPS(String instanceId, RequestType type, long numEntries) {
        this.getRequestedQPSMetric(instanceId, type).incr(numEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected MutableGaugeLong getFulfilledQPSMetric(String instanceId, RequestType type) {
        Map<String, Map<RequestType, MutableGaugeLong>> map = this.fulfilledQps;
        synchronized (map) {
            if (!this.fulfilledQps.containsKey(instanceId)) {
                this.fulfilledQps.put(instanceId, new ConcurrentHashMap());
            }
            if (!this.fulfilledQps.get(instanceId).containsKey((Object)type)) {
                this.fulfilledQps.get(instanceId).put(type, registry.newGauge(Interns.info((String)(type.toString() + "FulfilledOps" + instanceId), (String)("Fulfilled operations of " + (Object)((Object)type) + " for " + instanceId)), 0L));
            }
        }
        return this.fulfilledQps.get(instanceId).get((Object)type);
    }

    public void addFulfilledQPS(String instanceId, RequestType type, long numEntries) {
        this.getFulfilledQPSMetric(instanceId, type).incr(numEntries);
    }

    public void addFulfilledQPS(String instanceId, ContainerUpdateType type, long latency) {
        switch (type) {
            case DEMOTE_EXECUTION_TYPE: {
                this.addFulfilledQPS(instanceId, RequestType.Demote, latency);
                break;
            }
            case PROMOTE_EXECUTION_TYPE: {
                this.addFulfilledQPS(instanceId, RequestType.Promote, latency);
                break;
            }
        }
    }

    public void incrClientPending(String scId, ContainerUpdateType type, int diff) {
        switch (type) {
            case DEMOTE_EXECUTION_TYPE: {
                this.incrClientPending(scId, RequestType.Demote, diff);
                break;
            }
            case PROMOTE_EXECUTION_TYPE: {
                this.incrClientPending(scId, RequestType.Promote, diff);
                break;
            }
        }
    }

    public void decrClientPending(String scId, ContainerUpdateType type, int diff) {
        switch (type) {
            case DEMOTE_EXECUTION_TYPE: {
                this.decrClientPending(scId, RequestType.Demote, diff);
                break;
            }
            case PROMOTE_EXECUTION_TYPE: {
                this.decrClientPending(scId, RequestType.Promote, diff);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected MutableGaugeLong getRMMasterSlaveSwitchMetric(String instanceId) {
        Map<String, MutableGaugeLong> map = this.rmMasterSlaveSwitch;
        synchronized (map) {
            if (!this.rmMasterSlaveSwitch.containsKey(instanceId)) {
                this.rmMasterSlaveSwitch.put(instanceId, registry.newGauge(Interns.info((String)("RMMasterSlaveSwitch" + instanceId), (String)"Number of RM master slave switch"), 0L));
            }
        }
        return this.rmMasterSlaveSwitch.get(instanceId);
    }

    public void incrRMMasterSlaveSwitch(String instanceId) {
        this.getRMMasterSlaveSwitchMetric(instanceId).incr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected MutableQuantiles getHeartbeatLatencyMetric(String instanceId) {
        Map<String, MutableQuantiles> map = this.heartbeatLatency;
        synchronized (map) {
            if (!this.heartbeatLatency.containsKey(instanceId)) {
                this.heartbeatLatency.put(instanceId, registry.newQuantiles("HeartbeatLatency" + instanceId, "HeartbeatLatency for " + instanceId, "ops", "latency", 60));
            }
        }
        return this.heartbeatLatency.get(instanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected MutableGaugeLong getHeartbeatFailureMetric(String instanceId) {
        Map<String, MutableGaugeLong> map = this.heartbeatFailure;
        synchronized (map) {
            if (!this.heartbeatFailure.containsKey(instanceId)) {
                this.heartbeatFailure.put(instanceId, registry.newGauge(Interns.info((String)("HeartbeatFailure" + instanceId), (String)"Number of Heartbeat Failures"), 0L));
            }
        }
        return this.heartbeatFailure.get(instanceId);
    }

    public void addHeartbeatFailure(String instanceId, long latency) {
        this.getHeartbeatFailureMetric(instanceId).incr();
        this.getHeartbeatLatencyMetric(instanceId).add(latency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected MutableGaugeLong getHeartbeatSuccessMetric(String instanceId) {
        Map<String, MutableGaugeLong> map = this.heartbeatSuccess;
        synchronized (map) {
            if (!this.heartbeatSuccess.containsKey(instanceId)) {
                this.heartbeatSuccess.put(instanceId, registry.newGauge(Interns.info((String)("HeartbeatSuccess" + instanceId), (String)"Number of Heartbeat"), 0L));
            }
        }
        return this.heartbeatSuccess.get(instanceId);
    }

    public void addHeartbeatSuccess(String instanceId, long latency) {
        this.getHeartbeatSuccessMetric(instanceId).incr();
        this.getHeartbeatLatencyMetric(instanceId).add(latency);
    }

    public void getMetrics(MetricsCollector builder, boolean all) {
        registry.snapshot(builder.addRecord(registry.info().name()), all);
    }

    public static enum RequestType {
        Guaranteed,
        Opportunistic,
        Promote,
        Demote;


        public String toString() {
            switch (this) {
                case Guaranteed: {
                    return "G";
                }
                case Opportunistic: {
                    return "O";
                }
                case Promote: {
                    return "P";
                }
                case Demote: {
                    return "D";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

