/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.jsonschema2pojo.rules;

import javax.validation.constraints.Digits;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.sun.codemodel.JAnnotationUse;
import org.apache.hadoop.shaded.com.sun.codemodel.JFieldVar;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Schema;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.Rule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.RuleFactory;

public class DigitsRule
implements Rule<JFieldVar, JFieldVar> {
    private final RuleFactory ruleFactory;

    protected DigitsRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JFieldVar apply(String nodeName, JsonNode node, JsonNode parent, JFieldVar field, Schema currentSchema) {
        if (this.ruleFactory.getGenerationConfig().isIncludeJsr303Annotations() && node.has("integerDigits") && node.has("fractionalDigits") && this.isApplicableType(field)) {
            JAnnotationUse annotation = field.annotate(Digits.class);
            annotation.param("integer", node.get("integerDigits").asInt());
            annotation.param("fraction", node.get("fractionalDigits").asInt());
        }
        return field;
    }

    private boolean isApplicableType(JFieldVar field) {
        try {
            Class<?> fieldClass = Class.forName(field.type().boxify().fullName());
            return String.class.isAssignableFrom(fieldClass) || Number.class.isAssignableFrom(fieldClass) && !Float.class.isAssignableFrom(fieldClass) && !Double.class.isAssignableFrom(fieldClass);
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

