/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.GrizzlyFuture;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ReadResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.BaseFilter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainContext;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.NextAction;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.TransportFilter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.Buffers;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class TCPNIOTransportFilter
extends BaseFilter {
    private final TCPNIOTransport transport;

    TCPNIOTransportFilter(TCPNIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer buffer;
        TCPNIOConnection connection = (TCPNIOConnection)ctx.getConnection();
        boolean isBlocking = ctx.getTransportContext().isBlocking();
        if (!isBlocking) {
            buffer = this.transport.read(connection, null);
        } else {
            GrizzlyFuture<ReadResult<Buffer, SocketAddress>> future = this.transport.getTemporarySelectorIO().getReader().read(connection, null);
            try {
                ReadResult result = (ReadResult)future.get();
                buffer = (Buffer)result.getMessage();
                future.recycle(true);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new IOException(cause);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        if (buffer == null || buffer.position() == 0) {
            return ctx.getStopAction();
        }
        buffer.trim();
        ctx.setMessage(buffer);
        ctx.setAddress(connection.getPeerAddress());
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        WritableMessage message = (WritableMessage)ctx.getMessage();
        if (message != null) {
            ctx.setMessage(null);
            Connection connection = ctx.getConnection();
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            CompletionHandler completionHandler = transportContext.getCompletionHandler();
            MessageCloner cloner = transportContext.getMessageCloner();
            PushBackHandler pushBackHandler = transportContext.getPushBackHandler();
            transportContext.setCompletionHandler(null);
            transportContext.setMessageCloner(null);
            transportContext.setPushBackHandler(null);
            if (!transportContext.isBlocking()) {
                this.transport.getAsyncQueueIO().getWriter().write(connection, null, message, completionHandler, pushBackHandler, cloner);
            } else {
                this.transport.getTemporarySelectorIO().getWriter().write(connection, null, message, completionHandler, pushBackHandler);
            }
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event.type() == TransportFilter.FlushEvent.TYPE) {
            Connection connection = ctx.getConnection();
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            if (transportContext.getCompletionHandler() != null) {
                throw new IllegalStateException("TransportContext CompletionHandler must be null");
            }
            CompletionHandler completionHandler = ((TransportFilter.FlushEvent)event).getCompletionHandler();
            this.transport.getWriter(transportContext.isBlocking()).write(connection, Buffers.EMPTY_BUFFER, completionHandler);
        }
        return ctx.getInvokeAction();
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (connection != null) {
            connection.closeSilently();
        }
    }
}

