/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http;

import java.io.UnsupportedEncodingException;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.DataChunk;

public enum Protocol {
    HTTP_0_9(0, 9),
    HTTP_1_0(1, 0),
    HTTP_1_1(1, 1);

    private final String protocolString;
    private final int majorVersion;
    private final int minorVersion;
    private byte[] protocolBytes;

    public static Protocol parseDataChunk(DataChunk protocolC) {
        if (protocolC.getLength() == 0) {
            return HTTP_0_9;
        }
        if (protocolC.equals(HTTP_1_1.getProtocolString())) {
            return HTTP_1_1;
        }
        if (protocolC.equals(HTTP_1_0.getProtocolString())) {
            return HTTP_1_0;
        }
        if (protocolC.equals(HTTP_0_9.getProtocolString())) {
            return HTTP_0_9;
        }
        throw new IllegalStateException("Unknown protocol " + protocolC.toString());
    }

    private Protocol(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.protocolString = "HTTP/" + majorVersion + '.' + minorVersion;
        try {
            this.protocolBytes = this.protocolString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ignored) {
            this.protocolBytes = this.protocolString.getBytes();
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getProtocolString() {
        return this.protocolString;
    }

    public byte[] getProtocolBytes() {
        return this.protocolBytes;
    }
}

