/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import java.net.InetAddress;
import java.util.List;
import org.apache.hadoop.shaded.org.xbill.DNS.AAAARecord;
import org.apache.hadoop.shaded.org.xbill.DNS.ARecord;
import org.apache.hadoop.shaded.org.xbill.DNS.CNAMERecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.PTRRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.SRVRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.TXTRecord;

public final class RecordCreatorFactory {
    private static long ttl;

    private RecordCreatorFactory() {
    }

    static RecordCreator getRecordCreator(int type) {
        switch (type) {
            case 1: {
                return new ARecordCreator();
            }
            case 5: {
                return new CNAMERecordCreator();
            }
            case 16: {
                return new TXTRecordCreator();
            }
            case 28: {
                return new AAAARecordCreator();
            }
            case 12: {
                return new PTRRecordCreator();
            }
            case 33: {
                return new SRVRecordCreator();
            }
        }
        throw new IllegalArgumentException("No type " + type);
    }

    public static void setTtl(long ttl) {
        RecordCreatorFactory.ttl = ttl;
    }

    public static class HostPortInfo {
        private Name host;
        private int port;

        public HostPortInfo(Name host, int port) {
            this.setHost(host);
            this.setPort(port);
        }

        Name getHost() {
            return this.host;
        }

        void setHost(Name host) {
            this.host = host;
        }

        int getPort() {
            return this.port;
        }

        void setPort(int port) {
            this.port = port;
        }
    }

    static class SRVRecordCreator
    implements RecordCreator<SRVRecord, HostPortInfo> {
        @Override
        public SRVRecord create(Name name, HostPortInfo target) {
            return new SRVRecord(name, 1, ttl, 1, 1, target.getPort(), target.getHost());
        }
    }

    static class PTRRecordCreator
    implements RecordCreator<PTRRecord, Name> {
        @Override
        public PTRRecord create(Name name, Name target) {
            return new PTRRecord(name, 1, ttl, target);
        }
    }

    static class TXTRecordCreator
    implements RecordCreator<TXTRecord, List<String>> {
        @Override
        public TXTRecord create(Name name, List<String> target) {
            return new TXTRecord(name, 1, ttl, target);
        }
    }

    static class CNAMERecordCreator
    implements RecordCreator<CNAMERecord, Name> {
        @Override
        public CNAMERecord create(Name name, Name target) {
            return new CNAMERecord(name, 1, ttl, target);
        }
    }

    static class AAAARecordCreator
    implements RecordCreator<AAAARecord, InetAddress> {
        @Override
        public AAAARecord create(Name name, InetAddress target) {
            return new AAAARecord(name, 1, ttl, target);
        }
    }

    static class ARecordCreator
    implements RecordCreator<ARecord, InetAddress> {
        @Override
        public ARecord create(Name name, InetAddress target) {
            return new ARecord(name, 1, ttl, target);
        }
    }

    public static interface RecordCreator<R extends Record, T> {
        public R create(Name var1, T var2);
    }
}

