/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;

public final class AclTestHelpers {
    public static AclEntry aclEntry(AclEntryScope scope, AclEntryType type, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setPermission(permission).build();
    }

    public static AclEntry aclEntry(AclEntryScope scope, AclEntryType type, String name, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setName(name).setPermission(permission).build();
    }

    public static AclEntry aclEntry(AclEntryScope scope, AclEntryType type, String name) {
        return new AclEntry.Builder().setScope(scope).setType(type).setName(name).build();
    }

    public static AclEntry aclEntry(AclEntryScope scope, AclEntryType type) {
        return new AclEntry.Builder().setScope(scope).setType(type).build();
    }

    public static void assertFilePermissionDenied(FileSystem fs, UserGroupInformation user, Path pathToCheck) throws Exception {
        try {
            DFSTestUtil.readFileBuffer(fs, pathToCheck);
            Assert.fail((String)("expected AccessControlException for user " + user + ", path = " + pathToCheck));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public static void assertFilePermissionGranted(FileSystem fs, UserGroupInformation user, Path pathToCheck) throws Exception {
        try {
            DFSTestUtil.readFileBuffer(fs, pathToCheck);
        }
        catch (AccessControlException e) {
            Assert.fail((String)("expected permission granted for user " + user + ", path = " + pathToCheck));
        }
    }

    public static void assertPermission(FileSystem fs, Path pathToCheck, short perm) throws IOException {
        AclTestHelpers.assertPermission(fs, pathToCheck, perm, (perm & 0x1000) != 0);
    }

    public static void assertPermission(FileSystem fs, Path pathToCheck, short perm, boolean hasAcl) throws IOException {
        short filteredPerm = (short)(perm & 0x3FF);
        FileStatus stat = fs.getFileStatus(pathToCheck);
        FsPermission fsPermission = stat.getPermission();
        Assert.assertEquals((long)filteredPerm, (long)fsPermission.toShort());
        Assert.assertEquals((Object)hasAcl, (Object)stat.hasAcl());
    }
}

