/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.translator.api;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobMetaData.class);
    private final ResourceSkyline resourceSkyline = new ResourceSkyline();
    private final Map<String, Long> rawStart = new HashMap<String, Long>();
    private final Map<String, Long> rawEnd = new HashMap<String, Long>();
    private RecurrenceId recurrenceId;

    public JobMetaData(long jobSubmissionTimeConfig) {
        this.resourceSkyline.setJobSubmissionTime(jobSubmissionTimeConfig);
    }

    public final JobMetaData setJobFinishTime(long jobFinishTimeConfig) {
        this.resourceSkyline.setJobFinishTime(jobFinishTimeConfig);
        return this;
    }

    public final JobMetaData setContainerStart(String containerId, long time) {
        if (this.rawStart.put(containerId, time) != null) {
            LOGGER.warn("find duplicate container launch time for {}, so we replace it with {}.", (Object)containerId, (Object)time);
        }
        return this;
    }

    public final JobMetaData setContainerEnd(String containerId, long time) {
        if (this.rawEnd.put(containerId, time) != null) {
            LOGGER.warn("find duplicate container release time for {}, so we replace it with {}.", (Object)containerId, (Object)time);
        }
        return this;
    }

    public final RecurrenceId getRecurrenceId() {
        return this.recurrenceId;
    }

    public final JobMetaData setRecurrenceId(RecurrenceId recurrenceIdConfig) {
        this.recurrenceId = recurrenceIdConfig;
        return this;
    }

    public final ResourceSkyline getResourceSkyline() {
        return this.resourceSkyline;
    }

    public final void createSkyline() {
        long jobSubmissionTime = this.resourceSkyline.getJobSubmissionTime();
        Resource containerSpec = this.resourceSkyline.getContainerSpec();
        TreeMap resourceOverTime = new TreeMap();
        RLESparseResourceAllocation skylineList = new RLESparseResourceAllocation(resourceOverTime, (ResourceCalculator)new DefaultResourceCalculator());
        this.resourceSkyline.setSkylineList(skylineList);
        if (containerSpec == null) {
            containerSpec = Resource.newInstance((int)1024, (int)1);
        }
        this.resourceSkyline.setContainerSpec(containerSpec);
        for (Map.Entry<String, Long> entry : this.rawStart.entrySet()) {
            long timeStart = entry.getValue();
            Long timeEnd = this.rawEnd.get(entry.getKey());
            if (timeEnd == null) {
                LOGGER.warn("container release time not found for {}.", (Object)entry.getKey());
                continue;
            }
            ReservationInterval riAdd = new ReservationInterval((timeStart - jobSubmissionTime) / 1000L, (timeEnd - jobSubmissionTime) / 1000L);
            this.resourceSkyline.getSkylineList().addInterval(riAdd, containerSpec);
        }
    }
}

