/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.skylinestore.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.skylinestore.api.SkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.DuplicateRecurrenceIdException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.EmptyResourceSkylineException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.RecurrenceIdNotFoundException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.resourceestimator.skylinestore.validator.SkylineStoreValidator;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryStore
implements SkylineStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryStore.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final SkylineStoreValidator inputValidator = new SkylineStoreValidator();
    private final Map<RecurrenceId, List<ResourceSkyline>> skylineStore = new HashMap<RecurrenceId, List<ResourceSkyline>>();
    private final Map<String, RLESparseResourceAllocation> estimationStore = new HashMap<String, RLESparseResourceAllocation>();

    private List<ResourceSkyline> eliminateNull(List<ResourceSkyline> resourceSkylines) {
        ArrayList<ResourceSkyline> result = new ArrayList<ResourceSkyline>();
        for (ResourceSkyline resourceSkyline : resourceSkylines) {
            if (resourceSkyline == null) continue;
            result.add(resourceSkyline);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addHistory(RecurrenceId recurrenceId, List<ResourceSkyline> resourceSkylines) throws SkylineStoreException {
        this.inputValidator.validate(recurrenceId, resourceSkylines);
        this.writeLock.lock();
        try {
            List<ResourceSkyline> filteredInput = this.eliminateNull(resourceSkylines);
            if (filteredInput.size() > 0) {
                if (this.skylineStore.containsKey(recurrenceId)) {
                    List<ResourceSkyline> jobHistory = this.skylineStore.get(recurrenceId);
                    ArrayList<String> oldJobIds = new ArrayList<String>();
                    for (ResourceSkyline resourceSkyline : jobHistory) {
                        oldJobIds.add(resourceSkyline.getJobId());
                    }
                    if (!oldJobIds.isEmpty()) {
                        for (ResourceSkyline elem : filteredInput) {
                            if (!oldJobIds.contains(elem.getJobId())) continue;
                            StringBuilder errMsg = new StringBuilder();
                            errMsg.append("Trying to addHistory duplicate resource skylines for " + recurrenceId + ". Use updateHistory function instead.");
                            LOGGER.error(errMsg.toString());
                            throw new DuplicateRecurrenceIdException(errMsg.toString());
                        }
                    }
                    this.skylineStore.get(recurrenceId).addAll(filteredInput);
                    LOGGER.info("Successfully addHistory new resource skylines for {}.", (Object)recurrenceId);
                } else {
                    this.skylineStore.put(recurrenceId, filteredInput);
                    LOGGER.info("Successfully addHistory new resource skylines for {}.", (Object)recurrenceId);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addEstimation(String pipelineId, RLESparseResourceAllocation resourceSkyline) throws SkylineStoreException {
        this.inputValidator.validate(pipelineId, resourceSkyline);
        this.writeLock.lock();
        try {
            this.estimationStore.put(pipelineId, resourceSkyline);
            LOGGER.info("Successfully add estimated resource allocation for {}.", (Object)pipelineId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public final void deleteHistory(RecurrenceId recurrenceId) throws SkylineStoreException {
        block4: {
            this.inputValidator.validate(recurrenceId);
            this.writeLock.lock();
            try {
                if (this.skylineStore.containsKey(recurrenceId)) {
                    this.skylineStore.remove(recurrenceId);
                    LOGGER.warn("Delete resource skylines for {}.", (Object)recurrenceId);
                    break block4;
                }
                StringBuilder errMsg = new StringBuilder();
                errMsg.append("Trying to deleteHistory non-existing recurring pipeline  " + recurrenceId + "'s resource skylines");
                LOGGER.error(errMsg.toString());
                throw new RecurrenceIdNotFoundException(errMsg.toString());
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateHistory(RecurrenceId recurrenceId, List<ResourceSkyline> resourceSkylines) throws SkylineStoreException {
        block5: {
            this.inputValidator.validate(recurrenceId, resourceSkylines);
            this.writeLock.lock();
            try {
                if (this.skylineStore.containsKey(recurrenceId)) {
                    List<ResourceSkyline> filteredInput = this.eliminateNull(resourceSkylines);
                    if (filteredInput.size() > 0) {
                        this.skylineStore.put(recurrenceId, filteredInput);
                        LOGGER.info("Successfully updateHistory resource skylines for {}.", (Object)recurrenceId);
                        break block5;
                    }
                    StringBuilder errMsg = new StringBuilder();
                    errMsg.append("Trying to updateHistory " + recurrenceId + " with empty resource skyline");
                    LOGGER.error(errMsg.toString());
                    throw new EmptyResourceSkylineException(errMsg.toString());
                }
                StringBuilder errMsg = new StringBuilder();
                errMsg.append("Trying to updateHistory non-existing resource skylines for " + recurrenceId);
                LOGGER.error(errMsg.toString());
                throw new RecurrenceIdNotFoundException(errMsg.toString());
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<RecurrenceId, List<ResourceSkyline>> getHistory(RecurrenceId recurrenceId) throws SkylineStoreException {
        this.inputValidator.validate(recurrenceId);
        this.readLock.lock();
        try {
            String pipelineId = recurrenceId.getPipelineId();
            if (pipelineId.equals("*")) {
                LOGGER.info("Successfully query resource skylines for {}.", (Object)recurrenceId);
                Map<RecurrenceId, List<ResourceSkyline>> map = Collections.unmodifiableMap(this.skylineStore);
                return map;
            }
            String runId = recurrenceId.getRunId();
            HashMap<RecurrenceId, List<ResourceSkyline>> result = new HashMap<RecurrenceId, List<ResourceSkyline>>();
            if (runId.equals("*")) {
                Object object;
                for (Map.Entry<RecurrenceId, List<ResourceSkyline>> entry : this.skylineStore.entrySet()) {
                    RecurrenceId index = entry.getKey();
                    if (!index.getPipelineId().equals(pipelineId)) continue;
                    result.put(index, entry.getValue());
                }
                if (result.size() > 0) {
                    LOGGER.info("Successfully query resource skylines for {}.", (Object)recurrenceId);
                    object = Collections.unmodifiableMap(result);
                    return object;
                }
                LOGGER.warn("Trying to getHistory non-existing resource skylines for {}.", (Object)recurrenceId);
                object = null;
                return object;
            }
            if (!this.skylineStore.containsKey(recurrenceId)) {
                LOGGER.warn("Trying to getHistory non-existing resource skylines for {}.", (Object)recurrenceId);
                Map<RecurrenceId, List<ResourceSkyline>> map = null;
                return map;
            }
            result.put(recurrenceId, this.skylineStore.get(recurrenceId));
            LOGGER.info("Successfully query resource skylines for {}.", (Object)recurrenceId);
            Map<RecurrenceId, List<ResourceSkyline>> map = Collections.unmodifiableMap(result);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final RLESparseResourceAllocation getEstimation(String pipelineId) throws SkylineStoreException {
        this.inputValidator.validate(pipelineId);
        this.readLock.lock();
        try {
            RLESparseResourceAllocation rLESparseResourceAllocation = this.estimationStore.get(pipelineId);
            return rLESparseResourceAllocation;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

