/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin;

import java.io.Serializable;
import java.util.Objects;

public final class MountDeviceSpec
implements Serializable,
Comparable {
    private static final long serialVersionUID = -160806358136943052L;
    private final String devicePathInHost;
    private final String devicePathInContainer;
    private final String devicePermission;
    public static final String RO = "r";
    public static final String RW = "rw";

    private MountDeviceSpec(Builder builder) {
        this.devicePathInContainer = builder.devicePathInContainer;
        this.devicePathInHost = builder.devicePathInHost;
        this.devicePermission = builder.devicePermission;
    }

    public String getDevicePathInHost() {
        return this.devicePathInHost;
    }

    public String getDevicePathInContainer() {
        return this.devicePathInContainer;
    }

    public String getDevicePermission() {
        return this.devicePermission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MountDeviceSpec other = (MountDeviceSpec)o;
        return Objects.equals(this.devicePathInHost, other.getDevicePathInHost()) && Objects.equals(this.devicePathInContainer, other.getDevicePathInContainer()) && Objects.equals(this.devicePermission, other.getDevicePermission());
    }

    public int hashCode() {
        return Objects.hash(this.devicePathInContainer, this.devicePathInHost, this.devicePermission);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof MountDeviceSpec)) {
            return -1;
        }
        MountDeviceSpec other = (MountDeviceSpec)o;
        int result = this.devicePathInContainer.compareTo(other.getDevicePathInContainer());
        if (0 != result) {
            return result;
        }
        result = this.devicePathInHost.compareTo(other.getDevicePathInHost());
        if (0 != result) {
            return result;
        }
        return this.devicePermission.compareTo(other.getDevicePermission());
    }

    public static final class Builder {
        private String devicePathInHost;
        private String devicePathInContainer;
        private String devicePermission;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public MountDeviceSpec build() {
            return new MountDeviceSpec(this);
        }

        public Builder setDevicePermission(String permission) {
            this.devicePermission = permission;
            return this;
        }

        public Builder setDevicePathInContainer(String pathInContainer) {
            this.devicePathInContainer = pathInContainer;
            return this;
        }

        public Builder setDevicePathInHost(String pathInHost) {
            this.devicePathInHost = pathInHost;
            return this;
        }
    }
}

