/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Date;
import java.util.Locale;
import org.ojalgo.type.context.BooleanContext;
import org.ojalgo.type.context.DateContext;
import org.ojalgo.type.context.NumberContext;
import org.ojalgo.type.context.StringContext;
import org.ojalgo.type.context.TypeContext;
import org.ojalgo.type.format.DatePart;
import org.ojalgo.type.format.DateStyle;

public abstract class StandardType {
    public static final NumberContext AMOUNT = StandardType.amount(Locale.getDefault());
    public static final DateContext DATE = new DateContext(DatePart.DATE);
    public static final DateContext DATETIME = new DateContext(DatePart.DATETIME);
    public static final NumberContext DECIMAL_032 = NumberContext.getGeneral(MathContext.DECIMAL32);
    public static final NumberContext DECIMAL_064 = NumberContext.getGeneral(MathContext.DECIMAL64);
    public static final NumberContext DECIMAL_128 = NumberContext.getGeneral(MathContext.DECIMAL128);
    public static final NumberContext MATH_032 = NumberContext.getMath(MathContext.DECIMAL32);
    public static final NumberContext MATH_064 = NumberContext.getMath(MathContext.DECIMAL64);
    public static final NumberContext MATH_128 = NumberContext.getMath(MathContext.DECIMAL128);
    public static final NumberContext PERCENT = StandardType.percent(Locale.getDefault());
    public static final NumberContext PRICE = NumberContext.getGeneral(8);
    public static final NumberContext QUANTITY = NumberContext.getGeneral(6);
    public static final DateContext SQL_DATE = new DateContext(DatePart.DATE, DateStyle.SQL, null);
    public static final DateContext SQL_DATETIME = new DateContext(DatePart.DATETIME, DateStyle.SQL, null);
    public static final DateContext SQL_TIME = new DateContext(DatePart.TIME, DateStyle.SQL, null);
    public static final StringContext STRING_1 = StandardType.string(1);
    public static final StringContext STRING_3 = StandardType.string(3);
    public static final StringContext STRING_9 = StandardType.string(9);
    public static final StringContext STRING_M = StandardType.string(128);
    public static final StringContext TEXT = StandardType.string(0);
    public static final DateContext TIME = new DateContext(DatePart.TIME);

    public static NumberContext amount(Locale locale) {
        return NumberContext.getCurrency(locale);
    }

    public static DateContext date() {
        return DATE;
    }

    public static NumberContext decimal032() {
        return DECIMAL_032;
    }

    public static NumberContext decimal064() {
        return DECIMAL_064;
    }

    public static NumberContext integer() {
        return NumberContext.getInteger(Locale.getDefault());
    }

    public static NumberContext percent(Locale locale) {
        NumberContext retVal = NumberContext.getPercent(locale);
        retVal.format(new BigDecimal("0.5000"));
        return retVal;
    }

    public static StringContext string(int length) {
        return new StringContext(length);
    }

    public static NumberContext wholePercentage() {
        NumberContext retVal = NumberContext.getPercent(2, Locale.getDefault());
        retVal.format(0.01);
        return retVal;
    }

    protected StandardType() {
    }

    public TypeContext<Number> getAmount() {
        return AMOUNT;
    }

    public TypeContext<Boolean> getBoolean() {
        return new BooleanContext();
    }

    public TypeContext<Date> getDate() {
        return DATE;
    }

    public TypeContext<Number> getDecimal032() {
        return DECIMAL_032;
    }

    public TypeContext<Number> getDecimal064() {
        return DECIMAL_064;
    }

    public TypeContext<Number> getDecimal128() {
        return DECIMAL_128;
    }

    public TypeContext<Number> getMath032() {
        return MATH_032;
    }

    public TypeContext<Number> getMath064() {
        return MATH_064;
    }

    public TypeContext<Number> getMath128() {
        return MATH_128;
    }

    public TypeContext<Date> getMoment() {
        return DATETIME;
    }

    public TypeContext<Number> getMoney() {
        return AMOUNT;
    }

    public TypeContext<Number> getParameter() {
        return DECIMAL_064;
    }

    public TypeContext<Number> getPercent() {
        return PERCENT;
    }

    public TypeContext<Number> getPrice() {
        return PRICE;
    }

    public TypeContext<Number> getQuantity() {
        return QUANTITY;
    }

    public TypeContext<String> getString1() {
        return STRING_1;
    }

    public TypeContext<String> getString3() {
        return STRING_3;
    }

    public TypeContext<String> getString9() {
        return STRING_9;
    }

    public TypeContext<String> getStringM() {
        return STRING_M;
    }

    public TypeContext<String> getText() {
        return TEXT;
    }

    public TypeContext<Date> getTime() {
        return TIME;
    }

    public TypeContext<Date> getTimestamp() {
        return DATETIME;
    }
}

