/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ojalgo.netio.ASCII;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.random.Uniform;

public class Password {
    private static MessageDigest INSTANCE;

    public static String encrypt(String aPassword) {
        String retVal = null;
        MessageDigest tmpDigest = Password.getInstance();
        if (aPassword != null) {
            byte[] tmpBytes = tmpDigest.digest(aPassword.getBytes());
            for (int i = 0; i < tmpBytes.length; ++i) {
                if (tmpBytes[i] < 0) {
                    tmpBytes[i] = (byte)(tmpBytes[i] + 128);
                }
                if (tmpBytes[i] < 32) {
                    tmpBytes[i] = (byte)(tmpBytes[i] + 32);
                }
                if (tmpBytes[i] != 34 && tmpBytes[i] != 38 && tmpBytes[i] != 39 && tmpBytes[i] != 47 && tmpBytes[i] != 60 && tmpBytes[i] != 62 && tmpBytes[i] != 92) continue;
                tmpBytes[i] = 32;
            }
            retVal = new String(tmpBytes).trim();
        }
        return retVal;
    }

    public static String encrypt(String aPassword, String aToBytesEncoding, String aFromBytesEncoding) {
        String retVal = null;
        MessageDigest tmpDigest = Password.getInstance();
        if (aPassword != null) {
            try {
                byte[] tmpBytes = tmpDigest.digest(aPassword.getBytes(aToBytesEncoding));
                retVal = new String(tmpBytes, aFromBytesEncoding).trim();
            }
            catch (UnsupportedEncodingException anE) {
                BasicLogger.error(anE.toString());
            }
        }
        return retVal;
    }

    public static String makeClearText(int length) {
        char[] retVal = new char[length];
        Uniform tmpRandom = new Uniform(0.0, 128.0);
        for (int c = 0; c < length; ++c) {
            int tmpChar = 160;
            while (!ASCII.isAlphanumeric(tmpChar = tmpRandom.intValue())) {
            }
            retVal[c] = (char)tmpChar;
        }
        return String.valueOf(retVal);
    }

    private static MessageDigest getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException anE) {
                BasicLogger.error(anE.toString());
            }
        }
        return INSTANCE;
    }

    protected Password() {
    }
}

