/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task.iterative;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.SparseArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.PhysicalStore;

public final class Equation
implements Comparable<Equation>,
Access1D<Double>,
Mutate1D {
    public final int index;
    private final SparseArray<Double> myElements;
    private double myPivot = PrimitiveMath.ZERO;
    private final double myRHS;

    public Equation(int row, long numberOfColumns, double rhs) {
        this.index = row;
        this.myElements = SparseArray.factory(Primitive64Array.FACTORY, numberOfColumns).make();
        this.myRHS = rhs;
    }

    public Equation(int row, long numberOfColumns, double rhs, int numberOfNonzeros) {
        this.index = row;
        this.myElements = ((SparseArray.SparseFactory)SparseArray.factory(Primitive64Array.FACTORY, numberOfColumns).initial(numberOfNonzeros)).make();
        this.myRHS = rhs;
    }

    @Override
    public void add(long index, double addend) {
        this.myElements.add(index, addend);
        if (index == (long)this.index) {
            this.myPivot = this.myElements.doubleValue(index);
        }
    }

    @Override
    public void add(long index, Number addend) {
        this.add(index, addend.doubleValue());
    }

    public double adjust(PhysicalStore<Double> x, double relaxation) {
        return this.calculate(x, this.myRHS, relaxation);
    }

    @Override
    public int compareTo(Equation other) {
        return Integer.compare(this.index, other.index);
    }

    @Override
    public long count() {
        return this.myElements.count();
    }

    @Override
    public double dot(Access1D<?> vector) {
        return this.myElements.dot(vector);
    }

    @Override
    public double doubleValue(long index) {
        return this.myElements.doubleValue(index);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Equation)) {
            return false;
        }
        Equation other = (Equation)obj;
        return this.index == other.index;
    }

    @Override
    public Double get(long index) {
        return this.myElements.get(index);
    }

    public double getPivot() {
        return this.myPivot;
    }

    public double getRHS() {
        return this.myRHS;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        return result;
    }

    public void initialise(PhysicalStore<Double> x) {
        this.calculate(x, PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    @Override
    public void set(long index, double value) {
        this.myElements.set(index, value);
        if (index == (long)this.index) {
            this.myPivot = value;
        }
    }

    @Override
    public void set(long index, Number value) {
        this.set(index, value.doubleValue());
    }

    public String toString() {
        return this.index + ": " + this.myElements.toString();
    }

    private double calculate(PhysicalStore<Double> x, double rhs, double relaxation) {
        double tmpIncrement = rhs;
        double tmpError = tmpIncrement -= this.myElements.dot(x);
        tmpIncrement *= relaxation;
        x.add((long)this.index, tmpIncrement /= this.myPivot);
        return tmpError;
    }
}

