/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.type.TypeUtils;

public class RationalPolynomial
extends AbstractPolynomial<RationalNumber> {
    public RationalPolynomial(int aDegree) {
        super(Array1D.RATIONAL.makeZero(aDegree + 1));
    }

    RationalPolynomial(Array1D<RationalNumber> someCoefficients) {
        super(someCoefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        int tmpRowDim = (int)Math.min(x.count(), y.count());
        int tmpColDim = this.size();
        PhysicalStore tmpBody = (PhysicalStore)BigDenseStore.FACTORY.makeZero(tmpRowDim, tmpColDim);
        PhysicalStore tmpRHS = (PhysicalStore)BigDenseStore.FACTORY.makeZero(tmpRowDim, 1L);
        for (int i = 0; i < tmpRowDim; ++i) {
            BigDecimal tmpX = BigMath.ONE;
            BigDecimal tmpXfactor = TypeUtils.toBigDecimal(x.get(i));
            BigDecimal tmpY = TypeUtils.toBigDecimal(y.get(i));
            for (int j = 0; j < tmpColDim; ++j) {
                tmpBody.set((long)i, (long)j, tmpX);
                tmpX = tmpX.multiply(tmpXfactor);
            }
            tmpRHS.set((long)i, 0L, tmpY);
        }
        QR tmpQR = (QR)QR.BIG.make();
        tmpQR.decompose(tmpBody);
        this.set(tmpQR.getSolution(tmpRHS));
    }

    @Override
    public RationalNumber integrate(RationalNumber fromPoint, RationalNumber toPoint) {
        BasicFunction tmpPrim = this.buildPrimitive();
        RationalNumber tmpFromVal = tmpPrim.invoke(fromPoint);
        RationalNumber tmpToVal = tmpPrim.invoke(toPoint);
        return tmpToVal.subtract(tmpFromVal);
    }

    @Override
    public RationalNumber invoke(RationalNumber arg) {
        int tmpPower = this.degree();
        RationalNumber retVal = (RationalNumber)this.get(tmpPower);
        while (--tmpPower >= 0) {
            retVal = ((RationalNumber)this.get(tmpPower)).add(arg.multiply(retVal));
        }
        return retVal;
    }

    @Override
    public void set(Access1D<?> someCoefficient) {
        int tmpLimit = (int)Math.min(this.count(), someCoefficient.count());
        for (int p = 0; p < tmpLimit; ++p) {
            this.set(p, RationalNumber.valueOf(someCoefficient.get(p)));
        }
    }

    @Override
    protected RationalNumber getDerivativeFactor(int aPower) {
        int tmpNextIndex = aPower + 1;
        return ((RationalNumber)this.get(tmpNextIndex)).multiply(tmpNextIndex);
    }

    @Override
    protected RationalNumber getPrimitiveFactor(int aPower) {
        if (aPower <= 0) {
            return RationalNumber.ZERO;
        }
        return ((RationalNumber)this.get(aPower - 1)).divide(aPower);
    }

    @Override
    protected AbstractPolynomial<RationalNumber> makeInstance(int aSize) {
        return new RationalPolynomial((Array1D<RationalNumber>)Array1D.RATIONAL.makeZero(aSize));
    }
}

