/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.DenseStrategy;
import org.ojalgo.array.NumberList;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.array.SparseArray;
import org.ojalgo.array.StrategyBuilder;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

public final class LongToNumberMap<N extends Number>
implements SortedMap<Long, N>,
Access1D<N>,
Mutate1D.Mixable<N> {
    private final SparseArray<N> myStorage;
    private final DenseStrategy<N> myStrategy;

    public static <N extends Number> MapFactory<N> factory(DenseArray.Factory<N> denseFactory) {
        return new MapFactory<N>(denseFactory);
    }

    @Deprecated
    public static <N extends Number> LongToNumberMap<N> make(DenseArray.Factory<N> arrayFactory) {
        return LongToNumberMap.factory(arrayFactory).make();
    }

    @Deprecated
    public static LongToNumberMap<BigDecimal> makeBig() {
        return LongToNumberMap.factory(BigArray.FACTORY).make();
    }

    @Deprecated
    public static LongToNumberMap<ComplexNumber> makeComplex() {
        return LongToNumberMap.factory(ComplexArray.FACTORY).make();
    }

    @Deprecated
    public static LongToNumberMap<Double> makePrimitive() {
        return LongToNumberMap.factory(Primitive64Array.FACTORY).make();
    }

    @Deprecated
    public static LongToNumberMap<Quaternion> makeQuaternion() {
        return LongToNumberMap.factory(QuaternionArray.FACTORY).make();
    }

    @Deprecated
    public static LongToNumberMap<RationalNumber> makeRational() {
        return LongToNumberMap.factory(RationalArray.FACTORY).make();
    }

    LongToNumberMap(DenseStrategy<N> strategy) {
        this.myStrategy = strategy;
        this.myStorage = new SparseArray<N>(Long.MAX_VALUE, strategy);
    }

    public long capacity() {
        return this.myStorage.capacity();
    }

    @Override
    public void clear() {
        this.myStorage.reset();
    }

    @Override
    public Comparator<? super Long> comparator() {
        return null;
    }

    public boolean containsKey(long key) {
        return this.myStorage.index(key) >= 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Number) {
            return this.containsKey(((Number)key).longValue());
        }
        return false;
    }

    public boolean containsValue(double value) {
        for (SparseArray.NonzeroView nonzeroView : this.myStorage.nonzeros()) {
            if (Double.compare(nonzeroView.doubleValue(), value) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (SparseArray.NonzeroView nonzeroView : this.myStorage.nonzeros()) {
            if (!value.equals(nonzeroView.getNumber())) continue;
            return true;
        }
        return false;
    }

    @Override
    public long count() {
        return this.myStorage.getActualLength();
    }

    @Override
    public double doubleValue(long key) {
        int tmpIndex = this.myStorage.index(key);
        if (tmpIndex >= 0) {
            return this.myStorage.doubleValueInternally(tmpIndex);
        }
        return Double.NaN;
    }

    @Override
    public Set<Map.Entry<Long, N>> entrySet() {
        return new AbstractSet<Map.Entry<Long, N>>(){

            @Override
            public Iterator<Map.Entry<Long, N>> iterator() {
                return new Iterator<Map.Entry<Long, N>>(){
                    SparseArray.NonzeroView<N> tmpNonzeros;
                    {
                        this.tmpNonzeros = LongToNumberMap.this.myStorage.nonzeros();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.tmpNonzeros.hasNext();
                    }

                    @Override
                    public Map.Entry<Long, N> next() {
                        this.tmpNonzeros.next();
                        return new Map.Entry<Long, N>(){

                            @Override
                            public Long getKey() {
                                return tmpNonzeros.index();
                            }

                            @Override
                            public N getValue() {
                                return tmpNonzeros.getNumber();
                            }

                            @Override
                            public N setValue(N value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return LongToNumberMap.this.myStorage.getActualLength();
            }
        };
    }

    @Override
    public Long firstKey() {
        return this.myStorage.firstIndex();
    }

    @Override
    public N get(long key) {
        int tmpIndex = this.myStorage.index(key);
        if (tmpIndex >= 0) {
            return this.myStorage.getInternally(tmpIndex);
        }
        return null;
    }

    @Override
    public N get(Object key) {
        return key instanceof Number ? (N)this.get(((Number)key).longValue()) : null;
    }

    public LongToNumberMap<N> headMap(long toKey) {
        return this.subMap(this.myStorage.firstIndex(), toKey);
    }

    public LongToNumberMap<N> headMap(Long toKey) {
        return this.headMap((long)toKey);
    }

    @Override
    public boolean isEmpty() {
        return this.myStorage.getActualLength() == 0;
    }

    @Override
    public Set<Long> keySet() {
        return new AbstractSet<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return LongToNumberMap.this.myStorage.indices().iterator();
            }

            @Override
            public int size() {
                return LongToNumberMap.this.myStorage.getActualLength();
            }
        };
    }

    @Override
    public Long lastKey() {
        return this.myStorage.lastIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double mix(long key, BinaryFunction<N> mixer, double addend) {
        Objects.requireNonNull(mixer);
        SparseArray<N> sparseArray = this.myStorage;
        synchronized (sparseArray) {
            int tmpIndex = this.myStorage.index(key);
            double oldValue = tmpIndex >= 0 ? this.myStorage.doubleValueInternally(tmpIndex) : Double.NaN;
            double newValue = tmpIndex >= 0 ? mixer.invoke(oldValue, addend) : addend;
            this.myStorage.doSet(key, tmpIndex, newValue, true);
            return newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N mix(long key, BinaryFunction<N> mixer, N addend) {
        Objects.requireNonNull(mixer);
        SparseArray<N> sparseArray = this.myStorage;
        synchronized (sparseArray) {
            int tmpIndex = this.myStorage.index(key);
            Object oldValue = tmpIndex >= 0 ? (Object)this.myStorage.getInternally(tmpIndex) : null;
            N newValue = tmpIndex >= 0 ? mixer.invoke(oldValue, addend) : addend;
            this.myStorage.doSet(key, tmpIndex, (Number)newValue, true);
            return newValue;
        }
    }

    @Override
    public double put(long key, double value) {
        int tmpIndex = this.myStorage.index(key);
        double tmpOldValue = tmpIndex >= 0 ? this.myStorage.doubleValueInternally(tmpIndex) : Double.NaN;
        this.myStorage.doSet(key, tmpIndex, value, true);
        return tmpOldValue;
    }

    @Override
    public N put(long key, N value) {
        int tmpIndex = this.myStorage.index(key);
        N tmpOldValue = tmpIndex >= 0 ? (N)this.myStorage.getInternally(tmpIndex) : null;
        this.myStorage.doSet(key, tmpIndex, (Number)value, true);
        return tmpOldValue;
    }

    @Override
    public N put(Long key, N value) {
        return this.put((long)key, value);
    }

    public void putAll(LongToNumberMap<N> m) {
        if (this.myStorage.isPrimitive()) {
            for (SparseArray.NonzeroView nonzeroView : m.getStorage().nonzeros()) {
                this.myStorage.set(nonzeroView.index(), nonzeroView.doubleValue());
            }
        } else {
            for (SparseArray.NonzeroView nonzeroView : m.getStorage().nonzeros()) {
                this.myStorage.set(nonzeroView.index(), (Number)nonzeroView.getNumber());
            }
        }
    }

    @Override
    public void putAll(Map<? extends Long, ? extends N> m) {
        for (Map.Entry<Long, N> tmpEntry : m.entrySet()) {
            this.myStorage.set((long)tmpEntry.getKey(), (Number)tmpEntry.getValue());
        }
    }

    public N remove(long key) {
        N tmpOldVal = this.myStorage.get(key);
        this.myStorage.set(key, 0.0);
        return tmpOldVal;
    }

    @Override
    public N remove(Object key) {
        if (key instanceof Number) {
            return this.remove(((Number)key).longValue());
        }
        return null;
    }

    @Override
    public int size() {
        return this.myStorage.getActualLength();
    }

    public LongToNumberMap<N> subMap(long fromKey, long toKey) {
        LongToNumberMap retVal = new LongToNumberMap(this.myStrategy);
        for (SparseArray.NonzeroView nonzeroView : this.myStorage.nonzeros()) {
            long tmpKey = nonzeroView.index();
            if (fromKey > tmpKey || tmpKey >= toKey) continue;
            Object tmpValue = nonzeroView.getNumber();
            retVal.put(tmpKey, (N)tmpValue);
        }
        return retVal;
    }

    public LongToNumberMap<N> subMap(Long fromKey, Long toKey) {
        return this.subMap((long)fromKey, (long)toKey);
    }

    public LongToNumberMap<N> tailMap(long fromKey) {
        return this.subMap(fromKey, this.myStorage.lastIndex() + 1L);
    }

    public LongToNumberMap<N> tailMap(Long fromKey) {
        return this.tailMap((long)fromKey);
    }

    @Override
    public NumberList<N> values() {
        return new NumberList<N>(this.myStorage.getValues(), this.myStrategy, this.myStorage.getActualLength());
    }

    public Access1D<N> values(long fromKey, long toKey) {
        return this.myStorage.getValues(fromKey, toKey);
    }

    SparseArray<N> getStorage() {
        return this.myStorage;
    }

    public static final class MapFactory<N extends Number>
    extends StrategyBuilder<N, LongToNumberMap<N>, MapFactory<N>> {
        MapFactory(DenseArray.Factory<N> denseFactory) {
            super(denseFactory);
        }

        @Override
        public LongToNumberMap<N> make() {
            return new LongToNumberMap(this.getStrategy());
        }
    }
}

