# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network watcher troubleshooting start",
)
class Start(AAZCommand):
    """Troubleshoot issues with VPN connections or gateway connectivity.

    :example: Start a troubleshooting operation on a VPN Connection.
        az network watcher troubleshooting start -g MyResourceGroup --resource MyVPNConnection --resource-type vpnConnection --storage-account MyStorageAccount --storage-path https://{storageAccountName}.blob.core.windows.net/{containerName}
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkwatchers/{}/troubleshoot", "2022-01-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.watcher_name = AAZStrArg(
            options=["--watcher-name"],
            help="Name of the network watcher.",
            required=True,
            id_part="name",
        )
        _args_schema.watcher_rg = AAZResourceGroupNameArg(
            options=["--watcher-rg"],
            help="Name of the resource group the watcher is in.",
            required=True,
        )
        _args_schema.storage_account = AAZStrArg(
            options=["--storage-account"],
            help="Name or ID of the storage account in which to store the troubleshooting results.",
            required=True,
        )
        _args_schema.storage_path = AAZStrArg(
            options=["--storage-path"],
            help="Fully qualified URI to the storage blob container in which to store the troubleshooting results.",
            required=True,
        )

        # define Arg Group "Parameters"

        _args_schema = cls._args_schema
        _args_schema.target_resource_id = AAZStrArg(
            options=["--target-resource-id"],
            arg_group="Parameters",
            help="The target resource to troubleshoot.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.NetworkWatchersGetTroubleshooting(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class NetworkWatchersGetTroubleshooting(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/troubleshoot",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.watcher_rg,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})
            _builder.set_prop("targetResourceId", AAZStrType, ".target_resource_id", typ_kwargs={"flags": {"required": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("storageId", AAZStrType, ".storage_account", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("storagePath", AAZStrType, ".storage_path", typ_kwargs={"flags": {"required": True}})

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _StartHelper._build_schema_troubleshooting_result_read(cls._schema_on_200)

            return cls._schema_on_200


class _StartHelper:
    """Helper class for Start"""

    _schema_troubleshooting_result_read = None

    @classmethod
    def _build_schema_troubleshooting_result_read(cls, _schema):
        if cls._schema_troubleshooting_result_read is not None:
            _schema.code = cls._schema_troubleshooting_result_read.code
            _schema.end_time = cls._schema_troubleshooting_result_read.end_time
            _schema.results = cls._schema_troubleshooting_result_read.results
            _schema.start_time = cls._schema_troubleshooting_result_read.start_time
            return

        cls._schema_troubleshooting_result_read = _schema_troubleshooting_result_read = AAZObjectType()

        troubleshooting_result_read = _schema_troubleshooting_result_read
        troubleshooting_result_read.code = AAZStrType()
        troubleshooting_result_read.end_time = AAZStrType(
            serialized_name="endTime",
        )
        troubleshooting_result_read.results = AAZListType()
        troubleshooting_result_read.start_time = AAZStrType(
            serialized_name="startTime",
        )

        results = _schema_troubleshooting_result_read.results
        results.Element = AAZObjectType()

        _element = _schema_troubleshooting_result_read.results.Element
        _element.detail = AAZStrType()
        _element.id = AAZStrType()
        _element.reason_type = AAZStrType(
            serialized_name="reasonType",
        )
        _element.recommended_actions = AAZListType(
            serialized_name="recommendedActions",
        )
        _element.summary = AAZStrType()

        recommended_actions = _schema_troubleshooting_result_read.results.Element.recommended_actions
        recommended_actions.Element = AAZObjectType()

        _element = _schema_troubleshooting_result_read.results.Element.recommended_actions.Element
        _element.action_id = AAZStrType(
            serialized_name="actionId",
        )
        _element.action_text = AAZStrType(
            serialized_name="actionText",
        )
        _element.action_uri = AAZStrType(
            serialized_name="actionUri",
        )
        _element.action_uri_text = AAZStrType(
            serialized_name="actionUriText",
        )

        _schema.code = cls._schema_troubleshooting_result_read.code
        _schema.end_time = cls._schema_troubleshooting_result_read.end_time
        _schema.results = cls._schema_troubleshooting_result_read.results
        _schema.start_time = cls._schema_troubleshooting_result_read.start_time


__all__ = ["Start"]
