/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class SparkPageRank$ {
    public static final SparkPageRank$ MODULE$ = new SparkPageRank$();

    public void showWarning() {
        System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of PageRank and is given as an example!\n        |Please use the PageRank implementation found in org.apache.spark.graphx.lib.PageRank\n        |for more conventional use.\n      ")));
    }

    public void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: SparkPageRank <file> <iter>");
            System.exit(1);
        }
        this.showWarning();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("SparkPageRank").getOrCreate();
        int iters = args.length > 1 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[1])) : 10;
        RDD lines = spark.read().textFile(args[0]).rdd();
        RDD links = RDD$.MODULE$.rddToPairRDDFunctions(lines.map((Function1 & Serializable)s -> {
            String[] parts = s.split("\\s+");
            return new Tuple2((Object)parts[0], (Object)parts[1]);
        }, ClassTag$.MODULE$.apply(Tuple2.class)).distinct(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.String$.MODULE$).groupByKey().cache();
        ObjectRef ranks = ObjectRef.create((Object)RDD$.MODULE$.rddToPairRDDFunctions(links, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).mapValues((Function1 & Serializable)v -> BoxesRunTime.boxToDouble((double)SparkPageRank$.$anonfun$main$2(v))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), iters).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            RDD contribs = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(links, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).join((RDD)ranks$1.elem), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.String$.MODULE$).values().flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Iterable urls = (Iterable)tuple2._1();
                    double rank = tuple2._2$mcD$sp();
                    int size = urls.size();
                    return (Iterable)urls.map((Function1 & Serializable)url -> new Tuple2(url, (Object)BoxesRunTime.boxToDouble((double)(rank / (double)size))));
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            ranks$1.elem = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(contribs, ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Double(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcDDD.sp & Serializable)(x$1, x$2) -> x$1 + x$2), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Double(), (Ordering)Ordering.String$.MODULE$).mapValues((Function1)(JFunction1.mcDD.sp & Serializable)x$3 -> 0.15 + 0.85 * x$3);
        });
        Tuple2[] output = (Tuple2[])((RDD)ranks.elem).collect();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])output), (Function1 & Serializable)tup -> {
            Predef$.MODULE$.println((Object)(tup._1() + " has rank:  " + tup._2$mcD$sp() + " ."));
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    public static final /* synthetic */ double $anonfun$main$2(Iterable v) {
        return 1.0;
    }

    private SparkPageRank$() {
    }
}

