/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.DateAdd;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NonNullLiteral$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.optimizer.UnwrapCastInBinaryComparison$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.types.PhysicalDataType$;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class UnwrapCastInBinaryComparison$
extends Rule<LogicalPlan> {
    public static final UnwrapCastInBinaryComparison$ MODULE$ = new UnwrapCastInBinaryComparison$();

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return (LogicalPlan)plan2.transformWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.containsAnyPattern((Seq<Enumeration.Value>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.BINARY_COMPARISON(), TreePattern$.MODULE$.IN(), TreePattern$.MODULE$.INSET()}))), this.ruleId(), new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    return (B1)A12.transformExpressionsUpWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.2.$anonfun$applyOrElse$1(x$2)), UnwrapCastInBinaryComparison$.MODULE$.ruleId(), (PartialFunction<Expression, Expression>)new Serializable(null){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            BinaryComparison binaryComparison;
                            Option<Tuple2<Expression, Expression>> option;
                            A1 A1 = x1;
                            if (A1 instanceof BinaryComparison && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison = (BinaryComparison)A1)).isEmpty() ? true : (A1 instanceof In ? true : A1 instanceof InSet)) {
                                return (B1)UnwrapCastInBinaryComparison$.MODULE$.org$apache$spark$sql$catalyst$optimizer$UnwrapCastInBinaryComparison$$unwrapCast(A1).getOrElse((Function0 & Serializable)() -> A1);
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            BinaryComparison binaryComparison;
                            Option<Tuple2<Expression, Expression>> option;
                            Expression expression = x1;
                            return expression instanceof BinaryComparison && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty() ? true : (expression instanceof In ? true : expression instanceof InSet);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
                        }
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan != null;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(TreePatternBits x$2) {
                return x$2.containsAnyPattern((Seq<Enumeration.Value>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.BINARY_COMPARISON(), TreePattern$.MODULE$.IN(), TreePattern$.MODULE$.INSET()}));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.trees.TreePatternBits )}, serializedLambda);
            }
        });
    }

    public Option<Expression> org$apache$spark$sql$catalyst$optimizer$UnwrapCastInBinaryComparison$$unwrapCast(Expression exp) {
        Option<Tuple2<Expression, Expression>> option;
        Option<Tuple2<Expression, Expression>> option2;
        Option<Tuple2<Expression, Expression>> option3;
        Option<Tuple2<Expression, Expression>> option4;
        boolean bl = false;
        BinaryComparison binaryComparison = null;
        Expression expression = exp;
        if (expression instanceof BinaryComparison) {
            bl = true;
            binaryComparison = (BinaryComparison)expression;
            Option<Tuple2<Expression, Expression>> option5 = BinaryComparison$.MODULE$.unapply(binaryComparison);
            if (!option5.isEmpty() && ((Tuple2)option5.get())._1() instanceof Literal && ((Tuple2)option5.get())._2() instanceof Cast) {
                return this.org$apache$spark$sql$catalyst$optimizer$UnwrapCastInBinaryComparison$$unwrapCast(UnwrapCastInBinaryComparison$.swap$1(exp)).map((Function1 & Serializable)e -> UnwrapCastInBinaryComparison$.swap$1(e));
            }
        }
        if (bl && !(option4 = BinaryComparison$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression expression2 = (Expression)((Tuple2)option4.get())._1();
            Expression expression3 = (Expression)((Tuple2)option4.get())._2();
            if (expression2 instanceof Cast) {
                Cast cast = (Cast)expression2;
                Expression fromExp = cast.child();
                DataType toType = cast.dataType();
                if (toType instanceof NumericType) {
                    NumericType numericType = (NumericType)toType;
                    if (expression3 instanceof Literal) {
                        Literal literal = (Literal)expression3;
                        Object value = literal.value();
                        DataType literalType = literal.dataType();
                        if (this.canImplicitlyCast(fromExp, (DataType)numericType, literalType) && value != null) {
                            return new Some((Object)this.simplifyNumericComparison(binaryComparison, fromExp, numericType, value));
                        }
                    }
                }
            }
        }
        if (bl && !(option3 = BinaryComparison$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression expression4 = (Expression)((Tuple2)option3.get())._1();
            Expression date = (Expression)((Tuple2)option3.get())._2();
            if (expression4 instanceof Cast) {
                Cast cast = (Cast)expression4;
                Expression fromExp = cast.child();
                Option<String> timeZoneId = cast.timeZoneId();
                Enumeration.Value evalMode = cast.evalMode();
                if (date instanceof Literal) {
                    Literal literal = (Literal)date;
                    Object value = literal.value();
                    DataType dataType = literal.dataType();
                    if (DateType$.MODULE$.equals(dataType) && AnyTimestampType$.MODULE$.acceptsType(fromExp.dataType()) && value != null) {
                        return new Some((Object)this.unwrapDateToTimestamp(binaryComparison, fromExp, literal, timeZoneId, evalMode));
                    }
                }
            }
        }
        if (bl && !(option2 = BinaryComparison$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression expression5 = (Expression)((Tuple2)option2.get())._1();
            Expression ts = (Expression)((Tuple2)option2.get())._2();
            if (expression5 instanceof Cast) {
                Cast cast = (Cast)expression5;
                Expression fromExp = cast.child();
                Option<String> timeZoneId = cast.timeZoneId();
                Enumeration.Value evalMode = cast.evalMode();
                if (ts instanceof Literal) {
                    Literal literal = (Literal)ts;
                    Object value = literal.value();
                    DataType dataType = fromExp.dataType();
                    DateType$ dateType$ = DateType$.MODULE$;
                    if (!(dataType != null ? !dataType.equals(dateType$) : dateType$ != null)) {
                        if (AnyTimestampType$.MODULE$.acceptsType(literal.dataType()) && value != null) {
                            return new Some((Object)this.unwrapTimestampToDate(binaryComparison, fromExp, literal, timeZoneId, evalMode));
                        }
                    }
                }
            }
        }
        if (bl && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression c = (Expression)((Tuple2)option.get())._1();
            Expression expression6 = (Expression)((Tuple2)option.get())._2();
            if (c instanceof Cast) {
                Cast cast = (Cast)c;
                Expression fromExp = cast.child();
                Option<String> timeZoneId = cast.timeZoneId();
                Enumeration.Value evalMode = cast.evalMode();
                if (expression6 instanceof Literal) {
                    Literal literal = (Literal)expression6;
                    Object value = literal.value();
                    DataType literalType = literal.dataType();
                    if (AnyTimestampType$.MODULE$.acceptsType(fromExp.dataType()) && AnyTimestampType$.MODULE$.acceptsType(literalType) && value != null) {
                        Cast newCast = new Cast(new Literal(value, literalType), fromExp.dataType(), timeZoneId, evalMode);
                        Cast roundTrip = new Cast(newCast, literalType, timeZoneId, evalMode);
                        if (BoxesRunTime.unboxToLong((Object)roundTrip.eval(roundTrip.eval$default$1())) == BoxesRunTime.unboxToLong((Object)value)) {
                            Expression newExpr = (Expression)binaryComparison.withNewChildren(new .colon.colon((Object)fromExp, (List)new .colon.colon((Object)newCast, (List)Nil$.MODULE$)));
                            return new Some((Object)newExpr);
                        }
                        return None$.MODULE$;
                    }
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression expression7 = in.value();
            Seq<Expression> list = in.list();
            if (expression7 instanceof Cast) {
                Cast cast = (Cast)expression7;
                Expression fromExp = cast.child();
                DataType toType = cast.dataType();
                Option<String> tz = cast.timeZoneId();
                Enumeration.Value mode = cast.evalMode();
                if (toType instanceof NumericType) {
                    Expression firstLit;
                    SeqOps seqOps;
                    NumericType numericType = (NumericType)toType;
                    if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) >= 0 && this.canImplicitlyCast(fromExp, (DataType)numericType, (firstLit = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)).dataType()) && in.inSetConvertible()) {
                        Function2 & Serializable buildIn = (Function2 & Serializable)(nullList, canCastList) -> {
                            ArrayBuffer newList = (ArrayBuffer)((IterableOps)nullList.map((Function1 & Serializable)lit -> new Cast((Expression)lit, fromExp.dataType(), tz, mode))).$plus$plus((IterableOnce)canCastList);
                            return new In(fromExp, (Seq<Expression>)newList.toSeq());
                        };
                        return this.simplifyIn(fromExp, numericType, list, buildIn);
                    }
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression expression8 = inSet.child();
            Set<Object> hset = inSet.hset();
            if (expression8 instanceof Cast) {
                Cast cast = (Cast)expression8;
                Expression fromExp = cast.child();
                DataType toType = cast.dataType();
                if (toType instanceof NumericType) {
                    NumericType numericType = (NumericType)toType;
                    if (hset.nonEmpty() && this.canImplicitlyCast(fromExp, (DataType)numericType, (DataType)numericType)) {
                        Function2 & Serializable buildInSet = (Function2 & Serializable)(nullList, canCastList) -> new InSet(fromExp, (Set<Object>)((IterableOnceOps)((StrictOptimizedIterableOps)nullList.$plus$plus((IterableOnce)canCastList)).map((Function1 & Serializable)x$3 -> x$3.value())).toSet());
                        return this.simplifyIn(fromExp, numericType, (Seq<Expression>)((IterableOnceOps)hset.map((Function1 & Serializable)v -> Literal$.MODULE$.create(v, (DataType)numericType))).toSeq(), buildInSet);
                    }
                }
            }
        }
        return None$.MODULE$;
    }

    private Expression simplifyNumericComparison(BinaryComparison exp, Expression fromExp, NumericType toType, Object value) {
        InternalRow x$3;
        Cast qual$3;
        Object newValue;
        DataType fromType = fromExp.dataType();
        Ordering<Object> ordering = PhysicalDataType$.MODULE$.ordering((DataType)toType);
        Option<Tuple2<Object, Object>> range = this.getRange(fromType);
        if (range.isDefined()) {
            Tuple2 tuple2 = (Tuple2)range.get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object min = tuple2._1();
            Object max = tuple2._2();
            Tuple2 tuple22 = new Tuple2(min, max);
            Object min2 = tuple22._1();
            Object max2 = tuple22._2();
            Cast qual$1 = new Cast(Literal$.MODULE$.apply(min2), (DataType)toType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            Cast qual$2 = new Cast(Literal$.MODULE$.apply(max2), (DataType)toType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            InternalRow x$2 = qual$2.eval$default$1();
            Tuple2 tuple23 = new Tuple2(qual$1.eval(x$1), qual$2.eval(x$2));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Object minInToType = tuple23._1();
            Object maxInToType = tuple23._2();
            Tuple2 tuple24 = new Tuple2(minInToType, maxInToType);
            Object minInToType2 = tuple24._1();
            Object maxInToType2 = tuple24._2();
            int minCmp = ordering.compare(value, minInToType2);
            int maxCmp = ordering.compare(value, maxInToType2);
            if (maxCmp >= 0 || minCmp <= 0) {
                if (maxCmp > 0) {
                    BinaryComparison binaryComparison = exp;
                    if (binaryComparison instanceof EqualTo ? true : (binaryComparison instanceof GreaterThan ? true : binaryComparison instanceof GreaterThanOrEqual)) {
                        return this.falseIfNotNull(fromExp);
                    }
                    if (binaryComparison instanceof LessThan ? true : binaryComparison instanceof LessThanOrEqual) {
                        return this.trueIfNotNull(fromExp);
                    }
                    if (binaryComparison instanceof EqualNullSafe && exp.deterministic()) {
                        return Literal$.MODULE$.FalseLiteral();
                    }
                    return exp;
                }
                if (maxCmp == 0) {
                    BinaryComparison binaryComparison = exp;
                    if (binaryComparison instanceof GreaterThan) {
                        return this.falseIfNotNull(fromExp);
                    }
                    if (binaryComparison instanceof LessThanOrEqual) {
                        return this.trueIfNotNull(fromExp);
                    }
                    if (binaryComparison instanceof LessThan) {
                        return new Not(new EqualTo(fromExp, new Literal(max2, fromType)));
                    }
                    if (binaryComparison instanceof GreaterThanOrEqual ? true : binaryComparison instanceof EqualTo) {
                        return new EqualTo(fromExp, new Literal(max2, fromType));
                    }
                    if (binaryComparison instanceof EqualNullSafe) {
                        return new EqualNullSafe(fromExp, new Literal(max2, fromType));
                    }
                    return exp;
                }
                if (minCmp < 0) {
                    BinaryComparison binaryComparison = exp;
                    if (binaryComparison instanceof GreaterThan ? true : binaryComparison instanceof GreaterThanOrEqual) {
                        return this.trueIfNotNull(fromExp);
                    }
                    if (binaryComparison instanceof LessThan ? true : (binaryComparison instanceof LessThanOrEqual ? true : binaryComparison instanceof EqualTo)) {
                        return this.falseIfNotNull(fromExp);
                    }
                    if (binaryComparison instanceof EqualNullSafe && exp.deterministic()) {
                        return Literal$.MODULE$.FalseLiteral();
                    }
                    return exp;
                }
                BinaryComparison binaryComparison = exp;
                if (binaryComparison instanceof LessThan) {
                    return this.falseIfNotNull(fromExp);
                }
                if (binaryComparison instanceof GreaterThanOrEqual) {
                    return this.trueIfNotNull(fromExp);
                }
                if (binaryComparison instanceof GreaterThan) {
                    return new Not(new EqualTo(fromExp, new Literal(min2, fromType)));
                }
                if (binaryComparison instanceof LessThanOrEqual ? true : binaryComparison instanceof EqualTo) {
                    return new EqualTo(fromExp, new Literal(min2, fromType));
                }
                if (binaryComparison instanceof EqualNullSafe) {
                    return new EqualNullSafe(fromExp, new Literal(min2, fromType));
                }
                return exp;
            }
        }
        if ((newValue = (qual$3 = Cast$.MODULE$.apply(Literal$.MODULE$.apply(value), fromType, false)).eval(x$3 = qual$3.eval$default$1())) == null) {
            return exp;
        }
        Cast qual$4 = new Cast(new Literal(newValue, fromType), (DataType)toType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        InternalRow x$4 = qual$4.eval$default$1();
        Object valueRoundTrip = qual$4.eval(x$4);
        Literal lit = new Literal(newValue, fromType);
        int cmp = ordering.compare(value, valueRoundTrip);
        if (cmp == 0) {
            BinaryComparison binaryComparison = exp;
            if (binaryComparison instanceof GreaterThan) {
                return new GreaterThan(fromExp, lit);
            }
            if (binaryComparison instanceof GreaterThanOrEqual) {
                return new GreaterThanOrEqual(fromExp, lit);
            }
            if (binaryComparison instanceof EqualTo) {
                return new EqualTo(fromExp, lit);
            }
            if (binaryComparison instanceof EqualNullSafe) {
                return new EqualNullSafe(fromExp, lit);
            }
            if (binaryComparison instanceof LessThan) {
                return new LessThan(fromExp, lit);
            }
            if (binaryComparison instanceof LessThanOrEqual) {
                return new LessThanOrEqual(fromExp, lit);
            }
            return exp;
        }
        if (cmp < 0) {
            BinaryComparison binaryComparison = exp;
            if (binaryComparison instanceof EqualTo) {
                return this.falseIfNotNull(fromExp);
            }
            if (binaryComparison instanceof EqualNullSafe && fromExp.deterministic()) {
                return Literal$.MODULE$.FalseLiteral();
            }
            if (binaryComparison instanceof GreaterThan ? true : binaryComparison instanceof GreaterThanOrEqual) {
                return new GreaterThanOrEqual(fromExp, lit);
            }
            if (binaryComparison instanceof LessThan ? true : binaryComparison instanceof LessThanOrEqual) {
                return new LessThan(fromExp, lit);
            }
            return exp;
        }
        BinaryComparison binaryComparison = exp;
        if (binaryComparison instanceof EqualTo) {
            return this.falseIfNotNull(fromExp);
        }
        if (binaryComparison instanceof EqualNullSafe) {
            return Literal$.MODULE$.FalseLiteral();
        }
        if (binaryComparison instanceof GreaterThan ? true : binaryComparison instanceof GreaterThanOrEqual) {
            return new GreaterThan(fromExp, lit);
        }
        if (binaryComparison instanceof LessThan ? true : binaryComparison instanceof LessThanOrEqual) {
            return new LessThanOrEqual(fromExp, lit);
        }
        return exp;
    }

    private Expression unwrapDateToTimestamp(BinaryComparison exp, Expression fromExp, Literal date, Option<String> tz, Enumeration.Value evalMode) {
        EqualNullSafe equalNullSafe;
        Expression left;
        DateAdd dateAddOne = new DateAdd(date, new Literal(BoxesRunTime.boxToInteger((int)1), (DataType)IntegerType$.MODULE$));
        BinaryComparison binaryComparison = exp;
        if (binaryComparison instanceof GreaterThan) {
            return new GreaterThanOrEqual(fromExp, new Cast(dateAddOne, fromExp.dataType(), tz, evalMode));
        }
        if (binaryComparison instanceof GreaterThanOrEqual) {
            return new GreaterThanOrEqual(fromExp, new Cast(date, fromExp.dataType(), tz, evalMode));
        }
        if (binaryComparison instanceof EqualTo) {
            return new And(new GreaterThanOrEqual(fromExp, new Cast(date, fromExp.dataType(), tz, evalMode)), new LessThan(fromExp, new Cast(dateAddOne, fromExp.dataType(), tz, evalMode)));
        }
        if (binaryComparison instanceof EqualNullSafe && !(left = (equalNullSafe = (EqualNullSafe)binaryComparison).left()).nullable()) {
            return new And(new GreaterThanOrEqual(fromExp, new Cast(date, fromExp.dataType(), tz, evalMode)), new LessThan(fromExp, new Cast(dateAddOne, fromExp.dataType(), tz, evalMode)));
        }
        if (binaryComparison instanceof LessThan) {
            return new LessThan(fromExp, new Cast(date, fromExp.dataType(), tz, evalMode));
        }
        if (binaryComparison instanceof LessThanOrEqual) {
            return new LessThan(fromExp, new Cast(dateAddOne, fromExp.dataType(), tz, evalMode));
        }
        return exp;
    }

    private Expression unwrapTimestampToDate(BinaryComparison exp, Expression fromExp, Literal ts, Option<String> tz, Enumeration.Value evalMode) {
        DataType dataType = fromExp.dataType();
        DateType$ dateType$ = DateType$.MODULE$;
        Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(dateType$) : dateType$ != null));
        Cast qual$1 = new Cast(ts, (DataType)DateType$.MODULE$, tz, evalMode);
        InternalRow x$1 = qual$1.eval$default$1();
        Literal floorDate = new Literal(qual$1.eval(x$1), (DataType)DateType$.MODULE$);
        EqualTo qual$2 = new EqualTo(ts, new Cast(floorDate, ts.dataType(), tz, evalMode));
        InternalRow x$2 = qual$2.eval$default$1();
        boolean timePartsAllZero = BoxesRunTime.unboxToBoolean((Object)qual$2.eval(x$2));
        BinaryComparison binaryComparison = exp;
        if (binaryComparison instanceof GreaterThan) {
            return new GreaterThan(fromExp, floorDate);
        }
        if (binaryComparison instanceof LessThanOrEqual) {
            return new LessThanOrEqual(fromExp, floorDate);
        }
        if (binaryComparison instanceof GreaterThanOrEqual) {
            if (!timePartsAllZero) {
                return new GreaterThan(fromExp, floorDate);
            }
            return new GreaterThanOrEqual(fromExp, floorDate);
        }
        if (binaryComparison instanceof LessThan) {
            if (!timePartsAllZero) {
                return new LessThanOrEqual(fromExp, floorDate);
            }
            return new LessThan(fromExp, floorDate);
        }
        if (binaryComparison instanceof EqualTo) {
            if (timePartsAllZero) {
                return new EqualTo(fromExp, floorDate);
            }
            return this.falseIfNotNull(fromExp);
        }
        if (binaryComparison instanceof EqualNullSafe) {
            if (timePartsAllZero) {
                return new EqualNullSafe(fromExp, floorDate);
            }
            return Literal$.MODULE$.FalseLiteral();
        }
        return exp;
    }

    private <IN extends Expression> Option<Expression> simplifyIn(Expression fromExp, NumericType toType, Seq<Expression> list, Function2<ArrayBuffer<Literal>, ArrayBuffer<Literal>, IN> buildExpr) {
        Tuple2 tuple2 = new Tuple2(ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ArrayBuffer nullList = (ArrayBuffer)tuple2._1();
        ArrayBuffer canCastList = (ArrayBuffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nullList, (Object)canCastList);
        ArrayBuffer nullList2 = (ArrayBuffer)tuple22._1();
        ArrayBuffer canCastList2 = (ArrayBuffer)tuple22._2();
        DataType fromType = fromExp.dataType();
        Ordering<Object> ordering = PhysicalDataType$.MODULE$.ordering((DataType)toType);
        list.foreach((Function1 & Serializable)x0$1 -> {
            Option<Tuple2<Object, DataType>> option;
            boolean bl = false;
            Literal literal = null;
            Expression expression = x0$1;
            if (expression instanceof Literal) {
                bl = true;
                literal = (Literal)expression;
                Object object = literal.value();
                if (object == null) {
                    return nullList2.$plus$eq((Object)literal);
                }
            }
            if (bl && !(option = NonNullLiteral$.MODULE$.unapply(literal)).isEmpty()) {
                Object value = ((Tuple2)option.get())._1();
                Cast qual$1 = Cast$.MODULE$.apply(Literal$.MODULE$.apply(value), fromType, false);
                InternalRow x$1 = qual$1.eval$default$1();
                Object newValue = qual$1.eval(x$1);
                Cast qual$2 = new Cast(new Literal(newValue, fromType), (DataType)toType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                InternalRow x$2 = qual$2.eval$default$1();
                Object valueRoundTrip = qual$2.eval(x$2);
                if (newValue != null && ordering.compare(value, valueRoundTrip) == 0) {
                    return canCastList2.$plus$eq((Object)new Literal(newValue, fromType));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)expression);
        });
        if (nullList2.isEmpty() && canCastList2.isEmpty()) {
            return Option$.MODULE$.apply((Object)this.falseIfNotNull(fromExp));
        }
        Expression unwrapExpr = (Expression)buildExpr.apply((Object)nullList2, (Object)canCastList2);
        return Option$.MODULE$.apply((Object)unwrapExpr);
    }

    private boolean canImplicitlyCast(Expression fromExp, DataType toType, DataType literalType) {
        return DataTypeUtils$.MODULE$.sameType(toType, literalType) && !fromExp.foldable() && toType instanceof NumericType && this.canUnwrapCast(fromExp.dataType(), toType);
    }

    private boolean canUnwrapCast(DataType from, DataType to) {
        DataType dataType;
        Tuple2 tuple2 = new Tuple2((Object)from, (Object)to);
        if (tuple2 != null && BooleanType$.MODULE$.equals(dataType = (DataType)tuple2._1())) {
            return true;
        }
        if (tuple2 != null) {
            DataType dataType2 = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType2) && FloatType$.MODULE$.equals(dataType3)) {
                return false;
            }
        }
        if (tuple2 != null) {
            DataType dataType4 = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (LongType$.MODULE$.equals(dataType4) && FloatType$.MODULE$.equals(dataType5)) {
                return false;
            }
        }
        if (tuple2 != null) {
            DataType dataType6 = (DataType)tuple2._1();
            DataType dataType7 = (DataType)tuple2._2();
            if (LongType$.MODULE$.equals(dataType6) && DoubleType$.MODULE$.equals(dataType7)) {
                return false;
            }
        }
        if (from instanceof NumericType) {
            return Cast$.MODULE$.canUpCast(from, to);
        }
        return false;
    }

    public Option<Tuple2<Object, Object>> getRange(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new Tuple2.mcZZ.sp(false, true));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)-128), (Object)BoxesRunTime.boxToByte((byte)127)));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)Short.MIN_VALUE), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new Some((Object)new Tuple2.mcII.sp(Integer.MIN_VALUE, Integer.MAX_VALUE));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new Some((Object)new Tuple2.mcJJ.sp(Long.MIN_VALUE, Long.MAX_VALUE));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY), (Object)BoxesRunTime.boxToFloat((float)Float.NaN)));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new Tuple2.mcDD.sp(Double.NEGATIVE_INFINITY, Double.NaN));
        }
        return None$.MODULE$;
    }

    public Expression falseIfNotNull(Expression e) {
        return new And(new IsNull(e), new Literal(null, (DataType)BooleanType$.MODULE$));
    }

    public Expression trueIfNotNull(Expression e) {
        return new Or(new IsNotNull(e), new Literal(null, (DataType)BooleanType$.MODULE$));
    }

    private static final Expression swap$1(Expression e) {
        Expression expression = e;
        if (expression instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)expression;
            Expression left = greaterThan.left();
            Expression right = greaterThan.right();
            return new LessThan(right, left);
        }
        if (expression instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
            Expression left = greaterThanOrEqual.left();
            Expression right = greaterThanOrEqual.right();
            return new LessThanOrEqual(right, left);
        }
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Expression left = equalTo.left();
            Expression right = equalTo.right();
            return new EqualTo(right, left);
        }
        if (expression instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)expression;
            Expression left = equalNullSafe.left();
            Expression right = equalNullSafe.right();
            return new EqualNullSafe(right, left);
        }
        if (expression instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
            Expression left = lessThanOrEqual.left();
            Expression right = lessThanOrEqual.right();
            return new GreaterThanOrEqual(right, left);
        }
        if (expression instanceof LessThan) {
            LessThan lessThan = (LessThan)expression;
            Expression left = lessThan.left();
            Expression right = lessThan.right();
            return new GreaterThan(right, left);
        }
        return e;
    }

    private UnwrapCastInBinaryComparison$() {
    }
}

