# Copyright 2017-2017 the nyan authors. See copying.md for legal info.
###############################################################################
# cmake configuration file for nyan.
# to be found by find_package(nyan).
#
###############################################################################
# this module provides:
#    nyan_VERSION      -- nyan library version number
#    nyan::nyan        -- target library to link to
#
# nyan automatically provides all paths and includedirs through cmake.
# this is done by the PUBLIC include_dir specification.
# usage:
#    find_package(nyan REQUIRED CONFIG)
#    target_link_libraries(your_target nyan::nyan)
###############################################################################


set(nyan_VERSION 0.3.0)



####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was nyanConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/nyan" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################


# include the target and library definitions
include("${CMAKE_CURRENT_LIST_DIR}/nyanTargets.cmake")
check_required_components(nyan)
