/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.file;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import crosby.binary.Fileformat;
import crosby.binary.file.FileBlock;
import crosby.binary.file.FileBlockBase;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class FileBlockPosition
extends FileBlockBase {
    protected int datasize;
    long data_offset;

    protected FileBlockPosition(String string, ByteString byteString) {
        super(string, byteString);
    }

    FileBlock parseData(byte[] byArray) throws InvalidProtocolBufferException {
        FileBlock fileBlock = FileBlock.newInstance(this.type, null, this.indexdata);
        Fileformat.Blob blob = Fileformat.Blob.parseFrom(byArray);
        if (blob.hasRaw()) {
            fileBlock.data = blob.getRaw();
        } else if (blob.hasZlibData()) {
            byte[] byArray2 = new byte[blob.getRawSize()];
            Inflater inflater = new Inflater();
            inflater.setInput(blob.getZlibData().toByteArray());
            try {
                inflater.inflate(byArray2);
            }
            catch (DataFormatException dataFormatException) {
                dataFormatException.printStackTrace();
                throw new Error(dataFormatException);
            }
            assert (inflater.finished());
            inflater.end();
            fileBlock.data = ByteString.copyFrom((byte[])byArray2);
        }
        return fileBlock;
    }

    public int getDatasize() {
        return this.datasize;
    }

    static FileBlockPosition newInstance(FileBlockBase fileBlockBase, long l, int n) {
        FileBlockPosition fileBlockPosition = new FileBlockPosition(fileBlockBase.type, fileBlockBase.indexdata);
        fileBlockPosition.datasize = n;
        fileBlockPosition.data_offset = l;
        return fileBlockPosition;
    }

    public FileBlock read(InputStream inputStream) throws IOException {
        if (inputStream instanceof FileInputStream) {
            ((FileInputStream)inputStream).getChannel().position(this.data_offset);
            byte[] byArray = new byte[this.getDatasize()];
            new DataInputStream(inputStream).readFully(byArray);
            return this.parseData(byArray);
        }
        throw new Error("Random access binary reads require seekability");
    }

    public ByteString serialize() {
        throw new Error("TODO");
    }

    static FileBlockPosition parseFrom(ByteString byteString) {
        throw new Error("TODO");
    }
}

