/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.tdbfmt;

import java.io.IOException;
import uk.me.parabola.io.StructuredInputStream;
import uk.me.parabola.io.StructuredOutputStream;

class CopyrightSegment {
    public static final int CODE_SOURCE_INFORMATION = 0;
    public static final int CODE_COPYRIGHT_TEXT_STRING = 6;
    public static final int CODE_COPYRIGHT_BITMAP_REFERENCE = 7;
    private final byte copyrightCode;
    private final byte whereCode;
    private final short extraProperties;
    private final String copyright;

    CopyrightSegment(StructuredInputStream ds) throws IOException {
        this.copyrightCode = (byte)ds.read();
        this.whereCode = (byte)ds.read();
        this.extraProperties = (short)ds.read2();
        this.copyright = ds.readString();
    }

    CopyrightSegment(int code, int where, String msg) {
        this.copyrightCode = (byte)code;
        this.whereCode = (byte)where;
        this.copyright = msg;
        this.extraProperties = 0;
    }

    public void write(StructuredOutputStream os) throws IOException {
        os.write(this.copyrightCode);
        os.write(this.whereCode);
        os.write2(this.extraProperties);
        os.writeString(this.copyright);
    }

    public String toString() {
        return "Copyright: " + this.copyrightCode + ", where=" + this.whereCode + ", extra=" + this.extraProperties + ": " + this.copyright;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CopyrightSegment)) {
            return false;
        }
        CopyrightSegment that = (CopyrightSegment)o;
        if (this.copyrightCode != that.copyrightCode) {
            return false;
        }
        if (this.extraProperties != that.extraProperties) {
            return false;
        }
        if (this.whereCode != that.whereCode) {
            return false;
        }
        return this.copyright.equals(that.copyright);
    }

    public int hashCode() {
        int result = this.copyrightCode;
        result = 31 * result + this.whereCode;
        result = 31 * result + this.extraProperties;
        result = 31 * result + this.copyright.hashCode();
        return result;
    }
}

