/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;

public class TYPHeader
extends CommonHeader {
    public static final int HEADER_LEN = 156;
    private char familyId;
    private char productId;
    private char codePage;
    private final Section pointData = new Section();
    private final Section lineData = new Section(this.pointData);
    private final Section polygonData = new Section(this.lineData);
    private final Section pointIndex = new Section(this.polygonData, 2);
    private final Section lineIndex = new Section(this.pointIndex, 2);
    private final Section polygonIndex = new Section(this.lineIndex, 2);
    private final Section shapeStacking = new Section(this.polygonIndex, 5);
    private final Section iconData = new Section(this.polygonIndex);
    private final Section iconIndex = new Section(this.iconData, 3);
    private final Section labels = new Section(this.iconIndex);
    private final Section stringIndex = new Section(this.labels);
    private final Section typeIndex = new Section(this.stringIndex);

    public TYPHeader() {
        super(156, "GARMIN TYP");
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) {
        reader.position(21L);
        this.codePage = (char)reader.get2u();
        this.pointData.setPosition(reader.get4());
        this.pointData.setSize(reader.get4());
        this.lineData.setPosition(reader.get4());
        this.lineData.setSize(reader.get4());
        this.polygonData.setPosition(reader.get4());
        this.polygonData.setSize(reader.get4());
        this.familyId = (char)reader.get2u();
        this.productId = (char)reader.get2u();
        this.pointIndex.setPosition(reader.get4());
        this.pointIndex.setItemSize(reader.get2u());
        this.pointIndex.setSize(reader.get4());
        this.lineIndex.setPosition(reader.get4());
        this.lineIndex.setItemSize(reader.get2u());
        this.lineIndex.setSize(reader.get4());
        this.polygonIndex.setPosition(reader.get4());
        this.polygonIndex.setItemSize(reader.get2u());
        this.polygonIndex.setSize(reader.get4());
        this.shapeStacking.setPosition(reader.get4());
        this.shapeStacking.setItemSize(reader.get2u());
        this.shapeStacking.setSize(reader.get4());
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        writer.put2u(this.codePage);
        this.pointData.writeSectionInfo(writer);
        this.lineData.writeSectionInfo(writer);
        this.polygonData.writeSectionInfo(writer);
        writer.put2u(this.familyId);
        writer.put2u(this.productId);
        this.writeSectionInfo(writer, this.pointIndex);
        this.writeSectionInfo(writer, this.lineIndex);
        this.writeSectionInfo(writer, this.polygonIndex);
        this.writeSectionInfo(writer, this.shapeStacking);
        if (this.getHeaderLength() > 91) {
            this.writeSectionInfo(writer, this.iconIndex);
            writer.put1u(19);
            this.iconData.writeSectionInfo(writer);
            writer.put4(0);
        }
        if (this.getHeaderLength() > 110) {
            this.labels.writeSectionInfo(writer);
            writer.put4(this.stringIndex.getItemSize());
            writer.put4(27);
            writer.put4(this.stringIndex.getPosition());
            writer.put4(this.stringIndex.getSize());
            writer.put4(this.typeIndex.getItemSize());
            writer.put4(27);
            writer.put4(this.typeIndex.getPosition());
            writer.put4(this.typeIndex.getSize());
            writer.put2u(0);
        }
    }

    private void writeSectionInfo(ImgFileWriter writer, Section section) {
        writer.put4(section.getPosition());
        writer.put2u(section.getItemSize());
        writer.put4(section.getSize());
    }

    void setCodePage(char codePage) {
        this.codePage = codePage;
    }

    Section getPointData() {
        return this.pointData;
    }

    void setFamilyId(char familyId) {
        this.familyId = familyId;
    }

    void setProductId(char productId) {
        this.productId = productId;
    }

    Section getPointIndex() {
        return this.pointIndex;
    }

    Section getShapeStacking() {
        return this.shapeStacking;
    }

    public Section getPolygonData() {
        return this.polygonData;
    }

    public Section getPolygonIndex() {
        return this.polygonIndex;
    }

    public Section getLineData() {
        return this.lineData;
    }

    public Section getLineIndex() {
        return this.lineIndex;
    }

    public Section getIconData() {
        return this.iconData;
    }

    public Section getIconIndex() {
        return this.iconIndex;
    }

    public Section getLabels() {
        return this.labels;
    }

    public Section getStringIndex() {
        return this.stringIndex;
    }

    public Section getTypeIndex() {
        return this.typeIndex;
    }
}

