/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.Objects;
import uk.me.parabola.imgfmt.app.net.NumberStyle;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;

public class Numbers {
    private static final Logger log = Logger.getLogger(Numbers.class);
    public static final boolean LEFT = true;
    public static final boolean RIGHT = false;
    private static final int MAX_DELTA = 131071;
    private int polishPointIndex;
    private int nodeIndex = -1;
    private RoadSide leftSide;
    private RoadSide rightSide;

    public Numbers() {
    }

    public Numbers(String spec) {
        String[] strings = spec.split(",");
        this.polishPointIndex = Integer.parseInt(strings[0]);
        NumberStyle numberStyle = NumberStyle.fromChar(strings[1]);
        int start = Integer.parseInt(strings[2]);
        int end = Integer.parseInt(strings[3]);
        this.setNumbers(true, numberStyle, start, end);
        numberStyle = NumberStyle.fromChar(strings[4]);
        start = Integer.parseInt(strings[5]);
        end = Integer.parseInt(strings[6]);
        this.setNumbers(false, numberStyle, start, end);
        if (strings.length > 8) {
            String zip = strings[7];
            if (!"-1".equals(zip)) {
                this.setZipCode(true, new ZipCodeInfo(zip));
            }
            if (!"-1".equals(zip = strings[8])) {
                this.setZipCode(false, new ZipCodeInfo(zip));
            }
        }
        if (strings.length > 9) {
            String country;
            String region;
            int nextPos = 9;
            String city = strings[nextPos];
            if (!"-1".equals(city)) {
                region = strings[nextPos + 1];
                country = strings[nextPos + 2];
                this.setCityInfo(true, new CityInfo(city, region, country));
                nextPos = 12;
            } else {
                nextPos = 10;
            }
            city = strings[nextPos];
            if (!"-1".equals(city)) {
                region = strings[nextPos + 1];
                country = strings[nextPos + 2];
                this.setCityInfo(false, new CityInfo(city, region, country));
            }
        }
    }

    public void setNumbers(boolean useLeft, NumberStyle numberStyle, int start, int end) {
        if (numberStyle != NumberStyle.NONE || start != -1 || end != -1) {
            RoadSide rs = this.assureSideIsAllocated(useLeft);
            rs.numbers = new NumDesc(numberStyle, start, end);
        } else {
            RoadSide rs;
            RoadSide roadSide = rs = useLeft ? this.leftSide : this.rightSide;
            if (rs != null) {
                rs.numbers = null;
            }
            this.removeIfEmpty(useLeft);
        }
    }

    public void setCityInfo(boolean left, CityInfo ci) {
        if (ci != null) {
            RoadSide rs = this.assureSideIsAllocated(left);
            rs.cityInfo = ci;
        } else {
            RoadSide rs;
            RoadSide roadSide = rs = left ? this.leftSide : this.rightSide;
            if (rs != null) {
                rs.cityInfo = null;
            }
            this.removeIfEmpty(left);
        }
    }

    public CityInfo getCityInfo(boolean left) {
        RoadSide rs = left ? this.leftSide : this.rightSide;
        return rs != null ? rs.cityInfo : null;
    }

    public void setZipCode(boolean left, ZipCodeInfo zipCode) {
        if (zipCode != null) {
            RoadSide rs = this.assureSideIsAllocated(left);
            rs.zipCode = zipCode;
        } else {
            RoadSide rs;
            RoadSide roadSide = rs = left ? this.leftSide : this.rightSide;
            if (rs != null) {
                rs.zipCode = null;
            }
            this.removeIfEmpty(left);
        }
    }

    public ZipCodeInfo getZipCodeInfo(boolean left) {
        RoadSide rs = left ? this.leftSide : this.rightSide;
        return rs != null ? rs.zipCode : null;
    }

    private void removeIfEmpty(boolean left) {
        if (left && this.leftSide != null && this.leftSide.isEmpty()) {
            this.leftSide = null;
        }
        if (!left && this.rightSide != null && this.rightSide.isEmpty()) {
            this.rightSide = null;
        }
    }

    private RoadSide assureSideIsAllocated(boolean left) {
        if (left && this.leftSide == null) {
            this.leftSide = new RoadSide();
        }
        if (!left && this.rightSide == null) {
            this.rightSide = new RoadSide();
        }
        return left ? this.leftSide : this.rightSide;
    }

    public int getPolishIndex() {
        return this.polishPointIndex;
    }

    public void setPolishIndex(int n) {
        this.polishPointIndex = n;
    }

    public int getIndex() {
        if (this.nodeIndex < 0) {
            log.error((Object)"WARNING: node index not set!!");
            return 0;
        }
        return this.nodeIndex;
    }

    public boolean hasIndex() {
        return this.nodeIndex >= 0;
    }

    public void setIndex(int index) {
        this.nodeIndex = index;
    }

    private NumDesc getNumbers(boolean left) {
        RoadSide rs = left ? this.leftSide : this.rightSide;
        return rs != null ? rs.numbers : null;
    }

    public NumberStyle getNumberStyle(boolean left) {
        NumDesc n = this.getNumbers(left);
        return n == null ? NumberStyle.NONE : n.numberStyle;
    }

    public int getStart(boolean left) {
        NumDesc n = this.getNumbers(left);
        return n == null ? -1 : n.start;
    }

    public int getEnd(boolean left) {
        NumDesc n = this.getNumbers(left);
        return n == null ? -1 : n.end;
    }

    public String toString() {
        String nodeStr = "0";
        if (this.polishPointIndex > 0) {
            nodeStr = Integer.toString(this.polishPointIndex);
        } else if (this.getIndex() > 0) {
            nodeStr = String.format("(n%d)", this.getIndex());
        }
        nodeStr = String.format("%s,%s,%d,%d,%s,%d,%d", new Object[]{nodeStr, this.getNumberStyle(true), this.getStart(true), this.getEnd(true), this.getNumberStyle(false), this.getStart(false), this.getEnd(false)});
        if (this.getCityInfo(true) != null || this.getCityInfo(false) != null || this.getZipCodeInfo(true) != null || this.getZipCodeInfo(false) != null) {
            nodeStr = String.format("%s,%s,%s", nodeStr, this.getPolishZipCode(true), this.getPolishZipCode(false));
            if (this.getCityInfo(true) != null || this.getCityInfo(false) != null) {
                nodeStr = String.format("%s,%s,%s", nodeStr, this.getPolishCityInfo(true), this.getPolishCityInfo(false));
            }
        }
        return nodeStr;
    }

    public NumberStyle getLeftNumberStyle() {
        return this.getNumberStyle(true);
    }

    public NumberStyle getRightNumberStyle() {
        return this.getNumberStyle(false);
    }

    public int getLeftStart() {
        return this.getStart(true);
    }

    public int getRightStart() {
        return this.getStart(false);
    }

    public int getLeftEnd() {
        return this.getEnd(true);
    }

    public int getRightEnd() {
        return this.getEnd(false);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Numbers)) {
            return false;
        }
        Numbers other = (Numbers)obj;
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isPlausible() {
        if (!Numbers.isPlausible(this.getLeftNumberStyle(), this.getLeftStart(), this.getLeftEnd())) {
            return false;
        }
        if (!Numbers.isPlausible(this.getRightNumberStyle(), this.getRightStart(), this.getRightEnd())) {
            return false;
        }
        if (this.getLeftNumberStyle() == NumberStyle.NONE || this.getRightNumberStyle() == NumberStyle.NONE) {
            return true;
        }
        if (!Objects.equals(this.getCityInfo(true), this.getCityInfo(false))) {
            return true;
        }
        if (!Objects.equals(this.getZipCodeInfo(true), this.getZipCodeInfo(false))) {
            return true;
        }
        if (this.getLeftNumberStyle() == this.getRightNumberStyle() || this.getLeftNumberStyle() == NumberStyle.BOTH || this.getRightNumberStyle() == NumberStyle.BOTH) {
            int end2;
            int start2;
            int end1;
            int start1;
            if (this.getLeftStart() < this.getLeftEnd()) {
                start1 = this.getLeftStart();
                end1 = this.getLeftEnd();
            } else {
                start1 = this.getLeftEnd();
                end1 = this.getLeftStart();
            }
            if (this.getRightStart() < this.getRightEnd()) {
                start2 = this.getRightStart();
                end2 = this.getRightEnd();
            } else {
                start2 = this.getRightEnd();
                end2 = this.getRightStart();
            }
            if (start2 > end1 || end2 < start1) {
                return true;
            }
            return this.getLeftStart() == this.getLeftEnd() && this.getRightStart() == this.getRightEnd() && this.getLeftStart() == this.getRightStart();
        }
        return true;
    }

    private static boolean isPlausible(NumberStyle style, int start, int end) {
        if (Math.abs(start - end) > 131071) {
            return false;
        }
        if (style == NumberStyle.EVEN) {
            return start % 2 == 0 && end % 2 == 0;
        }
        if (style == NumberStyle.ODD) {
            return start % 2 != 0 && end % 2 != 0;
        }
        return true;
    }

    public boolean isContained(int hn, boolean useLeft) {
        RoadSide rs;
        RoadSide roadSide = rs = useLeft ? this.leftSide : this.rightSide;
        if (rs == null || rs.numbers == null) {
            return false;
        }
        return rs.numbers.contained(hn);
    }

    public int countMatches(int hn) {
        int matches = 0;
        if (this.isContained(hn, true)) {
            ++matches;
        }
        if (this.isContained(hn, false)) {
            ++matches;
        }
        if (matches > 1 && this.getLeftStart() == this.getLeftEnd() && this.getRightStart() == this.getRightEnd()) {
            matches = 1;
        }
        return matches;
    }

    public boolean isSimilar(Numbers other) {
        if (other == null) {
            return false;
        }
        return this.getLeftNumberStyle() == other.getLeftNumberStyle() && this.getLeftStart() == other.getLeftStart() && this.getLeftEnd() == other.getLeftEnd() && this.getRightNumberStyle() == other.getRightNumberStyle() && this.getRightStart() == other.getRightStart() && this.getRightEnd() == other.getRightEnd();
    }

    public boolean isEmpty() {
        return this.getLeftNumberStyle() == NumberStyle.NONE && this.getRightNumberStyle() == NumberStyle.NONE;
    }

    private String getPolishCityInfo(boolean left) {
        CityInfo ci = this.getCityInfo(left);
        if (ci == null) {
            return "-1";
        }
        StringBuilder sb = new StringBuilder();
        if (ci.getCity() != null) {
            sb.append(ci.getCity());
        }
        sb.append(",");
        if (ci.getRegion() != null) {
            sb.append(ci.getRegion());
        }
        sb.append(",");
        if (ci.getCountry() != null) {
            sb.append(ci.getCountry());
        }
        return sb.toString();
    }

    private String getPolishZipCode(boolean left) {
        ZipCodeInfo zip = this.getZipCodeInfo(left);
        return zip != null && zip.getZipCode() != null ? zip.getZipCode() : "-1";
    }

    private class NumDesc {
        NumberStyle numberStyle;
        int start;
        int end;

        public NumDesc(NumberStyle numberStyle, int start, int end) {
            this.numberStyle = numberStyle;
            this.start = start;
            this.end = end;
        }

        public boolean contained(int hn) {
            boolean isEven;
            boolean bl = isEven = hn % 2 == 0;
            if (this.numberStyle == NumberStyle.BOTH || this.numberStyle == NumberStyle.EVEN && isEven || this.numberStyle == NumberStyle.ODD && !isEven) {
                if (this.start <= this.end) {
                    return this.start <= hn && hn <= this.end;
                }
                return this.end <= hn && hn <= this.start;
            }
            return false;
        }

        public String toString() {
            return String.format("%s,%d,%d", new Object[]{this.numberStyle, this.start, this.end});
        }
    }

    private class RoadSide {
        NumDesc numbers;
        CityInfo cityInfo;
        ZipCodeInfo zipCode;

        private RoadSide() {
        }

        boolean isEmpty() {
            return this.cityInfo == null && this.zipCode == null && this.numbers == null;
        }
    }
}

