/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.dem;

import java.io.ByteArrayOutputStream;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.ImgFileWriter;

public class DEMTile {
    private ByteArrayOutputStream bits;
    private int[] heights;
    private final int height;
    private final int width;
    private int offset;
    private final int baseHeight;
    private final int maxDeltaHeight;
    private final int encodingType;
    private final boolean hasData;
    private int bitPos;
    private byte currByte;
    private int currPlateauTablePos;
    private CalcType currCalcType;
    private static final boolean DEBUG = false;
    private StringBuilder bs;
    private final int tileNumberLat;
    private final int tileNumberLon;
    static final int[] plateauUnit = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 4, 4, 4, 4, 8, 8, 8, 8, 16, 16, 32, 32, 64, 64, 128};
    static final int[] plateauBinBits = new int[]{0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8};

    public DEMTile(int col, int row, int width, int height, short[] realHeights) {
        this.width = width;
        this.height = height;
        this.tileNumberLon = col;
        this.tileNumberLat = row;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int countInvalid = 0;
        for (int n : realHeights) {
            if (n == Short.MIN_VALUE) {
                ++countInvalid;
                continue;
            }
            if (n > max) {
                max = n;
            }
            if (n >= min) continue;
            min = n;
        }
        if (min == Integer.MAX_VALUE) {
            this.hasData = false;
            this.encodingType = 2;
            min = 0;
            max = 0;
        } else if (countInvalid > 0) {
            this.hasData = true;
            this.encodingType = 2;
            ++max;
        } else {
            this.hasData = true;
            this.encodingType = 0;
        }
        this.baseHeight = min;
        this.maxDeltaHeight = max - min;
        if (min == max) {
            return;
        }
        this.createBitStream(realHeights);
    }

    public boolean hasValidHeights() {
        return this.hasData;
    }

    public int getBaseHeight() {
        return this.baseHeight;
    }

    public int getMaxHeight() {
        return this.baseHeight + this.maxDeltaHeight - (this.encodingType == 0 ? 0 : 1);
    }

    private void createBitStream(short[] realHeights) {
        this.bits = new ByteArrayOutputStream(1024);
        this.heights = new int[realHeights.length];
        for (int i = 0; i < realHeights.length; ++i) {
            this.heights[i] = realHeights[i] == Short.MIN_VALUE ? this.maxDeltaHeight : realHeights[i] - this.baseHeight;
        }
        this.encodeDeltas();
        this.bs = null;
        this.heights = null;
    }

    private void addBit(boolean bit) {
        if (bit) {
            this.currByte = (byte)(this.currByte | 1 << 7 - this.bitPos);
        }
        ++this.bitPos;
        if (this.bitPos > 7) {
            this.bitPos = 0;
            this.bits.write(this.currByte);
            this.currByte = 0;
        }
    }

    private void encodeDeltas() {
        int pos = 0;
        this.currCalcType = null;
        ValPredicter encStandard = new ValPredicter(CalcType.CALC_STD, this.maxDeltaHeight);
        ValPredicter encPlateauF0 = new ValPredicter(CalcType.CALC_PLATEAU_ZERO, this.maxDeltaHeight);
        ValPredicter encPlateauF1 = new ValPredicter(CalcType.CALC_PLATEAU_NON_ZERO, this.maxDeltaHeight);
        ValPredicter encoder = null;
        boolean writeFollower = false;
        while (pos < this.heights.length) {
            int v;
            int n = pos % this.width;
            int m = pos / this.width;
            int hUpper = this.getHeight(n, m - 1);
            int hLeft = this.getHeight(n - 1, m);
            int dDiff = hUpper - hLeft;
            if (writeFollower) {
                encoder = dDiff == 0 ? encPlateauF0 : encPlateauF1;
                writeFollower = false;
            } else {
                if (dDiff == 0) {
                    this.currCalcType = CalcType.CALC_P_LEN;
                    int pLen = this.calcPlateauLen(n, m);
                    this.writePlateauLen(pLen, n);
                    writeFollower = (pos += pLen) % this.width != 0 || pLen == 0;
                    continue;
                }
                encoder = encStandard;
            }
            this.currCalcType = encoder.type;
            encoder.setDDiff(dDiff);
            int h = this.getHeight(n, m);
            if (this.currCalcType == CalcType.CALC_STD) {
                int hUpLeft = this.getHeight(n - 1, m - 1);
                int hdiffUp = hUpper - hUpLeft;
                int predict = hdiffUp >= this.maxDeltaHeight - hLeft ? -1 : (hdiffUp <= -hLeft ? 0 : hLeft + hdiffUp);
                v = dDiff > 0 ? -h + predict : h - predict;
            } else {
                v = h - hUpper;
            }
            encoder.write(v);
            ++pos;
        }
        if (this.bitPos > 0) {
            this.bits.write(this.currByte);
        }
    }

    private void writePlateauLen(int pLen, int col) {
        int x;
        int len = pLen;
        if (col + len >= this.width) {
            int unit;
            for (x = col; x < this.width; x += unit) {
                unit = plateauUnit[this.currPlateauTablePos++];
                len -= unit;
                this.addBit(true);
            }
            if (x != this.width) {
                --this.currPlateauTablePos;
            }
        } else {
            int unit;
            while (len >= (unit = plateauUnit[this.currPlateauTablePos])) {
                ++this.currPlateauTablePos;
                len -= unit;
                this.addBit(true);
                if ((x += unit) > this.width) {
                    --this.currPlateauTablePos;
                }
                if (x < this.width) continue;
                return;
            }
            if (this.currPlateauTablePos > 0) {
                --this.currPlateauTablePos;
            }
            this.addBit(false);
            int binBits = plateauBinBits[this.currPlateauTablePos];
            if (binBits > 0) {
                this.writeValAsBin(Math.abs(len), binBits);
            }
        }
    }

    private void writeValAsBin(int val, int numBits) {
        if (numBits == 0 && val == 0) {
            return;
        }
        int t = 1 << numBits - 1;
        if (val >= t << 1) {
            throw new MapFailedException("Number too big for binary encoding with " + numBits + " bits:" + val);
        }
        while (t > 0) {
            this.addBit((val & t) != 0);
            t >>= 1;
        }
    }

    private void writeNumberOfZeroBits(int val) {
        for (int i = 0; i < val; ++i) {
            this.addBit(false);
        }
        this.addBit(true);
    }

    private boolean writeValHybrid(int val, int hunit, int maxZeroBits) {
        int lenPart;
        int binPart;
        assert (hunit > 0);
        assert (Integer.bitCount(hunit) == 1);
        int numBits = Integer.numberOfTrailingZeros(hunit);
        if (val > 0) {
            binPart = (val - 1) % hunit;
            lenPart = (val - 1 - binPart) / hunit;
        } else {
            binPart = -val % hunit;
            lenPart = (-val - binPart) / hunit;
        }
        if (lenPart <= maxZeroBits) {
            this.writeNumberOfZeroBits(lenPart);
            this.writeValAsBin(binPart, numBits);
            this.addBit(val > 0);
            return true;
        }
        return false;
    }

    private void writeValBigBin(int val, int numZeroBits) {
        this.writeNumberOfZeroBits(numZeroBits + 1);
        int bits = DEMTile.getBigBinBits(this.maxDeltaHeight);
        if (val < 0) {
            this.writeValAsBin(-val - 1, bits - 1);
        } else {
            this.writeValAsBin(val - 1, bits - 1);
        }
        this.addBit(val <= 0);
    }

    private int calcPlateauLen(int col, int row) {
        int len = 0;
        int v = this.getHeight(col - 1, row);
        while (col + len < this.width && v == this.getHeight(col + len, row)) {
            ++len;
        }
        return len;
    }

    private int getHeight(int col, int row) {
        if (this.heights == null) {
            return 0;
        }
        if (row < 0) {
            return 0;
        }
        if (col < 0) {
            return row == 0 ? 0 : this.heights[(row - 1) * this.width];
        }
        return this.heights[col + row * this.width];
    }

    public void writeHeader(ImgFileWriter writer, int recordDesc) {
        if (this.maxDeltaHeight == 0) {
            this.offset = 0;
        }
        int offsetSize = (recordDesc & 3) + 1;
        int baseSize = ((recordDesc & 4) >> 2) + 1;
        int deltaSize = ((recordDesc & 8) >> 3) + 1;
        boolean hasExtra = (recordDesc & 0x10) != 0;
        writer.putNu(offsetSize, this.offset);
        if (baseSize == 1) {
            writer.put1s(this.baseHeight);
        } else {
            writer.put2s(this.baseHeight);
        }
        writer.putNu(deltaSize, this.maxDeltaHeight);
        if (hasExtra) {
            writer.put1u(this.encodingType);
        }
    }

    public void writeBitStreamData(ImgFileWriter writer) {
        if (this.bits != null) {
            writer.put(this.bits.toByteArray());
        }
    }

    private static int evaluateData(int oldsum, int elemcount, int newdata, int region) {
        switch (region) {
            case 0: {
                return -1 - oldsum - elemcount;
            }
            case 1: {
                return 2 * (newdata + elemcount) + 3;
            }
            case 2: {
                return 2 * newdata - 1;
            }
            case 3: {
                return 2 * (newdata - elemcount) - 5;
            }
        }
        return 1 - oldsum + elemcount;
    }

    private static int getEvaluateDataRegion(int oldsum, int elemcount, int newdata) {
        if (elemcount < 63) {
            if (newdata < -2 - (oldsum + 3 * elemcount >> 1)) {
                return 0;
            }
            if (newdata < -(oldsum + elemcount >> 1)) {
                return 1;
            }
            if (newdata < 2 - (oldsum - elemcount >> 1)) {
                return 2;
            }
            if (newdata < 4 - (oldsum - 3 * elemcount >> 1)) {
                return 3;
            }
            return 4;
        }
        if (newdata < -2 - (oldsum + 3 * elemcount >> 1)) {
            return 0;
        }
        if (newdata < -(oldsum + elemcount >> 1) - 1) {
            return 1;
        }
        if (newdata < 2 - (oldsum - elemcount >> 1)) {
            return 2;
        }
        if (newdata < 4 - (oldsum - 3 * elemcount >> 1)) {
            return 3;
        }
        return 4;
    }

    private static int getMaxLengthZeroBits(int maxHeight) {
        if (maxHeight < 2) {
            return 15;
        }
        if (maxHeight < 4) {
            return 16;
        }
        if (maxHeight < 8) {
            return 17;
        }
        if (maxHeight < 16) {
            return 18;
        }
        if (maxHeight < 32) {
            return 19;
        }
        if (maxHeight < 64) {
            return 20;
        }
        if (maxHeight < 128) {
            return 21;
        }
        if (maxHeight < 256) {
            return 22;
        }
        if (maxHeight < 512) {
            return 25;
        }
        if (maxHeight < 1024) {
            return 28;
        }
        if (maxHeight < 2048) {
            return 31;
        }
        if (maxHeight < 4096) {
            return 34;
        }
        if (maxHeight < 8192) {
            return 37;
        }
        if (maxHeight < 16384) {
            return 40;
        }
        return 43;
    }

    private static int getStartHUnit(int maxHeight) {
        if (maxHeight < 159) {
            return 1;
        }
        if (maxHeight < 287) {
            return 2;
        }
        if (maxHeight < 543) {
            return 4;
        }
        if (maxHeight < 1055) {
            return 8;
        }
        if (maxHeight < 2079) {
            return 16;
        }
        if (maxHeight < 4127) {
            return 32;
        }
        if (maxHeight < 8223) {
            return 64;
        }
        if (maxHeight < 16415) {
            return 128;
        }
        return 256;
    }

    static int getBigBinBits(int maxHeight) {
        int bits;
        if (maxHeight < 16384) {
            int n = Integer.highestOneBit(maxHeight);
            bits = Integer.numberOfTrailingZeros(n) + 1;
        } else {
            bits = 15;
        }
        return bits;
    }

    private static int normalizeHUnit(int hu) {
        if (hu > 0) {
            return Integer.highestOneBit(hu);
        }
        return 0;
    }

    public int getBitStreamLen() {
        if (this.bits == null) {
            return 0;
        }
        return this.bits.size();
    }

    public void setOffset(int off) {
        this.offset = off;
    }

    public String toString() {
        return this.tileNumberLat + " " + this.tileNumberLon + " w=" + this.width + " h=" + this.height;
    }

    public int getMaxDeltaHeight() {
        return this.maxDeltaHeight;
    }

    public int getEncodingType() {
        return this.encodingType;
    }

    public byte[] getBitStream() {
        return this.bits.toByteArray();
    }

    private class ValPredicter {
        private EncType encType;
        private WrapType wrapType;
        private int sumH;
        private int sumL;
        private int elemCount;
        private int hunit;
        private final CalcType type;
        private final int unitDelta;
        private int dDiff;
        private final int maxZeroBits;
        final int l0WrapUp;
        final int l0WrapDown;
        final int l1WrapUp;
        final int l1WrapDown;
        final int l2WrapUp;
        final int l2WrapDown;
        final int hWrapUp;
        final int hWrapDown;

        public ValPredicter(CalcType type, int maxHeight) {
            this.type = type;
            int numZeroBits = DEMTile.getMaxLengthZeroBits(maxHeight);
            if (type == CalcType.CALC_PLATEAU_NON_ZERO || type == CalcType.CALC_PLATEAU_ZERO) {
                --numZeroBits;
            }
            this.maxZeroBits = numZeroBits;
            this.unitDelta = Math.max(0, maxHeight - 95) / 64;
            this.encType = EncType.HYBRID;
            this.wrapType = WrapType.WRAP_0;
            this.hunit = DEMTile.getStartHUnit(maxHeight);
            if (maxHeight % 2 == 0) {
                this.l0WrapDown = maxHeight / 2;
                this.l0WrapUp = -maxHeight / 2;
                this.l1WrapDown = (maxHeight + 2) / 2;
                this.l1WrapUp = -maxHeight / 2;
                this.l2WrapDown = maxHeight / 2;
                this.l2WrapUp = -maxHeight / 2;
            } else {
                this.l0WrapDown = (maxHeight + 1) / 2;
                this.l0WrapUp = -(maxHeight - 1) / 2;
                this.l1WrapDown = (maxHeight + 1) / 2;
                this.l1WrapUp = -(maxHeight - 1) / 2;
                this.l2WrapDown = (maxHeight - 1) / 2;
                this.l2WrapUp = -(maxHeight + 1) / 2;
            }
            this.hWrapDown = (maxHeight + 1) / 2;
            this.hWrapUp = -(maxHeight - 1) / 2;
        }

        private int wrap(int data) {
            int up;
            int down;
            int v = data;
            if (this.encType == EncType.HYBRID) {
                down = this.hWrapDown;
                up = this.hWrapUp;
            } else if (this.wrapType == WrapType.WRAP_0) {
                down = this.l0WrapDown;
                up = this.l0WrapUp;
            } else if (this.wrapType == WrapType.WRAP_1) {
                down = this.l1WrapDown;
                up = this.l1WrapUp;
            } else {
                down = this.l2WrapDown;
                up = this.l2WrapUp;
            }
            if (v > down) {
                v -= DEMTile.this.maxDeltaHeight + 1;
            }
            if (v < up) {
                v = v + DEMTile.this.maxDeltaHeight + 1;
            }
            return v;
        }

        public void write(int val) {
            int wrapped;
            int delta1 = wrapped = this.wrap(val);
            if (this.type == CalcType.CALC_PLATEAU_ZERO) {
                if (delta1 <= 0) {
                    ++delta1;
                }
            } else if (this.type == CalcType.CALC_PLATEAU_NON_ZERO && this.dDiff > 0) {
                delta1 = -delta1;
            }
            int delta2 = this.wrapType == WrapType.WRAP_0 ? delta1 : (this.wrapType == WrapType.WRAP_1 ? 1 - delta1 : -delta1);
            boolean written = false;
            if (this.encType == EncType.HYBRID) {
                written = DEMTile.this.writeValHybrid(delta2, this.hunit, this.getCurrentMaxZeroBits());
            } else {
                int n0 = delta2 < 0 ? -delta2 * 2 : (delta2 > 0 ? (delta2 - 1) * 2 + 1 : 0);
                if (n0 <= this.getCurrentMaxZeroBits()) {
                    DEMTile.this.writeNumberOfZeroBits(n0);
                    written = true;
                }
            }
            if (!written) {
                DEMTile.this.writeValBigBin(delta2, this.getCurrentMaxZeroBits());
            }
            this.processVal(delta1);
        }

        int getCurrentMaxZeroBits() {
            if (DEMTile.this.currCalcType == CalcType.CALC_PLATEAU_NON_ZERO || DEMTile.this.currCalcType == CalcType.CALC_PLATEAU_ZERO) {
                return this.maxZeroBits - plateauBinBits[DEMTile.this.currPlateauTablePos];
            }
            return this.maxZeroBits;
        }

        private void processVal(int delta1) {
            if (this.type == CalcType.CALC_STD) {
                this.sumH += delta1 > 0 ? delta1 : -delta1;
                if (this.sumH + this.unitDelta + 1 >= 65535) {
                    this.sumH -= 65536;
                }
                int evalRegion = -1;
                int workData = delta1;
                if (this.elemCount == 63) {
                    evalRegion = DEMTile.getEvaluateDataRegion(this.sumL, this.elemCount, delta1);
                    boolean datagerade = delta1 % 2 == 0;
                    boolean sumL1 = (this.sumL - 1) % 4 == 0;
                    switch (evalRegion) {
                        case 0: 
                        case 2: 
                        case 4: {
                            if ((!sumL1 || datagerade) && (sumL1 || !datagerade)) break;
                            ++workData;
                            break;
                        }
                        case 1: {
                            ++workData;
                            if ((!sumL1 || datagerade) && (sumL1 || !datagerade)) break;
                            ++workData;
                            break;
                        }
                        case 3: {
                            if ((!sumL1 || !datagerade) && (sumL1 || datagerade)) break;
                            --workData;
                        }
                    }
                }
                if (evalRegion < 0) {
                    evalRegion = DEMTile.getEvaluateDataRegion(this.sumL, this.elemCount, workData);
                }
                int eval = DEMTile.evaluateData(this.sumL, this.elemCount, workData, evalRegion);
                this.sumL += eval;
                ++this.elemCount;
                if (this.elemCount == 64) {
                    this.elemCount = 32;
                    this.sumH = (this.sumH - this.unitDelta >> 1) - 1;
                    this.sumL /= 2;
                }
                this.hunit = DEMTile.normalizeHUnit((this.unitDelta + this.sumH + 1) / (this.elemCount + 1));
                this.wrapType = WrapType.WRAP_0;
                if (this.hunit > 0) {
                    this.encType = EncType.HYBRID;
                } else {
                    this.encType = EncType.LEN;
                    if (this.sumL > 0) {
                        this.wrapType = WrapType.WRAP_1;
                    }
                }
            } else if (this.type == CalcType.CALC_PLATEAU_ZERO) {
                this.sumH += delta1 > 0 ? delta1 : 1 - delta1;
                if (this.sumH + this.unitDelta + 1 >= 65535) {
                    this.sumH -= 65536;
                }
                this.sumL += delta1 <= 0 ? -1 : 1;
                ++this.elemCount;
                if (this.elemCount == 64) {
                    this.elemCount = 32;
                    this.sumH = (this.sumH - this.unitDelta >> 1) - 1;
                    this.sumL /= 2;
                    if (this.sumL % 2 != 0) {
                        ++this.sumL;
                    }
                }
                this.hunit = DEMTile.normalizeHUnit((this.unitDelta + this.sumH + 1 - this.elemCount / 2) / (this.elemCount + 1));
                this.wrapType = WrapType.WRAP_0;
                if (this.hunit > 0) {
                    this.encType = EncType.HYBRID;
                } else {
                    this.encType = EncType.LEN;
                    if (this.sumL >= 0) {
                        this.wrapType = WrapType.WRAP_1;
                    }
                }
            } else {
                assert (this.type == CalcType.CALC_PLATEAU_NON_ZERO);
                this.sumH += delta1 < 0 ? -delta1 : delta1;
                if (this.sumH + this.unitDelta + 1 >= 65535) {
                    this.sumH -= 65536;
                }
                this.sumL += delta1 <= 0 ? -1 : 1;
                ++this.elemCount;
                if (this.elemCount == 64) {
                    this.elemCount = 32;
                    this.sumH = (this.sumH - this.unitDelta >> 1) - 1;
                    this.sumL /= 2;
                    if (this.sumL % 2 != 0) {
                        --this.sumL;
                    }
                }
                this.hunit = DEMTile.normalizeHUnit((this.unitDelta + this.sumH + 1) / (this.elemCount + 1));
                this.wrapType = WrapType.WRAP_0;
                if (this.hunit > 0) {
                    this.encType = EncType.HYBRID;
                } else {
                    this.encType = EncType.LEN;
                    if (this.sumL <= 0) {
                        this.wrapType = WrapType.WRAP_2;
                    }
                }
            }
        }

        public void setDDiff(int dDiff) {
            this.dDiff = dDiff;
        }
    }

    private static enum CalcType {
        CALC_P_LEN,
        CALC_STD,
        CALC_PLATEAU_ZERO,
        CALC_PLATEAU_NON_ZERO;

    }

    private static enum WrapType {
        WRAP_0,
        WRAP_1,
        WRAP_2;

    }

    private static enum EncType {
        HYBRID,
        LEN;

    }
}

