/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import uk.me.parabola.imgfmt.MapTooBigException;
import uk.me.parabola.imgfmt.Sized;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.FileLink;
import uk.me.parabola.log.Logger;

public class BufferedImgFileWriter
implements ImgFileWriter,
Sized {
    private static final Logger log = Logger.getLogger(BufferedImgFileWriter.class);
    private static final int KBYTE = 1024;
    private static final int INIT_SIZE = 16384;
    private static final int GROW_SIZE = 131072;
    private static final int GUARD_SIZE = 1024;
    private final ImgChannel chan;
    private final String subfile;
    private ByteBuffer buf = ByteBuffer.allocate(16384);
    private int bufferSize = 16384;
    private int maxSize;
    private long maxAllowedSize = 0xFFFFFFL;

    public BufferedImgFileWriter(ImgChannel chan, String subfile) {
        this.chan = chan;
        this.subfile = subfile;
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
        if (chan instanceof FileLink) {
            ((FileLink)((Object)chan)).link(this, this);
        }
    }

    @Override
    public void sync() throws IOException {
        this.buf.limit((int)this.getSize());
        this.buf.position(0);
        log.debug("syncing to pos", this.chan.position(), ", size", this.buf.limit());
        this.chan.write(this.buf);
    }

    @Override
    public int position() {
        return this.buf.position();
    }

    @Override
    public void position(long pos) {
        int cur = this.position();
        if (cur > this.maxSize) {
            this.maxSize = cur;
        }
        this.buf.position((int)pos);
    }

    @Override
    public void close() throws IOException {
        this.sync();
    }

    @Override
    public void put(byte b) {
        this.ensureSize(1);
        this.buf.put(b);
    }

    @Override
    public void put1s(int val) {
        assert (val >= -128 && val <= 127) : val;
        this.ensureSize(1);
        this.buf.put((byte)val);
    }

    @Override
    public void put2s(int val) {
        assert (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) : val;
        this.ensureSize(2);
        this.buf.putShort((short)val);
    }

    @Override
    public void put3s(int val) {
        assert (val >= -8388608 && val <= 0x7FFFFF) : val;
        this.ensureSize(3);
        this.buf.put((byte)val);
        this.buf.putShort((short)(val >> 8));
    }

    @Override
    public void put1u(int val) {
        assert (val >= 0 && val <= 255) : val;
        this.ensureSize(1);
        this.buf.put((byte)val);
    }

    @Override
    public void put2u(int val) {
        assert (val >= 0 && val <= 65535) : val;
        this.ensureSize(2);
        this.buf.putChar((char)val);
    }

    @Override
    public void put3u(int val) {
        assert (val >= 0 && val <= 0xFFFFFF) : val;
        this.ensureSize(3);
        this.buf.put((byte)val);
        this.buf.putChar((char)(val >> 8));
    }

    @Override
    public void putNu(int nBytes, int val) {
        this.ensureSize(nBytes);
        switch (nBytes) {
            case 1: {
                assert (val >= 0 && val <= 255) : val;
                this.put((byte)val);
                break;
            }
            case 2: {
                assert (val >= 0 && val <= 65535) : val;
                this.buf.putShort((short)val);
                break;
            }
            case 3: {
                assert (val >= 0 && val <= 0xFFFFFF) : val;
                this.buf.put((byte)val);
                this.buf.putShort((short)(val >> 8));
                break;
            }
            case 4: {
                this.buf.putInt(val);
                break;
            }
            default: {
                assert (false) : nBytes;
                break;
            }
        }
    }

    @Override
    public void put4(int val) {
        this.ensureSize(4);
        this.buf.putInt(val);
    }

    @Override
    public void put(byte[] val) {
        this.ensureSize(val.length);
        this.buf.put(val);
    }

    @Override
    public void put(byte[] src, int start, int length) {
        this.ensureSize(length);
        this.buf.put(src, start, length);
    }

    @Override
    public void put(ByteBuffer src) {
        this.ensureSize(src.limit());
        this.buf.put(src);
    }

    @Override
    public long getSize() {
        return Math.max(this.maxSize, this.position());
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }

    private void ensureSize(int length) {
        int needed = this.buf.position() + length;
        if (needed > this.bufferSize - 1024) {
            while (needed > this.bufferSize - 1024) {
                this.bufferSize += 131072;
            }
            if ((long)this.bufferSize > this.maxAllowedSize) {
                throw new MapTooBigException(this.maxAllowedSize, "The " + this.subfile + " section of the map or tile (" + log.threadTag() + ") is too big.", "Try splitting the map into smaller tiles or reducing the amount of information included in the map.");
            }
            ByteBuffer newb = ByteBuffer.allocate(this.bufferSize);
            newb.order(ByteOrder.LITTLE_ENDIAN);
            this.buf.flip();
            newb.put(this.buf);
            this.buf = newb;
        }
    }

    public void setMaxSize(long maxSize) {
        this.maxAllowedSize = maxSize;
    }
}

