/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** ZERO_DET_CONF_REG register
 *  zero det cfg reg
 */
#define ZERO_DET_CONF_REG (DR_REG_ZERO_BASE + 0x0)
/** ZERO_DET_VREF_CHANNEL_SEL : R/W; bitpos: [3:0]; default: 8;
 *  vref pad sel,one hot code and cannot set the same bit with other channels
 */
#define ZERO_DET_VREF_CHANNEL_SEL    0x0000000FU
#define ZERO_DET_VREF_CHANNEL_SEL_M  (ZERO_DET_VREF_CHANNEL_SEL_V << ZERO_DET_VREF_CHANNEL_SEL_S)
#define ZERO_DET_VREF_CHANNEL_SEL_V  0x0000000FU
#define ZERO_DET_VREF_CHANNEL_SEL_S  0
/** ZERO_DET_COMP_CHANNEL_3_SEL : R/W; bitpos: [7:4]; default: 4;
 *  Channel 3 comp pad sel,one hot code and cannot set the same bit with other channels
 */
#define ZERO_DET_COMP_CHANNEL_3_SEL    0x0000000FU
#define ZERO_DET_COMP_CHANNEL_3_SEL_M  (ZERO_DET_COMP_CHANNEL_3_SEL_V << ZERO_DET_COMP_CHANNEL_3_SEL_S)
#define ZERO_DET_COMP_CHANNEL_3_SEL_V  0x0000000FU
#define ZERO_DET_COMP_CHANNEL_3_SEL_S  4
/** ZERO_DET_COMP_CHANNEL_2_SEL : R/W; bitpos: [11:8]; default: 2;
 *  Channel 2 comp pad sel,one hot code and cannot set the same bit with other channels
 */
#define ZERO_DET_COMP_CHANNEL_2_SEL    0x0000000FU
#define ZERO_DET_COMP_CHANNEL_2_SEL_M  (ZERO_DET_COMP_CHANNEL_2_SEL_V << ZERO_DET_COMP_CHANNEL_2_SEL_S)
#define ZERO_DET_COMP_CHANNEL_2_SEL_V  0x0000000FU
#define ZERO_DET_COMP_CHANNEL_2_SEL_S  8
/** ZERO_DET_COMP_CHANNEL_1_SEL : R/W; bitpos: [15:12]; default: 1;
 *  Channel 1 comp pad sel,one hot code and cannot set the same bit with other channels
 */
#define ZERO_DET_COMP_CHANNEL_1_SEL    0x0000000FU
#define ZERO_DET_COMP_CHANNEL_1_SEL_M  (ZERO_DET_COMP_CHANNEL_1_SEL_V << ZERO_DET_COMP_CHANNEL_1_SEL_S)
#define ZERO_DET_COMP_CHANNEL_1_SEL_V  0x0000000FU
#define ZERO_DET_COMP_CHANNEL_1_SEL_S  12
/** ZERO_DET_CHANNEL_3_EVENT_TIMER_EN : R/W; bitpos: [16]; default: 0;
 *  enable channel 3 event timer to trigger  channel 1 event  after
 *  pad_comp_channel_3_int
 */
#define ZERO_DET_CHANNEL_3_EVENT_TIMER_EN    (BIT(16))
#define ZERO_DET_CHANNEL_3_EVENT_TIMER_EN_M  (ZERO_DET_CHANNEL_3_EVENT_TIMER_EN_V << ZERO_DET_CHANNEL_3_EVENT_TIMER_EN_S)
#define ZERO_DET_CHANNEL_3_EVENT_TIMER_EN_V  0x00000001U
#define ZERO_DET_CHANNEL_3_EVENT_TIMER_EN_S  16
/** ZERO_DET_CHANNEL_2_EVENT_TIMER_EN : R/W; bitpos: [17]; default: 0;
 *  enable channel 2 event timer to trigger  channel 1 event  after
 *  pad_comp_channel_2_int
 */
#define ZERO_DET_CHANNEL_2_EVENT_TIMER_EN    (BIT(17))
#define ZERO_DET_CHANNEL_2_EVENT_TIMER_EN_M  (ZERO_DET_CHANNEL_2_EVENT_TIMER_EN_V << ZERO_DET_CHANNEL_2_EVENT_TIMER_EN_S)
#define ZERO_DET_CHANNEL_2_EVENT_TIMER_EN_V  0x00000001U
#define ZERO_DET_CHANNEL_2_EVENT_TIMER_EN_S  17
/** ZERO_DET_CHANNEL_1_EVENT_TIMER_EN : R/W; bitpos: [18]; default: 0;
 *  enable channel 1 event timer to trigger  channel 1 event  after
 *  pad_comp_channel_1_int
 */
#define ZERO_DET_CHANNEL_1_EVENT_TIMER_EN    (BIT(18))
#define ZERO_DET_CHANNEL_1_EVENT_TIMER_EN_M  (ZERO_DET_CHANNEL_1_EVENT_TIMER_EN_V << ZERO_DET_CHANNEL_1_EVENT_TIMER_EN_S)
#define ZERO_DET_CHANNEL_1_EVENT_TIMER_EN_V  0x00000001U
#define ZERO_DET_CHANNEL_1_EVENT_TIMER_EN_S  18
/** ZERO_DET_CHANNEL_TIMER_EN : R/W; bitpos: [19]; default: 0;
 *  enable timer to record the time between two continuous zero det int in each channel
 */
#define ZERO_DET_CHANNEL_TIMER_EN    (BIT(19))
#define ZERO_DET_CHANNEL_TIMER_EN_M  (ZERO_DET_CHANNEL_TIMER_EN_V << ZERO_DET_CHANNEL_TIMER_EN_S)
#define ZERO_DET_CHANNEL_TIMER_EN_V  0x00000001U
#define ZERO_DET_CHANNEL_TIMER_EN_S  19
/** ZERO_DET_LIMIT_CNT : R/W; bitpos: [27:20]; default: 5;
 *  cfg  continuous zero det num to change zero det result
 */
#define ZERO_DET_LIMIT_CNT    0x000000FFU
#define ZERO_DET_LIMIT_CNT_M  (ZERO_DET_LIMIT_CNT_V << ZERO_DET_LIMIT_CNT_S)
#define ZERO_DET_LIMIT_CNT_V  0x000000FFU
#define ZERO_DET_LIMIT_CNT_S  20
/** ZERO_DET_COMP_POLL_MASK : R/W; bitpos: [30:28]; default: 0;
 *  mask channel to do pad compare and zero det
 */
#define ZERO_DET_COMP_POLL_MASK    0x00000007U
#define ZERO_DET_COMP_POLL_MASK_M  (ZERO_DET_COMP_POLL_MASK_V << ZERO_DET_COMP_POLL_MASK_S)
#define ZERO_DET_COMP_POLL_MASK_V  0x00000007U
#define ZERO_DET_COMP_POLL_MASK_S  28
/** ZERO_DET_COMP_POLL_MODE : R/W; bitpos: [31]; default: 0;
 *  cfg channel scan mode ,0 means one trigger scan all mask channel, 1 means one
 *  trigger scan one mask channel
 */
#define ZERO_DET_COMP_POLL_MODE    (BIT(31))
#define ZERO_DET_COMP_POLL_MODE_M  (ZERO_DET_COMP_POLL_MODE_V << ZERO_DET_COMP_POLL_MODE_S)
#define ZERO_DET_COMP_POLL_MODE_V  0x00000001U
#define ZERO_DET_COMP_POLL_MODE_S  31

/** ZERO_DET_FILTER_CNT_REG register
 *  protect time reg
 */
#define ZERO_DET_FILTER_CNT_REG (DR_REG_ZERO_BASE + 0x4)
/** ZERO_DET_FILTER_CNT : R/W; bitpos: [31:0]; default: 255;
 *  protect time after det the first zero det int
 */
#define ZERO_DET_FILTER_CNT    0xFFFFFFFFU
#define ZERO_DET_FILTER_CNT_M  (ZERO_DET_FILTER_CNT_V << ZERO_DET_FILTER_CNT_S)
#define ZERO_DET_FILTER_CNT_V  0xFFFFFFFFU
#define ZERO_DET_FILTER_CNT_S  0

/** ZERO_DET_POLL_PERIOD_REG register
 *  poll period time reg
 */
#define ZERO_DET_POLL_PERIOD_REG (DR_REG_ZERO_BASE + 0x8)
/** ZERO_DET_COMP_POLL_PERIOD : R/W; bitpos: [15:0]; default: 15;
 *  poll period time for each channel
 */
#define ZERO_DET_COMP_POLL_PERIOD    0x0000FFFFU
#define ZERO_DET_COMP_POLL_PERIOD_M  (ZERO_DET_COMP_POLL_PERIOD_V << ZERO_DET_COMP_POLL_PERIOD_S)
#define ZERO_DET_COMP_POLL_PERIOD_V  0x0000FFFFU
#define ZERO_DET_COMP_POLL_PERIOD_S  0

/** ZERO_DET_DELAY_EVENT_TIME_REG register
 *  delay time reg
 */
#define ZERO_DET_DELAY_EVENT_TIME_REG (DR_REG_ZERO_BASE + 0xc)
/** ZERO_DET_DELAY_EVENT_TIME : R/W; bitpos: [15:0]; default: 15;
 *  delay time after zero det int to trigger event  for each channel
 */
#define ZERO_DET_DELAY_EVENT_TIME    0x0000FFFFU
#define ZERO_DET_DELAY_EVENT_TIME_M  (ZERO_DET_DELAY_EVENT_TIME_V << ZERO_DET_DELAY_EVENT_TIME_S)
#define ZERO_DET_DELAY_EVENT_TIME_V  0x0000FFFFU
#define ZERO_DET_DELAY_EVENT_TIME_S  0

/** ZERO_DET_INT_ENA_REG register
 *  zero det int ena
 */
#define ZERO_DET_INT_ENA_REG (DR_REG_ZERO_BASE + 0x10)
/** ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ENA    (BIT(0))
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ENA_M  (ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ENA_V << ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ENA_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ENA_S  0
/** ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ENA    (BIT(1))
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ENA_M  (ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ENA_V << ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ENA_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ENA_S  1
/** ZERO_DET_PAD_COMP_CHANNEL_3_INT_ENA : R/W; bitpos: [2]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_ENA    (BIT(2))
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_ENA_M  (ZERO_DET_PAD_COMP_CHANNEL_3_INT_ENA_V << ZERO_DET_PAD_COMP_CHANNEL_3_INT_ENA_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_ENA_S  2
/** ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ENA    (BIT(3))
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ENA_M  (ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ENA_V << ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ENA_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ENA_S  3
/** ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ENA : R/W; bitpos: [4]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ENA    (BIT(4))
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ENA_M  (ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ENA_V << ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ENA_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ENA_S  4
/** ZERO_DET_PAD_COMP_CHANNEL_2_INT_ENA : R/W; bitpos: [5]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_ENA    (BIT(5))
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_ENA_M  (ZERO_DET_PAD_COMP_CHANNEL_2_INT_ENA_V << ZERO_DET_PAD_COMP_CHANNEL_2_INT_ENA_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_ENA_S  5
/** ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ENA : R/W; bitpos: [6]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ENA    (BIT(6))
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ENA_M  (ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ENA_V << ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ENA_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ENA_S  6
/** ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ENA : R/W; bitpos: [7]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ENA    (BIT(7))
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ENA_M  (ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ENA_V << ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ENA_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ENA_S  7
/** ZERO_DET_PAD_COMP_CHANNEL_1_INT_ENA : R/W; bitpos: [8]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_ENA    (BIT(8))
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_ENA_M  (ZERO_DET_PAD_COMP_CHANNEL_1_INT_ENA_V << ZERO_DET_PAD_COMP_CHANNEL_1_INT_ENA_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_ENA_S  8
/** ZERO_DET_PAD_COMP_NEG_INT_ENA : R/W; bitpos: [9]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_NEG_INT_ENA    (BIT(9))
#define ZERO_DET_PAD_COMP_NEG_INT_ENA_M  (ZERO_DET_PAD_COMP_NEG_INT_ENA_V << ZERO_DET_PAD_COMP_NEG_INT_ENA_S)
#define ZERO_DET_PAD_COMP_NEG_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_NEG_INT_ENA_S  9
/** ZERO_DET_PAD_COMP_POS_INT_ENA : R/W; bitpos: [10]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_POS_INT_ENA    (BIT(10))
#define ZERO_DET_PAD_COMP_POS_INT_ENA_M  (ZERO_DET_PAD_COMP_POS_INT_ENA_V << ZERO_DET_PAD_COMP_POS_INT_ENA_S)
#define ZERO_DET_PAD_COMP_POS_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_POS_INT_ENA_S  10
/** ZERO_DET_PAD_COMP_INT_ENA : R/W; bitpos: [11]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_INT_ENA    (BIT(11))
#define ZERO_DET_PAD_COMP_INT_ENA_M  (ZERO_DET_PAD_COMP_INT_ENA_V << ZERO_DET_PAD_COMP_INT_ENA_S)
#define ZERO_DET_PAD_COMP_INT_ENA_V  0x00000001U
#define ZERO_DET_PAD_COMP_INT_ENA_S  11

/** ZERO_DET_INT_RAW_REG register
 *  zero det int raw
 */
#define ZERO_DET_INT_RAW_REG (DR_REG_ZERO_BASE + 0x14)
/** ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_RAW : R/WTC/SS; bitpos: [0]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_RAW    (BIT(0))
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_RAW_M  (ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_RAW_V << ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_RAW_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_RAW_S  0
/** ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_RAW : R/WTC/SS; bitpos: [1]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_RAW    (BIT(1))
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_RAW_M  (ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_RAW_V << ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_RAW_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_RAW_S  1
/** ZERO_DET_PAD_COMP_CHANNEL_3_INT_RAW : R/WTC/SS; bitpos: [2]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_RAW    (BIT(2))
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_RAW_M  (ZERO_DET_PAD_COMP_CHANNEL_3_INT_RAW_V << ZERO_DET_PAD_COMP_CHANNEL_3_INT_RAW_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_RAW_S  2
/** ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_RAW : R/WTC/SS; bitpos: [3]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_RAW    (BIT(3))
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_RAW_M  (ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_RAW_V << ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_RAW_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_RAW_S  3
/** ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_RAW : R/WTC/SS; bitpos: [4]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_RAW    (BIT(4))
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_RAW_M  (ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_RAW_V << ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_RAW_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_RAW_S  4
/** ZERO_DET_PAD_COMP_CHANNEL_2_INT_RAW : R/WTC/SS; bitpos: [5]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_RAW    (BIT(5))
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_RAW_M  (ZERO_DET_PAD_COMP_CHANNEL_2_INT_RAW_V << ZERO_DET_PAD_COMP_CHANNEL_2_INT_RAW_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_RAW_S  5
/** ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_RAW : R/WTC/SS; bitpos: [6]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_RAW    (BIT(6))
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_RAW_M  (ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_RAW_V << ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_RAW_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_RAW_S  6
/** ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_RAW : R/WTC/SS; bitpos: [7]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_RAW    (BIT(7))
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_RAW_M  (ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_RAW_V << ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_RAW_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_RAW_S  7
/** ZERO_DET_PAD_COMP_CHANNEL_1_INT_RAW : R/WTC/SS; bitpos: [8]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_RAW    (BIT(8))
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_RAW_M  (ZERO_DET_PAD_COMP_CHANNEL_1_INT_RAW_V << ZERO_DET_PAD_COMP_CHANNEL_1_INT_RAW_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_RAW_S  8
/** ZERO_DET_PAD_COMP_NEG_INT_RAW : R/WTC/SS; bitpos: [9]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_NEG_INT_RAW    (BIT(9))
#define ZERO_DET_PAD_COMP_NEG_INT_RAW_M  (ZERO_DET_PAD_COMP_NEG_INT_RAW_V << ZERO_DET_PAD_COMP_NEG_INT_RAW_S)
#define ZERO_DET_PAD_COMP_NEG_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_NEG_INT_RAW_S  9
/** ZERO_DET_PAD_COMP_POS_INT_RAW : R/WTC/SS; bitpos: [10]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_POS_INT_RAW    (BIT(10))
#define ZERO_DET_PAD_COMP_POS_INT_RAW_M  (ZERO_DET_PAD_COMP_POS_INT_RAW_V << ZERO_DET_PAD_COMP_POS_INT_RAW_S)
#define ZERO_DET_PAD_COMP_POS_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_POS_INT_RAW_S  10
/** ZERO_DET_PAD_COMP_INT_RAW : R/WTC/SS; bitpos: [11]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_INT_RAW    (BIT(11))
#define ZERO_DET_PAD_COMP_INT_RAW_M  (ZERO_DET_PAD_COMP_INT_RAW_V << ZERO_DET_PAD_COMP_INT_RAW_S)
#define ZERO_DET_PAD_COMP_INT_RAW_V  0x00000001U
#define ZERO_DET_PAD_COMP_INT_RAW_S  11

/** ZERO_DET_INT_CLR_REG register
 *  zero det int clr
 */
#define ZERO_DET_INT_CLR_REG (DR_REG_ZERO_BASE + 0x18)
/** ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_CLR : WT; bitpos: [0]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_CLR    (BIT(0))
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_CLR_M  (ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_CLR_V << ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_CLR_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_CLR_S  0
/** ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_CLR : WT; bitpos: [1]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_CLR    (BIT(1))
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_CLR_M  (ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_CLR_V << ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_CLR_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_CLR_S  1
/** ZERO_DET_PAD_COMP_CHANNEL_3_INT_CLR : WT; bitpos: [2]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_CLR    (BIT(2))
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_CLR_M  (ZERO_DET_PAD_COMP_CHANNEL_3_INT_CLR_V << ZERO_DET_PAD_COMP_CHANNEL_3_INT_CLR_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_CLR_S  2
/** ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_CLR : WT; bitpos: [3]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_CLR    (BIT(3))
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_CLR_M  (ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_CLR_V << ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_CLR_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_CLR_S  3
/** ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_CLR : WT; bitpos: [4]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_CLR    (BIT(4))
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_CLR_M  (ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_CLR_V << ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_CLR_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_CLR_S  4
/** ZERO_DET_PAD_COMP_CHANNEL_2_INT_CLR : WT; bitpos: [5]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_CLR    (BIT(5))
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_CLR_M  (ZERO_DET_PAD_COMP_CHANNEL_2_INT_CLR_V << ZERO_DET_PAD_COMP_CHANNEL_2_INT_CLR_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_CLR_S  5
/** ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_CLR : WT; bitpos: [6]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_CLR    (BIT(6))
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_CLR_M  (ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_CLR_V << ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_CLR_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_CLR_S  6
/** ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_CLR : WT; bitpos: [7]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_CLR    (BIT(7))
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_CLR_M  (ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_CLR_V << ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_CLR_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_CLR_S  7
/** ZERO_DET_PAD_COMP_CHANNEL_1_INT_CLR : WT; bitpos: [8]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_CLR    (BIT(8))
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_CLR_M  (ZERO_DET_PAD_COMP_CHANNEL_1_INT_CLR_V << ZERO_DET_PAD_COMP_CHANNEL_1_INT_CLR_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_CLR_S  8
/** ZERO_DET_PAD_COMP_NEG_INT_CLR : WT; bitpos: [9]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_NEG_INT_CLR    (BIT(9))
#define ZERO_DET_PAD_COMP_NEG_INT_CLR_M  (ZERO_DET_PAD_COMP_NEG_INT_CLR_V << ZERO_DET_PAD_COMP_NEG_INT_CLR_S)
#define ZERO_DET_PAD_COMP_NEG_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_NEG_INT_CLR_S  9
/** ZERO_DET_PAD_COMP_POS_INT_CLR : WT; bitpos: [10]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_POS_INT_CLR    (BIT(10))
#define ZERO_DET_PAD_COMP_POS_INT_CLR_M  (ZERO_DET_PAD_COMP_POS_INT_CLR_V << ZERO_DET_PAD_COMP_POS_INT_CLR_S)
#define ZERO_DET_PAD_COMP_POS_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_POS_INT_CLR_S  10
/** ZERO_DET_PAD_COMP_INT_CLR : WT; bitpos: [11]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_INT_CLR    (BIT(11))
#define ZERO_DET_PAD_COMP_INT_CLR_M  (ZERO_DET_PAD_COMP_INT_CLR_V << ZERO_DET_PAD_COMP_INT_CLR_S)
#define ZERO_DET_PAD_COMP_INT_CLR_V  0x00000001U
#define ZERO_DET_PAD_COMP_INT_CLR_S  11

/** ZERO_DET_INT_ST_REG register
 *  zero det int st
 */
#define ZERO_DET_INT_ST_REG (DR_REG_ZERO_BASE + 0x1c)
/** ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ST : RO; bitpos: [0]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ST    (BIT(0))
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ST_M  (ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ST_V << ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ST_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_NEG_INT_ST_S  0
/** ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ST : RO; bitpos: [1]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ST    (BIT(1))
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ST_M  (ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ST_V << ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ST_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_POS_INT_ST_S  1
/** ZERO_DET_PAD_COMP_CHANNEL_3_INT_ST : RO; bitpos: [2]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_ST    (BIT(2))
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_ST_M  (ZERO_DET_PAD_COMP_CHANNEL_3_INT_ST_V << ZERO_DET_PAD_COMP_CHANNEL_3_INT_ST_S)
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_3_INT_ST_S  2
/** ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ST : RO; bitpos: [3]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ST    (BIT(3))
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ST_M  (ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ST_V << ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ST_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_NEG_INT_ST_S  3
/** ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ST : RO; bitpos: [4]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ST    (BIT(4))
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ST_M  (ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ST_V << ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ST_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_POS_INT_ST_S  4
/** ZERO_DET_PAD_COMP_CHANNEL_2_INT_ST : RO; bitpos: [5]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_ST    (BIT(5))
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_ST_M  (ZERO_DET_PAD_COMP_CHANNEL_2_INT_ST_V << ZERO_DET_PAD_COMP_CHANNEL_2_INT_ST_S)
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_2_INT_ST_S  5
/** ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ST : RO; bitpos: [6]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ST    (BIT(6))
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ST_M  (ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ST_V << ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ST_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_NEG_INT_ST_S  6
/** ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ST : RO; bitpos: [7]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ST    (BIT(7))
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ST_M  (ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ST_V << ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ST_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_POS_INT_ST_S  7
/** ZERO_DET_PAD_COMP_CHANNEL_1_INT_ST : RO; bitpos: [8]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_ST    (BIT(8))
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_ST_M  (ZERO_DET_PAD_COMP_CHANNEL_1_INT_ST_V << ZERO_DET_PAD_COMP_CHANNEL_1_INT_ST_S)
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_CHANNEL_1_INT_ST_S  8
/** ZERO_DET_PAD_COMP_NEG_INT_ST : RO; bitpos: [9]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_NEG_INT_ST    (BIT(9))
#define ZERO_DET_PAD_COMP_NEG_INT_ST_M  (ZERO_DET_PAD_COMP_NEG_INT_ST_V << ZERO_DET_PAD_COMP_NEG_INT_ST_S)
#define ZERO_DET_PAD_COMP_NEG_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_NEG_INT_ST_S  9
/** ZERO_DET_PAD_COMP_POS_INT_ST : RO; bitpos: [10]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_POS_INT_ST    (BIT(10))
#define ZERO_DET_PAD_COMP_POS_INT_ST_M  (ZERO_DET_PAD_COMP_POS_INT_ST_V << ZERO_DET_PAD_COMP_POS_INT_ST_S)
#define ZERO_DET_PAD_COMP_POS_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_POS_INT_ST_S  10
/** ZERO_DET_PAD_COMP_INT_ST : RO; bitpos: [11]; default: 0;
 *  reserved
 */
#define ZERO_DET_PAD_COMP_INT_ST    (BIT(11))
#define ZERO_DET_PAD_COMP_INT_ST_M  (ZERO_DET_PAD_COMP_INT_ST_V << ZERO_DET_PAD_COMP_INT_ST_S)
#define ZERO_DET_PAD_COMP_INT_ST_V  0x00000001U
#define ZERO_DET_PAD_COMP_INT_ST_S  11

/** ZERO_DET_CHANNEL_1_TIMER0_REG register
 *  record timer reg
 */
#define ZERO_DET_CHANNEL_1_TIMER0_REG (DR_REG_ZERO_BASE + 0x20)
/** ZERO_DET_CHANNEL_1_TIMER0 : RO; bitpos: [31:0]; default: 0;
 *  record the time while detect the first zero det int  in channel 1
 */
#define ZERO_DET_CHANNEL_1_TIMER0    0xFFFFFFFFU
#define ZERO_DET_CHANNEL_1_TIMER0_M  (ZERO_DET_CHANNEL_1_TIMER0_V << ZERO_DET_CHANNEL_1_TIMER0_S)
#define ZERO_DET_CHANNEL_1_TIMER0_V  0xFFFFFFFFU
#define ZERO_DET_CHANNEL_1_TIMER0_S  0

/** ZERO_DET_CHANNEL_1_TIMER1_REG register
 *  record timer reg
 */
#define ZERO_DET_CHANNEL_1_TIMER1_REG (DR_REG_ZERO_BASE + 0x24)
/** ZERO_DET_CHANNEL_1_TIMER1 : RO; bitpos: [31:0]; default: 0;
 *  record the time while detect the second zero det int  in channel 1
 */
#define ZERO_DET_CHANNEL_1_TIMER1    0xFFFFFFFFU
#define ZERO_DET_CHANNEL_1_TIMER1_M  (ZERO_DET_CHANNEL_1_TIMER1_V << ZERO_DET_CHANNEL_1_TIMER1_S)
#define ZERO_DET_CHANNEL_1_TIMER1_V  0xFFFFFFFFU
#define ZERO_DET_CHANNEL_1_TIMER1_S  0

/** ZERO_DET_CHANNEL_2_TIMER0_REG register
 *  record timer reg
 */
#define ZERO_DET_CHANNEL_2_TIMER0_REG (DR_REG_ZERO_BASE + 0x28)
/** ZERO_DET_CHANNEL_2_TIMER0 : RO; bitpos: [31:0]; default: 0;
 *  record the time while detect the first zero det int  in channel 2
 */
#define ZERO_DET_CHANNEL_2_TIMER0    0xFFFFFFFFU
#define ZERO_DET_CHANNEL_2_TIMER0_M  (ZERO_DET_CHANNEL_2_TIMER0_V << ZERO_DET_CHANNEL_2_TIMER0_S)
#define ZERO_DET_CHANNEL_2_TIMER0_V  0xFFFFFFFFU
#define ZERO_DET_CHANNEL_2_TIMER0_S  0

/** ZERO_DET_CHANNEL_2_TIMER1_REG register
 *  record timer reg
 */
#define ZERO_DET_CHANNEL_2_TIMER1_REG (DR_REG_ZERO_BASE + 0x2c)
/** ZERO_DET_CHANNEL_2_TIMER1 : RO; bitpos: [31:0]; default: 0;
 *  record the time while detect the second zero det int  in channel 2
 */
#define ZERO_DET_CHANNEL_2_TIMER1    0xFFFFFFFFU
#define ZERO_DET_CHANNEL_2_TIMER1_M  (ZERO_DET_CHANNEL_2_TIMER1_V << ZERO_DET_CHANNEL_2_TIMER1_S)
#define ZERO_DET_CHANNEL_2_TIMER1_V  0xFFFFFFFFU
#define ZERO_DET_CHANNEL_2_TIMER1_S  0

/** ZERO_DET_CHANNEL_3_TIMER0_REG register
 *  record timer reg
 */
#define ZERO_DET_CHANNEL_3_TIMER0_REG (DR_REG_ZERO_BASE + 0x30)
/** ZERO_DET_CHANNEL_3_TIMER0 : RO; bitpos: [31:0]; default: 0;
 *  record the time while detect the first zero det int  in channel 3
 */
#define ZERO_DET_CHANNEL_3_TIMER0    0xFFFFFFFFU
#define ZERO_DET_CHANNEL_3_TIMER0_M  (ZERO_DET_CHANNEL_3_TIMER0_V << ZERO_DET_CHANNEL_3_TIMER0_S)
#define ZERO_DET_CHANNEL_3_TIMER0_V  0xFFFFFFFFU
#define ZERO_DET_CHANNEL_3_TIMER0_S  0

/** ZERO_DET_CHANNEL_3_TIMER1_REG register
 *  record timer reg
 */
#define ZERO_DET_CHANNEL_3_TIMER1_REG (DR_REG_ZERO_BASE + 0x34)
/** ZERO_DET_CHANNEL_3_TIMER1 : RO; bitpos: [31:0]; default: 0;
 *  record the time while detect the second zero det int  in channel 3
 */
#define ZERO_DET_CHANNEL_3_TIMER1    0xFFFFFFFFU
#define ZERO_DET_CHANNEL_3_TIMER1_M  (ZERO_DET_CHANNEL_3_TIMER1_V << ZERO_DET_CHANNEL_3_TIMER1_S)
#define ZERO_DET_CHANNEL_3_TIMER1_V  0xFFFFFFFFU
#define ZERO_DET_CHANNEL_3_TIMER1_S  0

/** ZERO_DET_CHANNEL_STATUS_REG register
 *  pad comp status reg
 */
#define ZERO_DET_CHANNEL_STATUS_REG (DR_REG_ZERO_BASE + 0x38)
/** ZERO_DET_CHANNEL_3_PAD_COMP_STATUS : RO; bitpos: [0]; default: 0;
 *  record the pad comp status for channel 3, 0 means now is neg int , 1 means now is
 *  pos int
 */
#define ZERO_DET_CHANNEL_3_PAD_COMP_STATUS    (BIT(0))
#define ZERO_DET_CHANNEL_3_PAD_COMP_STATUS_M  (ZERO_DET_CHANNEL_3_PAD_COMP_STATUS_V << ZERO_DET_CHANNEL_3_PAD_COMP_STATUS_S)
#define ZERO_DET_CHANNEL_3_PAD_COMP_STATUS_V  0x00000001U
#define ZERO_DET_CHANNEL_3_PAD_COMP_STATUS_S  0
/** ZERO_DET_CHANNEL_2_PAD_COMP_STATUS : RO; bitpos: [1]; default: 0;
 *  record the pad comp status for channel 2, 0 means now is neg int , 1 means now is
 *  pos int
 */
#define ZERO_DET_CHANNEL_2_PAD_COMP_STATUS    (BIT(1))
#define ZERO_DET_CHANNEL_2_PAD_COMP_STATUS_M  (ZERO_DET_CHANNEL_2_PAD_COMP_STATUS_V << ZERO_DET_CHANNEL_2_PAD_COMP_STATUS_S)
#define ZERO_DET_CHANNEL_2_PAD_COMP_STATUS_V  0x00000001U
#define ZERO_DET_CHANNEL_2_PAD_COMP_STATUS_S  1
/** ZERO_DET_CHANNEL_1_PAD_COMP_STATUS : RO; bitpos: [2]; default: 0;
 *  record the pad comp status for channel 1, 0 means now is neg int , 1 means now is
 *  pos int
 */
#define ZERO_DET_CHANNEL_1_PAD_COMP_STATUS    (BIT(2))
#define ZERO_DET_CHANNEL_1_PAD_COMP_STATUS_M  (ZERO_DET_CHANNEL_1_PAD_COMP_STATUS_V << ZERO_DET_CHANNEL_1_PAD_COMP_STATUS_S)
#define ZERO_DET_CHANNEL_1_PAD_COMP_STATUS_V  0x00000001U
#define ZERO_DET_CHANNEL_1_PAD_COMP_STATUS_S  2

/** ZERO_DET_PAD_COMP_CFG_REG register
 *  pad comp cfg reg
 */
#define ZERO_DET_PAD_COMP_CFG_REG (DR_REG_ZERO_BASE + 0x3c)
/** ZERO_DET_PAD_COMP_HYS : R/W; bitpos: [2:0]; default: 0;
 *  hys cfg signal
 */
#define ZERO_DET_PAD_COMP_HYS    0x00000007U
#define ZERO_DET_PAD_COMP_HYS_M  (ZERO_DET_PAD_COMP_HYS_V << ZERO_DET_PAD_COMP_HYS_S)
#define ZERO_DET_PAD_COMP_HYS_V  0x00000007U
#define ZERO_DET_PAD_COMP_HYS_S  0
/** ZERO_DET_PAD_COMP_HYS_EN : R/W; bitpos: [3]; default: 0;
 *  enable hys function,only works while pad comp mode = 0
 */
#define ZERO_DET_PAD_COMP_HYS_EN    (BIT(3))
#define ZERO_DET_PAD_COMP_HYS_EN_M  (ZERO_DET_PAD_COMP_HYS_EN_V << ZERO_DET_PAD_COMP_HYS_EN_S)
#define ZERO_DET_PAD_COMP_HYS_EN_V  0x00000001U
#define ZERO_DET_PAD_COMP_HYS_EN_S  3
/** ZERO_DET_PAD_COMP_DREF : R/W; bitpos: [6:4]; default: 0;
 *  internal vref cfg signal,0~2.3v step is 330mv
 */
#define ZERO_DET_PAD_COMP_DREF    0x00000007U
#define ZERO_DET_PAD_COMP_DREF_M  (ZERO_DET_PAD_COMP_DREF_V << ZERO_DET_PAD_COMP_DREF_S)
#define ZERO_DET_PAD_COMP_DREF_V  0x00000007U
#define ZERO_DET_PAD_COMP_DREF_S  4
/** ZERO_DET_PAD_COMP_MODE : R/W; bitpos: [7]; default: 0;
 *  pad comp mode cfg 1:external pad 0:internal vref
 */
#define ZERO_DET_PAD_COMP_MODE    (BIT(7))
#define ZERO_DET_PAD_COMP_MODE_M  (ZERO_DET_PAD_COMP_MODE_V << ZERO_DET_PAD_COMP_MODE_S)
#define ZERO_DET_PAD_COMP_MODE_V  0x00000001U
#define ZERO_DET_PAD_COMP_MODE_S  7
/** ZERO_DET_PAD_COMP_XPD : R/W; bitpos: [8]; default: 0;
 *  pad comp xpd
 */
#define ZERO_DET_PAD_COMP_XPD    (BIT(8))
#define ZERO_DET_PAD_COMP_XPD_M  (ZERO_DET_PAD_COMP_XPD_V << ZERO_DET_PAD_COMP_XPD_S)
#define ZERO_DET_PAD_COMP_XPD_V  0x00000001U
#define ZERO_DET_PAD_COMP_XPD_S  8

/** ZERO_DET_DATE_REG register
 *  date reg
 */
#define ZERO_DET_DATE_REG (DR_REG_ZERO_BASE + 0x40)
/** ZERO_DET_DATE : R/W; bitpos: [27:0]; default: 37773696;
 *  zero det reg change date
 */
#define ZERO_DET_DATE    0x0FFFFFFFU
#define ZERO_DET_DATE_M  (ZERO_DET_DATE_V << ZERO_DET_DATE_S)
#define ZERO_DET_DATE_V  0x0FFFFFFFU
#define ZERO_DET_DATE_S  0
/** ZERO_DET_CLK_EN : R/W; bitpos: [28]; default: 0;
 *  reg clk en
 */
#define ZERO_DET_CLK_EN    (BIT(28))
#define ZERO_DET_CLK_EN_M  (ZERO_DET_CLK_EN_V << ZERO_DET_CLK_EN_S)
#define ZERO_DET_CLK_EN_V  0x00000001U
#define ZERO_DET_CLK_EN_S  28

#ifdef __cplusplus
}
#endif
