/**
 * SPDX-FileCopyrightText: 2021-2022 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** INTERRUPT_CORE0_WIFI_MAC_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_WIFI_MAC_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x0)
/** INTERRUPT_CORE0_WIFI_MAC_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_WIFI_MAC_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_WIFI_MAC_INT_MAP_M  (INTERRUPT_CORE0_WIFI_MAC_INT_MAP_V << INTERRUPT_CORE0_WIFI_MAC_INT_MAP_S)
#define INTERRUPT_CORE0_WIFI_MAC_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_WIFI_MAC_INT_MAP_S  0

/** INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_REG (DR_REG_INTERRUPT_BASE + 0x4)
/** INTERRUPT_CORE0_WIFI_MAC_NMI_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_WIFI_MAC_NMI_MAP    0x0000001FU
#define INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_M  (INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_V << INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_S)
#define INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_WIFI_MAC_NMI_MAP_S  0

/** INTERRUPT_CORE0_WIFI_PWR_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_WIFI_PWR_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x8)
/** INTERRUPT_CORE0_WIFI_PWR_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_WIFI_PWR_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_WIFI_PWR_INT_MAP_M  (INTERRUPT_CORE0_WIFI_PWR_INT_MAP_V << INTERRUPT_CORE0_WIFI_PWR_INT_MAP_S)
#define INTERRUPT_CORE0_WIFI_PWR_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_WIFI_PWR_INT_MAP_S  0

/** INTERRUPT_CORE0_WIFI_BB_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_WIFI_BB_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0xc)
/** INTERRUPT_CORE0_WIFI_BB_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_WIFI_BB_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_WIFI_BB_INT_MAP_M  (INTERRUPT_CORE0_WIFI_BB_INT_MAP_V << INTERRUPT_CORE0_WIFI_BB_INT_MAP_S)
#define INTERRUPT_CORE0_WIFI_BB_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_WIFI_BB_INT_MAP_S  0

/** INTERRUPT_CORE0_BT_MAC_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_BT_MAC_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x10)
/** INTERRUPT_CORE0_BT_MAC_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_BT_MAC_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_BT_MAC_INT_MAP_M  (INTERRUPT_CORE0_BT_MAC_INT_MAP_V << INTERRUPT_CORE0_BT_MAC_INT_MAP_S)
#define INTERRUPT_CORE0_BT_MAC_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_BT_MAC_INT_MAP_S  0

/** INTERRUPT_CORE0_BT_BB_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_BT_BB_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x14)
/** INTERRUPT_CORE0_BT_BB_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_BT_BB_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_BT_BB_INT_MAP_M  (INTERRUPT_CORE0_BT_BB_INT_MAP_V << INTERRUPT_CORE0_BT_BB_INT_MAP_S)
#define INTERRUPT_CORE0_BT_BB_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_BT_BB_INT_MAP_S  0

/** INTERRUPT_CORE0_BT_BB_NMI_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_REG (DR_REG_INTERRUPT_BASE + 0x18)
/** INTERRUPT_CORE0_BT_BB_NMI_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_BT_BB_NMI_MAP    0x0000001FU
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_M  (INTERRUPT_CORE0_BT_BB_NMI_MAP_V << INTERRUPT_CORE0_BT_BB_NMI_MAP_S)
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_S  0

/** INTERRUPT_CORE0_LP_TIMER_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_LP_TIMER_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x1c)
/** INTERRUPT_CORE0_LP_TIMER_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_LP_TIMER_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_LP_TIMER_INT_MAP_M  (INTERRUPT_CORE0_LP_TIMER_INT_MAP_V << INTERRUPT_CORE0_LP_TIMER_INT_MAP_S)
#define INTERRUPT_CORE0_LP_TIMER_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_LP_TIMER_INT_MAP_S  0

/** INTERRUPT_CORE0_COEX_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_COEX_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x20)
/** INTERRUPT_CORE0_COEX_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_COEX_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_COEX_INT_MAP_M  (INTERRUPT_CORE0_COEX_INT_MAP_V << INTERRUPT_CORE0_COEX_INT_MAP_S)
#define INTERRUPT_CORE0_COEX_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_COEX_INT_MAP_S  0

/** INTERRUPT_CORE0_BLE_TIMER_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_BLE_TIMER_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x24)
/** INTERRUPT_CORE0_BLE_TIMER_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_BLE_TIMER_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_BLE_TIMER_INT_MAP_M  (INTERRUPT_CORE0_BLE_TIMER_INT_MAP_V << INTERRUPT_CORE0_BLE_TIMER_INT_MAP_S)
#define INTERRUPT_CORE0_BLE_TIMER_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_BLE_TIMER_INT_MAP_S  0

/** INTERRUPT_CORE0_BLE_SEC_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_BLE_SEC_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x28)
/** INTERRUPT_CORE0_BLE_SEC_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_BLE_SEC_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_BLE_SEC_INT_MAP_M  (INTERRUPT_CORE0_BLE_SEC_INT_MAP_V << INTERRUPT_CORE0_BLE_SEC_INT_MAP_S)
#define INTERRUPT_CORE0_BLE_SEC_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_BLE_SEC_INT_MAP_S  0

/** INTERRUPT_CORE0_I2C_MST_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_I2C_MST_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x2c)
/** INTERRUPT_CORE0_I2C_MST_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_I2C_MST_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_I2C_MST_INT_MAP_M  (INTERRUPT_CORE0_I2C_MST_INT_MAP_V << INTERRUPT_CORE0_I2C_MST_INT_MAP_S)
#define INTERRUPT_CORE0_I2C_MST_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_I2C_MST_INT_MAP_S  0

/** INTERRUPT_CORE0_APB_CTRL_INTR_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_APB_CTRL_INTR_MAP_REG (DR_REG_INTERRUPT_BASE + 0x30)
/** INTERRUPT_CORE0_APB_CTRL_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_APB_CTRL_INTR_MAP    0x0000001FU
#define INTERRUPT_CORE0_APB_CTRL_INTR_MAP_M  (INTERRUPT_CORE0_APB_CTRL_INTR_MAP_V << INTERRUPT_CORE0_APB_CTRL_INTR_MAP_S)
#define INTERRUPT_CORE0_APB_CTRL_INTR_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_APB_CTRL_INTR_MAP_S  0

/** INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_REG (DR_REG_INTERRUPT_BASE + 0x34)
/** INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP    0x0000001FU
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_M  (INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_V << INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_S)
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_S  0

/** INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_REG (DR_REG_INTERRUPT_BASE + 0x38)
/** INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP    0x0000001FU
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_M  (INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_V << INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_S)
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_S  0

/** INTERRUPT_CORE0_SPI_INTR_1_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_SPI_INTR_1_MAP_REG (DR_REG_INTERRUPT_BASE + 0x3c)
/** INTERRUPT_CORE0_SPI_INTR_1_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_SPI_INTR_1_MAP    0x0000001FU
#define INTERRUPT_CORE0_SPI_INTR_1_MAP_M  (INTERRUPT_CORE0_SPI_INTR_1_MAP_V << INTERRUPT_CORE0_SPI_INTR_1_MAP_S)
#define INTERRUPT_CORE0_SPI_INTR_1_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_SPI_INTR_1_MAP_S  0

/** INTERRUPT_CORE0_SPI_INTR_2_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_SPI_INTR_2_MAP_REG (DR_REG_INTERRUPT_BASE + 0x40)
/** INTERRUPT_CORE0_SPI_INTR_2_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_SPI_INTR_2_MAP    0x0000001FU
#define INTERRUPT_CORE0_SPI_INTR_2_MAP_M  (INTERRUPT_CORE0_SPI_INTR_2_MAP_V << INTERRUPT_CORE0_SPI_INTR_2_MAP_S)
#define INTERRUPT_CORE0_SPI_INTR_2_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_SPI_INTR_2_MAP_S  0

/** INTERRUPT_CORE0_UART_INTR_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_UART_INTR_MAP_REG (DR_REG_INTERRUPT_BASE + 0x44)
/** INTERRUPT_CORE0_UART_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_UART_INTR_MAP    0x0000001FU
#define INTERRUPT_CORE0_UART_INTR_MAP_M  (INTERRUPT_CORE0_UART_INTR_MAP_V << INTERRUPT_CORE0_UART_INTR_MAP_S)
#define INTERRUPT_CORE0_UART_INTR_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_UART_INTR_MAP_S  0

/** INTERRUPT_CORE0_UART1_INTR_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_UART1_INTR_MAP_REG (DR_REG_INTERRUPT_BASE + 0x48)
/** INTERRUPT_CORE0_UART1_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_UART1_INTR_MAP    0x0000001FU
#define INTERRUPT_CORE0_UART1_INTR_MAP_M  (INTERRUPT_CORE0_UART1_INTR_MAP_V << INTERRUPT_CORE0_UART1_INTR_MAP_S)
#define INTERRUPT_CORE0_UART1_INTR_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_UART1_INTR_MAP_S  0

/** INTERRUPT_CORE0_LEDC_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_LEDC_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x4c)
/** INTERRUPT_CORE0_LEDC_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_LEDC_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_LEDC_INT_MAP_M  (INTERRUPT_CORE0_LEDC_INT_MAP_V << INTERRUPT_CORE0_LEDC_INT_MAP_S)
#define INTERRUPT_CORE0_LEDC_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_LEDC_INT_MAP_S  0

/** INTERRUPT_CORE0_EFUSE_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_EFUSE_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x50)
/** INTERRUPT_CORE0_EFUSE_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_EFUSE_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_EFUSE_INT_MAP_M  (INTERRUPT_CORE0_EFUSE_INT_MAP_V << INTERRUPT_CORE0_EFUSE_INT_MAP_S)
#define INTERRUPT_CORE0_EFUSE_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_EFUSE_INT_MAP_S  0

/** INTERRUPT_CORE0_RTC_CORE_INTR_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_RTC_CORE_INTR_MAP_REG (DR_REG_INTERRUPT_BASE + 0x54)
/** INTERRUPT_CORE0_RTC_CORE_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_RTC_CORE_INTR_MAP    0x0000001FU
#define INTERRUPT_CORE0_RTC_CORE_INTR_MAP_M  (INTERRUPT_CORE0_RTC_CORE_INTR_MAP_V << INTERRUPT_CORE0_RTC_CORE_INTR_MAP_S)
#define INTERRUPT_CORE0_RTC_CORE_INTR_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_RTC_CORE_INTR_MAP_S  0

/** INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_REG (DR_REG_INTERRUPT_BASE + 0x58)
/** INTERRUPT_CORE0_I2C_EXT0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP    0x0000001FU
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_M  (INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_V << INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_S)
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_S  0

/** INTERRUPT_CORE0_TG_T0_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_TG_T0_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x5c)
/** INTERRUPT_CORE0_TG_T0_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_TG_T0_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_TG_T0_INT_MAP_M  (INTERRUPT_CORE0_TG_T0_INT_MAP_V << INTERRUPT_CORE0_TG_T0_INT_MAP_S)
#define INTERRUPT_CORE0_TG_T0_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_TG_T0_INT_MAP_S  0

/** INTERRUPT_CORE0_TG_WDT_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_TG_WDT_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x60)
/** INTERRUPT_CORE0_TG_WDT_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_TG_WDT_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_TG_WDT_INT_MAP_M  (INTERRUPT_CORE0_TG_WDT_INT_MAP_V << INTERRUPT_CORE0_TG_WDT_INT_MAP_S)
#define INTERRUPT_CORE0_TG_WDT_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_TG_WDT_INT_MAP_S  0

/** INTERRUPT_CORE0_CACHE_IA_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CACHE_IA_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x64)
/** INTERRUPT_CORE0_CACHE_IA_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CACHE_IA_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_CACHE_IA_INT_MAP_M  (INTERRUPT_CORE0_CACHE_IA_INT_MAP_V << INTERRUPT_CORE0_CACHE_IA_INT_MAP_S)
#define INTERRUPT_CORE0_CACHE_IA_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_CACHE_IA_INT_MAP_S  0

/** INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x68)
/** INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_M  (INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_V << INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_S)
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_S  0

/** INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x6c)
/** INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_M  (INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_V << INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_S)
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_S  0

/** INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x70)
/** INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_M  (INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_V << INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_S)
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_S  0

/** INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_REG (DR_REG_INTERRUPT_BASE + 0x74)
/** INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP    0x0000001FU
#define INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_M  (INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_V << INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_S)
#define INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_S  0

/** INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x78)
/** INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_M  (INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_V << INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_S)
#define INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_S  0

/** INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x7c)
/** INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_M  (INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_V << INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_S)
#define INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_S  0

/** INTERRUPT_CORE0_APB_ADC_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_APB_ADC_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x80)
/** INTERRUPT_CORE0_APB_ADC_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_APB_ADC_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_APB_ADC_INT_MAP_M  (INTERRUPT_CORE0_APB_ADC_INT_MAP_V << INTERRUPT_CORE0_APB_ADC_INT_MAP_S)
#define INTERRUPT_CORE0_APB_ADC_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_APB_ADC_INT_MAP_S  0

/** INTERRUPT_CORE0_DMA_CH0_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_DMA_CH0_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x84)
/** INTERRUPT_CORE0_DMA_CH0_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_DMA_CH0_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_DMA_CH0_INT_MAP_M  (INTERRUPT_CORE0_DMA_CH0_INT_MAP_V << INTERRUPT_CORE0_DMA_CH0_INT_MAP_S)
#define INTERRUPT_CORE0_DMA_CH0_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_DMA_CH0_INT_MAP_S  0

/** INTERRUPT_CORE0_SHA_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_SHA_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x88)
/** INTERRUPT_CORE0_SHA_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_SHA_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_SHA_INT_MAP_M  (INTERRUPT_CORE0_SHA_INT_MAP_V << INTERRUPT_CORE0_SHA_INT_MAP_S)
#define INTERRUPT_CORE0_SHA_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_SHA_INT_MAP_S  0

/** INTERRUPT_CORE0_ECC_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_ECC_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0x8c)
/** INTERRUPT_CORE0_ECC_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_ECC_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_ECC_INT_MAP_M  (INTERRUPT_CORE0_ECC_INT_MAP_V << INTERRUPT_CORE0_ECC_INT_MAP_S)
#define INTERRUPT_CORE0_ECC_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_ECC_INT_MAP_S  0

/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_REG (DR_REG_INTERRUPT_BASE + 0x90)
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP    0x0000001FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_S  0

/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_REG (DR_REG_INTERRUPT_BASE + 0x94)
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP    0x0000001FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_S  0

/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_REG (DR_REG_INTERRUPT_BASE + 0x98)
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP    0x0000001FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_S  0

/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_REG (DR_REG_INTERRUPT_BASE + 0x9c)
/** INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP    0x0000001FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_M  (INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_V << INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_S)
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_S  0

/** INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_REG (DR_REG_INTERRUPT_BASE + 0xa0)
/** INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP    0x0000001FU
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_M  (INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_V << INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_S)
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_S  0

/** INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_REG (DR_REG_INTERRUPT_BASE + 0xa4)
/** INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP : R/W; bitpos: [4:0];
 *  default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP    0x0000001FU
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_M  (INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V << INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S)
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S  0

/** INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_REG (DR_REG_INTERRUPT_BASE + 0xa8)
/** INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP    0x0000001FU
#define INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_M  (INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_V << INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_S)
#define INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_V  0x0000001FU
#define INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_S  0

/** INTERRUPT_CORE0_INTR_STATUS_REG_0_REG register
 *  register description
 */
#define INTERRUPT_CORE0_INTR_STATUS_REG_0_REG (DR_REG_INTERRUPT_BASE + 0xac)
/** INTERRUPT_CORE0_INTR_STATUS_0 : RO; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_INTR_STATUS_0    0xFFFFFFFFU
#define INTERRUPT_CORE0_INTR_STATUS_0_M  (INTERRUPT_CORE0_INTR_STATUS_0_V << INTERRUPT_CORE0_INTR_STATUS_0_S)
#define INTERRUPT_CORE0_INTR_STATUS_0_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_INTR_STATUS_0_S  0

/** INTERRUPT_CORE0_INTR_STATUS_REG_1_REG register
 *  register description
 */
#define INTERRUPT_CORE0_INTR_STATUS_REG_1_REG (DR_REG_INTERRUPT_BASE + 0xb0)
/** INTERRUPT_CORE0_INTR_STATUS_1 : RO; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_INTR_STATUS_1    0xFFFFFFFFU
#define INTERRUPT_CORE0_INTR_STATUS_1_M  (INTERRUPT_CORE0_INTR_STATUS_1_V << INTERRUPT_CORE0_INTR_STATUS_1_S)
#define INTERRUPT_CORE0_INTR_STATUS_1_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_INTR_STATUS_1_S  0

/** INTERRUPT_CORE0_CLOCK_GATE_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CLOCK_GATE_REG (DR_REG_INTERRUPT_BASE + 0xb4)
/** INTERRUPT_CORE0_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define INTERRUPT_CORE0_REG_CLK_EN    (BIT(0))
#define INTERRUPT_CORE0_REG_CLK_EN_M  (INTERRUPT_CORE0_REG_CLK_EN_V << INTERRUPT_CORE0_REG_CLK_EN_S)
#define INTERRUPT_CORE0_REG_CLK_EN_V  0x00000001U
#define INTERRUPT_CORE0_REG_CLK_EN_S  0

/** INTERRUPT_CORE0_CPU_INT_ENABLE_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_ENABLE_REG (DR_REG_INTERRUPT_BASE + 0xb8)
/** INTERRUPT_CORE0_CPU_INT_ENABLE : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_INT_ENABLE    0xFFFFFFFFU
#define INTERRUPT_CORE0_CPU_INT_ENABLE_M  (INTERRUPT_CORE0_CPU_INT_ENABLE_V << INTERRUPT_CORE0_CPU_INT_ENABLE_S)
#define INTERRUPT_CORE0_CPU_INT_ENABLE_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CPU_INT_ENABLE_S  0

/** INTERRUPT_CORE0_CPU_INT_TYPE_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_TYPE_REG (DR_REG_INTERRUPT_BASE + 0xbc)
/** INTERRUPT_CORE0_CPU_INT_TYPE : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_INT_TYPE    0xFFFFFFFFU
#define INTERRUPT_CORE0_CPU_INT_TYPE_M  (INTERRUPT_CORE0_CPU_INT_TYPE_V << INTERRUPT_CORE0_CPU_INT_TYPE_S)
#define INTERRUPT_CORE0_CPU_INT_TYPE_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CPU_INT_TYPE_S  0

/** INTERRUPT_CORE0_CPU_INT_CLEAR_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_CLEAR_REG (DR_REG_INTERRUPT_BASE + 0xc0)
/** INTERRUPT_CORE0_CPU_INT_CLEAR : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_INT_CLEAR    0xFFFFFFFFU
#define INTERRUPT_CORE0_CPU_INT_CLEAR_M  (INTERRUPT_CORE0_CPU_INT_CLEAR_V << INTERRUPT_CORE0_CPU_INT_CLEAR_S)
#define INTERRUPT_CORE0_CPU_INT_CLEAR_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CPU_INT_CLEAR_S  0

/** INTERRUPT_CORE0_CPU_INT_EIP_STATUS_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_EIP_STATUS_REG (DR_REG_INTERRUPT_BASE + 0xc4)
/** INTERRUPT_CORE0_CPU_INT_EIP_STATUS : RO; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_INT_EIP_STATUS    0xFFFFFFFFU
#define INTERRUPT_CORE0_CPU_INT_EIP_STATUS_M  (INTERRUPT_CORE0_CPU_INT_EIP_STATUS_V << INTERRUPT_CORE0_CPU_INT_EIP_STATUS_S)
#define INTERRUPT_CORE0_CPU_INT_EIP_STATUS_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CPU_INT_EIP_STATUS_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_0_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_0_REG (DR_REG_INTERRUPT_BASE + 0xc8)
/** INTERRUPT_CORE0_CPU_PRI_0_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_0_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_0_MAP_M  (INTERRUPT_CORE0_CPU_PRI_0_MAP_V << INTERRUPT_CORE0_CPU_PRI_0_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_0_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_0_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_1_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_1_REG (DR_REG_INTERRUPT_BASE + 0xcc)
/** INTERRUPT_CORE0_CPU_PRI_1_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_1_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_1_MAP_M  (INTERRUPT_CORE0_CPU_PRI_1_MAP_V << INTERRUPT_CORE0_CPU_PRI_1_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_1_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_1_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_2_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_2_REG (DR_REG_INTERRUPT_BASE + 0xd0)
/** INTERRUPT_CORE0_CPU_PRI_2_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_2_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_2_MAP_M  (INTERRUPT_CORE0_CPU_PRI_2_MAP_V << INTERRUPT_CORE0_CPU_PRI_2_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_2_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_2_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_3_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_3_REG (DR_REG_INTERRUPT_BASE + 0xd4)
/** INTERRUPT_CORE0_CPU_PRI_3_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_3_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_3_MAP_M  (INTERRUPT_CORE0_CPU_PRI_3_MAP_V << INTERRUPT_CORE0_CPU_PRI_3_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_3_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_3_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_4_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_4_REG (DR_REG_INTERRUPT_BASE + 0xd8)
/** INTERRUPT_CORE0_CPU_PRI_4_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_4_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_4_MAP_M  (INTERRUPT_CORE0_CPU_PRI_4_MAP_V << INTERRUPT_CORE0_CPU_PRI_4_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_4_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_4_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_5_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_5_REG (DR_REG_INTERRUPT_BASE + 0xdc)
/** INTERRUPT_CORE0_CPU_PRI_5_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_5_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_5_MAP_M  (INTERRUPT_CORE0_CPU_PRI_5_MAP_V << INTERRUPT_CORE0_CPU_PRI_5_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_5_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_5_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_6_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_6_REG (DR_REG_INTERRUPT_BASE + 0xe0)
/** INTERRUPT_CORE0_CPU_PRI_6_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_6_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_6_MAP_M  (INTERRUPT_CORE0_CPU_PRI_6_MAP_V << INTERRUPT_CORE0_CPU_PRI_6_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_6_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_6_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_7_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_7_REG (DR_REG_INTERRUPT_BASE + 0xe4)
/** INTERRUPT_CORE0_CPU_PRI_7_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_7_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_7_MAP_M  (INTERRUPT_CORE0_CPU_PRI_7_MAP_V << INTERRUPT_CORE0_CPU_PRI_7_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_7_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_7_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_8_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_8_REG (DR_REG_INTERRUPT_BASE + 0xe8)
/** INTERRUPT_CORE0_CPU_PRI_8_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_8_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_8_MAP_M  (INTERRUPT_CORE0_CPU_PRI_8_MAP_V << INTERRUPT_CORE0_CPU_PRI_8_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_8_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_8_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_9_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_9_REG (DR_REG_INTERRUPT_BASE + 0xec)
/** INTERRUPT_CORE0_CPU_PRI_9_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_9_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_9_MAP_M  (INTERRUPT_CORE0_CPU_PRI_9_MAP_V << INTERRUPT_CORE0_CPU_PRI_9_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_9_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_9_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_10_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_10_REG (DR_REG_INTERRUPT_BASE + 0xf0)
/** INTERRUPT_CORE0_CPU_PRI_10_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_10_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_10_MAP_M  (INTERRUPT_CORE0_CPU_PRI_10_MAP_V << INTERRUPT_CORE0_CPU_PRI_10_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_10_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_10_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_11_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_11_REG (DR_REG_INTERRUPT_BASE + 0xf4)
/** INTERRUPT_CORE0_CPU_PRI_11_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_11_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_11_MAP_M  (INTERRUPT_CORE0_CPU_PRI_11_MAP_V << INTERRUPT_CORE0_CPU_PRI_11_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_11_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_11_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_12_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_12_REG (DR_REG_INTERRUPT_BASE + 0xf8)
/** INTERRUPT_CORE0_CPU_PRI_12_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_12_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_12_MAP_M  (INTERRUPT_CORE0_CPU_PRI_12_MAP_V << INTERRUPT_CORE0_CPU_PRI_12_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_12_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_12_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_13_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_13_REG (DR_REG_INTERRUPT_BASE + 0xfc)
/** INTERRUPT_CORE0_CPU_PRI_13_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_13_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_13_MAP_M  (INTERRUPT_CORE0_CPU_PRI_13_MAP_V << INTERRUPT_CORE0_CPU_PRI_13_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_13_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_13_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_14_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_14_REG (DR_REG_INTERRUPT_BASE + 0x100)
/** INTERRUPT_CORE0_CPU_PRI_14_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_14_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_14_MAP_M  (INTERRUPT_CORE0_CPU_PRI_14_MAP_V << INTERRUPT_CORE0_CPU_PRI_14_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_14_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_14_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_15_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_15_REG (DR_REG_INTERRUPT_BASE + 0x104)
/** INTERRUPT_CORE0_CPU_PRI_15_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_15_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_15_MAP_M  (INTERRUPT_CORE0_CPU_PRI_15_MAP_V << INTERRUPT_CORE0_CPU_PRI_15_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_15_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_15_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_16_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_16_REG (DR_REG_INTERRUPT_BASE + 0x108)
/** INTERRUPT_CORE0_CPU_PRI_16_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_16_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_16_MAP_M  (INTERRUPT_CORE0_CPU_PRI_16_MAP_V << INTERRUPT_CORE0_CPU_PRI_16_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_16_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_16_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_17_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_17_REG (DR_REG_INTERRUPT_BASE + 0x10c)
/** INTERRUPT_CORE0_CPU_PRI_17_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_17_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_17_MAP_M  (INTERRUPT_CORE0_CPU_PRI_17_MAP_V << INTERRUPT_CORE0_CPU_PRI_17_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_17_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_17_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_18_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_18_REG (DR_REG_INTERRUPT_BASE + 0x110)
/** INTERRUPT_CORE0_CPU_PRI_18_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_18_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_18_MAP_M  (INTERRUPT_CORE0_CPU_PRI_18_MAP_V << INTERRUPT_CORE0_CPU_PRI_18_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_18_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_18_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_19_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_19_REG (DR_REG_INTERRUPT_BASE + 0x114)
/** INTERRUPT_CORE0_CPU_PRI_19_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_19_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_19_MAP_M  (INTERRUPT_CORE0_CPU_PRI_19_MAP_V << INTERRUPT_CORE0_CPU_PRI_19_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_19_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_19_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_20_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_20_REG (DR_REG_INTERRUPT_BASE + 0x118)
/** INTERRUPT_CORE0_CPU_PRI_20_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_20_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_20_MAP_M  (INTERRUPT_CORE0_CPU_PRI_20_MAP_V << INTERRUPT_CORE0_CPU_PRI_20_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_20_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_20_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_21_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_21_REG (DR_REG_INTERRUPT_BASE + 0x11c)
/** INTERRUPT_CORE0_CPU_PRI_21_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_21_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_21_MAP_M  (INTERRUPT_CORE0_CPU_PRI_21_MAP_V << INTERRUPT_CORE0_CPU_PRI_21_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_21_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_21_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_22_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_22_REG (DR_REG_INTERRUPT_BASE + 0x120)
/** INTERRUPT_CORE0_CPU_PRI_22_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_22_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_22_MAP_M  (INTERRUPT_CORE0_CPU_PRI_22_MAP_V << INTERRUPT_CORE0_CPU_PRI_22_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_22_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_22_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_23_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_23_REG (DR_REG_INTERRUPT_BASE + 0x124)
/** INTERRUPT_CORE0_CPU_PRI_23_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_23_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_23_MAP_M  (INTERRUPT_CORE0_CPU_PRI_23_MAP_V << INTERRUPT_CORE0_CPU_PRI_23_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_23_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_23_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_24_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_24_REG (DR_REG_INTERRUPT_BASE + 0x128)
/** INTERRUPT_CORE0_CPU_PRI_24_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_24_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_24_MAP_M  (INTERRUPT_CORE0_CPU_PRI_24_MAP_V << INTERRUPT_CORE0_CPU_PRI_24_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_24_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_24_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_25_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_25_REG (DR_REG_INTERRUPT_BASE + 0x12c)
/** INTERRUPT_CORE0_CPU_PRI_25_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_25_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_25_MAP_M  (INTERRUPT_CORE0_CPU_PRI_25_MAP_V << INTERRUPT_CORE0_CPU_PRI_25_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_25_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_25_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_26_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_26_REG (DR_REG_INTERRUPT_BASE + 0x130)
/** INTERRUPT_CORE0_CPU_PRI_26_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_26_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_26_MAP_M  (INTERRUPT_CORE0_CPU_PRI_26_MAP_V << INTERRUPT_CORE0_CPU_PRI_26_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_26_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_26_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_27_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_27_REG (DR_REG_INTERRUPT_BASE + 0x134)
/** INTERRUPT_CORE0_CPU_PRI_27_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_27_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_27_MAP_M  (INTERRUPT_CORE0_CPU_PRI_27_MAP_V << INTERRUPT_CORE0_CPU_PRI_27_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_27_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_27_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_28_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_28_REG (DR_REG_INTERRUPT_BASE + 0x138)
/** INTERRUPT_CORE0_CPU_PRI_28_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_28_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_28_MAP_M  (INTERRUPT_CORE0_CPU_PRI_28_MAP_V << INTERRUPT_CORE0_CPU_PRI_28_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_28_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_28_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_29_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_29_REG (DR_REG_INTERRUPT_BASE + 0x13c)
/** INTERRUPT_CORE0_CPU_PRI_29_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_29_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_29_MAP_M  (INTERRUPT_CORE0_CPU_PRI_29_MAP_V << INTERRUPT_CORE0_CPU_PRI_29_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_29_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_29_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_30_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_30_REG (DR_REG_INTERRUPT_BASE + 0x140)
/** INTERRUPT_CORE0_CPU_PRI_30_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_30_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_30_MAP_M  (INTERRUPT_CORE0_CPU_PRI_30_MAP_V << INTERRUPT_CORE0_CPU_PRI_30_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_30_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_30_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_PRI_31_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_PRI_31_REG (DR_REG_INTERRUPT_BASE + 0x144)
/** INTERRUPT_CORE0_CPU_PRI_31_MAP : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_PRI_31_MAP    0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_31_MAP_M  (INTERRUPT_CORE0_CPU_PRI_31_MAP_V << INTERRUPT_CORE0_CPU_PRI_31_MAP_S)
#define INTERRUPT_CORE0_CPU_PRI_31_MAP_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_PRI_31_MAP_S  0

/** INTERRUPT_CORE0_CPU_INT_THRESH_REG register
 *  register description
 */
#define INTERRUPT_CORE0_CPU_INT_THRESH_REG (DR_REG_INTERRUPT_BASE + 0x148)
/** INTERRUPT_CORE0_CPU_INT_THRESH : R/W; bitpos: [3:0]; default: 0;
 *  Need add description
 */
#define INTERRUPT_CORE0_CPU_INT_THRESH    0x0000000FU
#define INTERRUPT_CORE0_CPU_INT_THRESH_M  (INTERRUPT_CORE0_CPU_INT_THRESH_V << INTERRUPT_CORE0_CPU_INT_THRESH_S)
#define INTERRUPT_CORE0_CPU_INT_THRESH_V  0x0000000FU
#define INTERRUPT_CORE0_CPU_INT_THRESH_S  0

/** INTERRUPT_CORE0_INTERRUPT_REG_DATE_REG register
 *  register description
 */
#define INTERRUPT_CORE0_INTERRUPT_REG_DATE_REG (DR_REG_INTERRUPT_BASE + 0x7fc)
/** INTERRUPT_CORE0_INTERRUPT_REG_DATE : R/W; bitpos: [27:0]; default: 34636176;
 *  Need add description
 */
#define INTERRUPT_CORE0_INTERRUPT_REG_DATE    0x0FFFFFFFU
#define INTERRUPT_CORE0_INTERRUPT_REG_DATE_M  (INTERRUPT_CORE0_INTERRUPT_REG_DATE_V << INTERRUPT_CORE0_INTERRUPT_REG_DATE_S)
#define INTERRUPT_CORE0_INTERRUPT_REG_DATE_V  0x0FFFFFFFU
#define INTERRUPT_CORE0_INTERRUPT_REG_DATE_S  0

#define INTC_INT_PRIO_REG(n)                        (INTERRUPT_CORE0_CPU_INT_PRI_0_REG + (n)*4)

#ifdef __cplusplus
}
#endif
