/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.tdbfmt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.io.EndOfFileException;
import uk.me.parabola.io.StructuredInputStream;
import uk.me.parabola.log.Logger;
import uk.me.parabola.tdbfmt.CopyrightBlock;
import uk.me.parabola.tdbfmt.CopyrightSegment;
import uk.me.parabola.tdbfmt.DetailMapBlock;
import uk.me.parabola.tdbfmt.HeaderBlock;
import uk.me.parabola.tdbfmt.OverviewMapBlock;
import uk.me.parabola.tdbfmt.RBlock;
import uk.me.parabola.tdbfmt.TBlock;

public class TdbFile {
    private static final Logger log = Logger.getLogger(TdbFile.class);
    public static final int TDB_V407 = 407;
    private int tdbVersion;
    private HeaderBlock headerBlock;
    private CopyrightBlock copyrightBlock = new CopyrightBlock();
    private OverviewMapBlock overviewMapBlock;
    private final List<DetailMapBlock> detailBlocks = new ArrayList<DetailMapBlock>();
    private final RBlock rblock = new RBlock();
    private final TBlock tblock = new TBlock();
    private String overviewDescription;
    private int codePage;

    public TdbFile() {
    }

    public TdbFile(int tdbVersion) {
        this.tdbVersion = tdbVersion;
    }

    public static TdbFile read(String name) throws IOException {
        TdbFile tdb = new TdbFile();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(name));){
            tdb.load(is);
        }
        return tdb;
    }

    public void setProductInfo(int familyId, int productId, short productVersion, String seriesName, String familyName, String overviewDescription, byte enableProfile) {
        this.headerBlock = new HeaderBlock(this.tdbVersion);
        this.headerBlock.setFamilyId((short)familyId);
        this.headerBlock.setProductId((short)productId);
        this.headerBlock.setProductVersion(productVersion);
        this.headerBlock.setSeriesName(seriesName);
        this.headerBlock.setFamilyName(familyName);
        this.headerBlock.setEnableProfile(enableProfile);
        this.overviewDescription = overviewDescription;
    }

    public void setCodePage(int codePage) {
        this.codePage = codePage;
        this.headerBlock.setCodePage(codePage);
    }

    public void addCopyright(String msg) {
        if (msg.isEmpty()) {
            return;
        }
        CopyrightSegment seg = new CopyrightSegment(6, 3, msg);
        this.copyrightBlock.addSegment(seg);
    }

    public void setOverview(Area bounds, String number) {
        this.overviewMapBlock = new OverviewMapBlock();
        this.overviewMapBlock.setArea(bounds);
        this.overviewMapBlock.setMapName(number);
        this.overviewMapBlock.setDescription(this.overviewDescription);
    }

    public void addDetail(DetailMapBlock detail) {
        this.detailBlocks.add(detail);
    }

    public void write(String name) throws IOException {
        if (this.headerBlock == null || this.overviewMapBlock == null) {
            throw new IOException("Attempting to write file without being fully set up");
        }
        try (CheckedOutputStream stream = new CheckedOutputStream(new BufferedOutputStream(new FileOutputStream(name)), new CRC32());){
            this.headerBlock.writeTo(stream, this.codePage);
            this.copyrightBlock.writeTo(stream, this.codePage);
            if (this.tdbVersion >= 407) {
                this.rblock.writeTo(stream, this.codePage);
            }
            this.overviewMapBlock.writeTo(stream, this.codePage);
            for (DetailMapBlock detail : this.detailBlocks) {
                detail.writeTo(stream, this.codePage);
            }
            if (this.tdbVersion >= 407) {
                this.tblock.setSum(stream.getChecksum().getValue());
                this.tblock.writeTo(stream, this.codePage);
            }
        }
    }

    private void load(InputStream ds) throws IOException {
        boolean eof = false;
        while (!eof) {
            try {
                this.readBlock(ds);
            }
            catch (EndOfFileException ignore) {
                eof = true;
            }
        }
    }

    private void readBlock(InputStream is) throws IOException {
        int blockType = is.read();
        if (blockType == -1) {
            throw new EndOfFileException();
        }
        int blockLength = this.readBlockLength(is);
        if (blockLength == -1) {
            throw new EndOfFileException();
        }
        byte[] body = new byte[blockLength];
        int n = is.read(body);
        if (n < 0) {
            throw new IOException("failed to read block");
        }
        StructuredInputStream ds = new StructuredInputStream(new ByteArrayInputStream(body));
        switch (blockType) {
            case 80: {
                this.headerBlock = new HeaderBlock(ds);
                log.info("header block seen", this.headerBlock);
                break;
            }
            case 68: {
                log.info((Object)"copyright block");
                this.copyrightBlock = new CopyrightBlock(ds);
                break;
            }
            case 66: {
                this.overviewMapBlock = new OverviewMapBlock(ds);
                log.info("overview block", this.overviewMapBlock);
                break;
            }
            case 76: {
                DetailMapBlock db = new DetailMapBlock(ds);
                log.info("detail block", db);
                this.detailBlocks.add(db);
                break;
            }
            default: {
                log.warn((Object)"Unknown block in tdb file");
            }
        }
    }

    private int readBlockLength(InputStream is) throws IOException {
        int b1 = is.read();
        if (b1 < 0) {
            return -1;
        }
        int b2 = is.read();
        if (b2 < 0) {
            return -1;
        }
        return (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public int getTdbVersion() {
        return this.headerBlock.getTdbVersion();
    }
}

