/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.typ;

import uk.me.parabola.imgfmt.app.typ.ColourInfo;
import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.imgfmt.app.typ.TypLine;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokenScanner;
import uk.me.parabola.mkgmap.typ.CommonSection;
import uk.me.parabola.mkgmap.typ.ProcessSection;

class LineSection
extends CommonSection
implements ProcessSection {
    private final TypLine current = new TypLine();

    LineSection(TypData data) {
        super(data);
    }

    @Override
    public void processLine(TokenScanner scanner, String name, String value) {
        if (this.commonKey(scanner, this.current, name, value)) {
            return;
        }
        if ("UseOrientation".equalsIgnoreCase(name)) {
            this.current.setUseOrientation(value.charAt(0) == 'Y');
        } else if ("LineWidth".equalsIgnoreCase(name)) {
            try {
                int ival = Integer.decode(value);
                this.current.setLineWidth(ival);
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(scanner, "Bad number for line width: " + value);
            }
        } else if ("BorderWidth".equalsIgnoreCase(name)) {
            try {
                int ival = Integer.decode(value);
                this.current.setBorderWidth(ival);
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(scanner, "Bad number for line width: " + value);
            }
        } else {
            this.warnUnknown(name);
        }
    }

    @Override
    public void finish(TokenScanner scanner) {
        this.validate(scanner);
        this.current.finish();
        this.data.addLine(this.current);
    }

    @Override
    protected void xpmCheck(TokenScanner scanner, ColourInfo colourInfo) {
        int width = colourInfo.getWidth();
        if (width == 0) {
            return;
        }
        if (width != 32) {
            throw new SyntaxException(scanner, "Line bitmaps must be 32 bits wide");
        }
    }
}

