/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.boundary.Boundary;
import uk.me.parabola.util.Java2DConverter;

public class BoundaryRelation
extends MultiPolygonRelation {
    private java.awt.geom.Area outerResultArea;
    private Boundary boundary;

    public BoundaryRelation(Relation other, Map<Long, Way> wayMap, Area bbox) {
        super(other, wayMap, bbox);
    }

    public Boundary getBoundary() {
        if (this.boundary == null) {
            if (this.outerResultArea == null) {
                return null;
            }
            this.boundary = new Boundary(this.outerResultArea, this, "r" + this.getId());
            this.outerResultArea = null;
        }
        return this.boundary;
    }

    @Override
    protected boolean isUsable() {
        return true;
    }

    @Override
    protected boolean assumeDataInBoundsIsComplete() {
        return false;
    }

    @Override
    protected boolean needsWaysForOutlines() {
        return false;
    }

    @Override
    protected void processQueue(MultiPolygonRelation.Partition partition, Queue<MultiPolygonRelation.PolygonStatus> polygonWorkingQueue) {
        if (this.outerResultArea == null) {
            this.outerResultArea = new java.awt.geom.Area();
        }
        while (!polygonWorkingQueue.isEmpty()) {
            MultiPolygonRelation.PolygonStatus currentPolygon = polygonWorkingQueue.poll();
            partition.markFinished(currentPolygon);
            List<MultiPolygonRelation.PolygonStatus> holes = partition.getPolygonStatus(currentPolygon);
            polygonWorkingQueue.addAll(holes);
            if (currentPolygon.outer) {
                this.outerWaysForLineTagging.addAll(currentPolygon.polygon.getOriginalWays());
                java.awt.geom.Area toAdd = Java2DConverter.createArea(currentPolygon.polygon.getPoints());
                if (this.outerResultArea.isEmpty()) {
                    this.outerResultArea = toAdd;
                    continue;
                }
                this.outerResultArea.add(toAdd);
                continue;
            }
            this.outerResultArea.subtract(Java2DConverter.createArea(currentPolygon.polygon.getPoints()));
        }
    }

    @Override
    protected boolean doReporting() {
        return false;
    }

    @Override
    protected double getMaxCloseDist() {
        String admString = this.getTag("admin_level");
        if (admString == null) {
            return 1000.0;
        }
        switch (admString) {
            case "2": {
                return 50000.0;
            }
            case "3": {
                return 20000.0;
            }
            case "4": {
                return 4000.0;
            }
        }
        return 1000.0;
    }

    @Override
    public String toString() {
        String basicInfo = "boundary r" + this.getId();
        String admLevel = this.getTag("admin_level");
        if (admLevel != null) {
            return basicInfo + " admlvl=" + admLevel + " (" + this.getTag("name") + ")";
        }
        String postal = this.getTag("postal_code");
        if (postal != null) {
            return basicInfo + " postal_code=" + postal;
        }
        return basicInfo;
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.getElements().clear();
        ((ArrayList)this.getElements()).trimToSize();
    }
}

