/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.function;

import java.util.Locale;
import uk.me.parabola.mkgmap.osmstyle.function.CachedFunction;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.Way;

public class AreaSizeFunction
extends CachedFunction {
    public AreaSizeFunction() {
        super(null);
    }

    @Override
    protected String calcImpl(Element el) {
        if (el instanceof Way) {
            Way w = (Way)el;
            if (!w.hasEqualEndPoints()) {
                return "0";
            }
            long fullArea = w.getFullArea();
            if (fullArea == Long.MAX_VALUE) {
                return "0";
            }
            double areaSize = (double)fullArea / 8192.0;
            return String.format(Locale.US, "%.3f", Math.abs(areaSize));
        }
        return null;
    }

    @Override
    public String getName() {
        return "area_size";
    }

    @Override
    public boolean supportsWay() {
        return true;
    }

    @Override
    public int getComplexity() {
        return 2;
    }
}

