/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.log;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import uk.me.parabola.log.LogLevel;
import uk.me.parabola.log.UsefulFormatter;

public class Logger {
    private final java.util.logging.Logger log;
    private final boolean addPrefix;
    public static final Logger defaultLogger = new Logger("global", false);
    private static final ThreadLocal<String> threadTags = new ThreadLocal();

    private Logger(String name, boolean addPrefix) {
        this.log = java.util.logging.Logger.getLogger(name);
        this.addPrefix = addPrefix;
    }

    public static Logger getLogger(String name) {
        return new Logger(name, true);
    }

    public static Logger getLogger(Class<?> aClass) {
        String name = aClass.getName();
        return Logger.getLogger(name);
    }

    public static void resetLogging(String filename) {
        Logger.initLoggingFromFile(filename);
    }

    private static void initLogging() {
        Properties props = System.getProperties();
        String logconf = props.getProperty("log.config");
        if (logconf != null) {
            Logger.initLoggingFromFile(logconf);
        } else {
            Logger.staticSetup();
        }
        if (!defaultLogger.isLoggable(Level.WARNING)) {
            Logger.defaultLogger.log.setLevel(Level.WARNING);
        }
    }

    private static void initLoggingFromFile(String logconf) {
        try {
            FileInputStream in = new FileInputStream(logconf);
            LogManager lm = LogManager.getLogManager();
            lm.reset();
            lm.readConfiguration(in);
        }
        catch (FileNotFoundException e) {
            System.err.println("Failed to open logging config file " + logconf);
            Logger.staticSetup();
        }
        catch (IOException e) {
            Logger.staticSetup();
        }
    }

    private static void staticSetup() {
        LogManager.getLogManager().reset();
        java.util.logging.Logger l = java.util.logging.Logger.getLogger("");
        ConsoleHandler handler = new ConsoleHandler();
        UsefulFormatter f = new UsefulFormatter();
        f.setShowTime(false);
        handler.setFormatter(f);
        handler.setLevel(Level.FINE);
        l.addHandler(handler);
        l.setLevel(Level.SEVERE);
    }

    public boolean isLoggable(Level level) {
        return this.log.isLoggable(level);
    }

    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    public void debug(Object o) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.tagMessage(o == null ? "null" : o.toString()));
        }
    }

    public void debug(Object ... olist) {
        if (this.log.isLoggable(Level.FINE)) {
            this.arrayFormat(Level.FINE, olist);
        }
    }

    public void info(Object o) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.tagMessage(o == null ? "null" : o.toString()));
        }
    }

    public void info(Object ... olist) {
        if (this.log.isLoggable(Level.INFO)) {
            this.arrayFormat(Level.INFO, olist);
        }
    }

    public void infof(String fmt, Object ... args) {
        if (this.log.isLoggable(Level.INFO)) {
            this.printf(Level.INFO, fmt, args);
        }
    }

    public void warn(Object o) {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning(this.tagMessage(o == null ? "null" : o.toString()));
        }
    }

    public void warn(Object ... olist) {
        if (this.log.isLoggable(Level.WARNING)) {
            this.arrayFormat(Level.WARNING, olist);
        }
    }

    public void warnf(String fmt, Object ... args) {
        if (this.log.isLoggable(Level.WARNING)) {
            this.printf(Level.WARNING, fmt, args);
        }
    }

    public void error(Object o) {
        this.log.severe(this.tagMessage(o == null ? "null" : o.toString()));
    }

    public void error(Object ... olist) {
        this.arrayFormat(Level.SEVERE, olist);
    }

    public void errorf(String fmt, Object ... args) {
        this.printf(Level.SEVERE, fmt, args);
    }

    public void error(Object o, Throwable e) {
        this.log.log(Level.SEVERE, this.tagMessage(o == null ? "null" : o.toString()), e);
    }

    public void diagnostic(String msg) {
        this.log.log((Level)LogLevel.DIAGNOSTIC, this.tagMessage(msg));
    }

    public void echo(String msg) {
        this.log.log((Level)LogLevel.ECHO, this.tagMessage(msg));
    }

    public void write(String msg) {
        this.log.log((Level)LogLevel.OVERRIDE, this.tagMessage(msg));
    }

    public void log(Level level, Object o) {
        if (this.log.isLoggable(level)) {
            this.log.log(level, this.tagMessage(o == null ? "null" : o.toString()));
        }
    }

    public void log(Level level, Object ... olist) {
        if (this.log.isLoggable(level)) {
            this.arrayFormat(level, olist);
        }
    }

    private void arrayFormat(Level type, Object ... olist) {
        if (this.log.isLoggable(type)) {
            StringBuilder sb = new StringBuilder();
            for (Object o : olist) {
                sb.append(o);
                sb.append(' ');
            }
            sb.setLength(sb.length() - 1);
            this.log.log(type, this.tagMessage(sb.toString()));
        }
    }

    private void printf(Level type, String fmt, Object ... args) {
        if (this.log.isLoggable(type)) {
            String msg = String.format(fmt, args);
            this.log.log(type, this.tagMessage(msg));
        }
    }

    private String tagMessage(String message) {
        if (!this.addPrefix) {
            return message;
        }
        String threadTag = threadTags.get();
        return threadTag != null ? threadTag + ": " + message : message;
    }

    public void threadTag(String tag) {
        threadTags.set(tag);
    }

    public String threadTag() {
        return threadTags.get();
    }

    static {
        Logger.initLogging();
    }
}

