/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.SectionWriter;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.imgfmt.app.typ.TYPHeader;
import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.imgfmt.app.typ.TypElement;
import uk.me.parabola.imgfmt.app.typ.TypIconSet;
import uk.me.parabola.imgfmt.app.typ.TypParam;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;

public class TYPFile
extends ImgFile {
    private static final Logger log = Logger.getLogger(TYPFile.class);
    private final TYPHeader header = new TYPHeader();
    private TypData data;
    private final Map<Integer, Integer> strToType = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> typeToStr = new TreeMap<Integer, Integer>();

    public TYPFile(ImgChannel chan) {
        this.setHeader(this.header);
        this.setWriter(new BufferedImgFileWriter(chan, "TYP"));
        this.position(156L);
    }

    public void write() {
        ImgFileWriter writer = this.getWriter();
        writer.position(156L);
        this.writeSection(writer, this.header.getPolygonData(), this.header.getPolygonIndex(), this.data.getPolygons());
        this.writeSection(writer, this.header.getLineData(), this.header.getLineIndex(), this.data.getLines());
        this.writeSection(writer, this.header.getPointData(), this.header.getPointIndex(), this.data.getPoints());
        SectionWriter subWriter = this.header.getShapeStacking().makeSectionWriter(writer);
        this.data.getStacking().write(subWriter);
        Utils.closeFile(subWriter);
        this.writeSection(writer, this.header.getIconData(), this.header.getIconIndex(), this.data.getIcons());
        this.writeLabels(writer);
        this.writeStrIndex(writer);
        this.writerTypeIndex(writer);
        TYPFile.zapZero(this.header.getShapeStacking(), this.header.getLabels(), this.header.getStringIndex(), this.header.getTypeIndex());
        log.debug((Object)"syncing TYP file");
        this.position(0L);
        this.getHeader().writeHeader(this.getWriter());
    }

    private void writeLabels(ImgFileWriter in) {
        if (this.data.getIcons().isEmpty()) {
            return;
        }
        SectionWriter writer = this.header.getLabels().makeSectionWriter(in);
        ArrayList<SortKey<TypIconSet>> keys = new ArrayList<SortKey<TypIconSet>>();
        Sort sort = this.data.getSort();
        for (TypIconSet typIconSet : this.data.getIcons()) {
            String label = typIconSet.getLabel();
            if (label == null) continue;
            SortKey<TypIconSet> key = sort.createSortKey(typIconSet, label);
            keys.add(key);
        }
        keys.sort(null);
        writer.put1u(0);
        for (SortKey sortKey : keys) {
            int off = writer.position();
            TypIconSet icon = (TypIconSet)sortKey.getObject();
            int type = icon.getTypeForFile();
            String label = icon.getLabel();
            if (label == null) continue;
            CharBuffer cb = CharBuffer.wrap(label);
            CharsetEncoder encoder = this.data.getEncoder();
            try {
                ByteBuffer buffer = encoder.encode(cb);
                writer.put(buffer);
                this.strToType.put(off, type);
                this.typeToStr.put(type, off);
                writer.put1u(0);
            }
            catch (CharacterCodingException ignore) {
                String name = encoder.charset().name();
                log.warn("Cannot represent icon String", label, "in CodePage", name);
            }
        }
        Utils.closeFile(writer);
    }

    private void writeStrIndex(ImgFileWriter in) {
        SectionWriter writer = this.header.getStringIndex().makeSectionWriter(in);
        int psize = Utils.numberToPointerSize(this.header.getLabels().getSize());
        this.header.getStringIndex().setItemSize((char)(3 + psize));
        for (Map.Entry<Integer, Integer> ent : this.strToType.entrySet()) {
            writer.putNu(psize, ent.getKey());
            writer.put3u(ent.getValue());
        }
        Utils.closeFile(writer);
    }

    private void writerTypeIndex(ImgFileWriter in) {
        SectionWriter writer = this.header.getTypeIndex().makeSectionWriter(in);
        int psize = Utils.numberToPointerSize(this.header.getLabels().getSize());
        this.header.getTypeIndex().setItemSize((char)(3 + psize));
        for (Map.Entry<Integer, Integer> ent : this.typeToStr.entrySet()) {
            writer.put3u(ent.getKey());
            writer.putNu(psize, ent.getValue());
        }
        Utils.closeFile(writer);
    }

    private void writeSection(ImgFileWriter writer, Section dataSection, Section indexSection, List<? extends TypElement> elementData) {
        elementData.sort(null);
        SectionWriter subWriter = dataSection.makeSectionWriter(writer);
        CharsetEncoder encoder = this.data.getEncoder();
        for (TypElement typElement : elementData) {
            typElement.write(subWriter, encoder);
        }
        Utils.closeFile(subWriter);
        int size = dataSection.getSize();
        int n = indexSection.getItemSize();
        int psize = Utils.numberToPointerSize(size);
        indexSection.setItemSize((char)(n + psize));
        subWriter = indexSection.makeSectionWriter(writer);
        for (TypElement typElement : elementData) {
            int offset = typElement.getOffset();
            int type = typElement.getTypeForFile();
            subWriter.putNu(n, type);
            subWriter.putNu(psize, offset);
        }
        Utils.closeFile(subWriter);
        TYPFile.zapZero(dataSection, indexSection);
    }

    private static void zapZero(Section ... sect) {
        for (Section s : sect) {
            if (s.getSize() != 0) continue;
            s.setPosition(0);
            s.setItemSize(0);
        }
    }

    public void setData(TypData data) {
        this.data = data;
        TypParam param = data.getParam();
        this.header.setCodePage((char)param.getCodePage());
        this.header.setFamilyId((char)param.getFamilyId());
        this.header.setProductId((char)param.getProductId());
    }
}

