/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.BitWriter;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Writeable;
import uk.me.parabola.imgfmt.app.typ.AlphaAdder;
import uk.me.parabola.imgfmt.app.typ.Rgb;
import uk.me.parabola.imgfmt.app.typ.RgbWithTag;

public class ColourInfo
implements Writeable,
AlphaAdder {
    private static final int S_NIGHT = 1;
    private static final int S_DAY_TRANSPARENT = 2;
    private static final int S_NIGHT_TRANSPARENT = 4;
    private static final int S_HAS_BITMAP = 8;
    private int numberOfColours;
    private int numberOfSolidColours;
    private boolean hasBitmap;
    private boolean hasBorder;
    private final List<RgbWithTag> colours = new ArrayList<RgbWithTag>();
    private final Map<String, Integer> indexMap = new HashMap<String, Integer>();
    private char width;
    private char height;
    private char charsPerPixel;
    private boolean simple = true;
    private char colourMode;

    public void addColour(String tag, Rgb rgb) {
        RgbWithTag cwt = new RgbWithTag(tag, rgb);
        this.colours.add(cwt);
    }

    public void addTransparent(String colourTag) {
        this.addColour(colourTag, new Rgb(0, 0, 0, 0));
    }

    public void setHasBitmap(boolean hasBitmap) {
        this.hasBitmap = hasBitmap;
    }

    public int getColourScheme() {
        if (this.numberOfColours == 0) {
            this.numberOfColours = this.colours.size();
        }
        int scheme = 0;
        if (this.hasBitmap) {
            scheme |= 8;
        }
        if (this.numberOfColours == 4) {
            scheme |= 1;
        }
        if (!this.hasBitmap && !this.hasBorder && this.numberOfColours == 2) {
            scheme |= 7;
        }
        if (this.numberOfColours < 2 || this.colours.get(1).isTransparent()) {
            scheme |= 2;
        }
        if (this.numberOfColours == 4 && this.colours.get(3).isTransparent()) {
            scheme |= 4;
        }
        if ((scheme & 1) == 0 && (scheme & 2) != 0) {
            scheme |= 4;
        }
        return scheme;
    }

    public int getBitsPerPixel() {
        if (this.simple) {
            return 1;
        }
        int nc = this.numberOfColours;
        if (nc == 0) {
            return 24;
        }
        if (nc < 2) {
            return 1;
        }
        if (nc < 4) {
            return 2;
        }
        if (nc < 16) {
            return 4;
        }
        return 8;
    }

    @Override
    public void write(ImgFileWriter writer) {
        if (this.colourMode == ' ') {
            this.writeColours20(writer);
        } else {
            for (Rgb rgb : this.colours) {
                if (rgb.isTransparent()) continue;
                rgb.write(writer, (byte)16);
            }
        }
    }

    private void writeColours20(ImgFileWriter writer) {
        BitWriter bw = new BitWriter();
        for (Rgb rgb : this.colours) {
            bw.putn(rgb.getB(), 8);
            bw.putn(rgb.getG(), 8);
            bw.putn(rgb.getR(), 8);
            int alpha = 255 - rgb.getA();
            alpha = ColourInfo.alphaRound4(alpha);
            bw.putn(alpha, 4);
        }
        writer.put(bw.getBytes(), 0, bw.getLength());
    }

    static int alphaRound4(int alpha) {
        int low = alpha & 0xF;
        int top = alpha >> 4 & 0xF;
        int diff = low - top;
        if (diff > 8) {
            ++top;
        } else if (diff < -8) {
            --top;
        }
        return top;
    }

    public int getIndex(String tag) {
        Integer ind = this.indexMap.get(tag);
        if (this.simple) {
            ind = ~ind.intValue();
        }
        return ind;
    }

    public void setWidth(int width) {
        this.width = (char)width;
    }

    public void setHeight(int height) {
        this.height = (char)height;
    }

    public void setNumberOfColours(int numberOfColours) {
        this.numberOfColours = numberOfColours;
    }

    public void setCharsPerPixel(int charsPerPixel) {
        this.charsPerPixel = (char)(charsPerPixel == 0 ? 1 : charsPerPixel);
    }

    public int getNumberOfColours() {
        return this.numberOfColours;
    }

    public int getNumberOfSColoursForCM() {
        if (this.colourMode == '\u0010') {
            return this.numberOfSolidColours;
        }
        return this.numberOfColours;
    }

    public int getCharsPerPixel() {
        return this.charsPerPixel;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getColourMode() {
        return this.colourMode;
    }

    public void setColourMode(int colourMode) {
        this.colourMode = (char)colourMode;
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    public void setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
    }

    @Override
    public void addAlpha(int alpha) {
        int last = this.colours.size();
        RgbWithTag rgb = this.colours.get(last - 1);
        rgb = new RgbWithTag(rgb, alpha);
        this.colours.set(last - 1, rgb);
    }

    public String analyseColours(boolean simple) {
        this.setSimple(simple);
        if (simple) {
            if (this.numberOfColours > 4) {
                return "Too many colours for a line or polygon";
            }
            if (this.numberOfColours == 0) {
                return "Line or polygon cannot have zero colours";
            }
            if (this.colours.get(0).isTransparent()) {
                if (this.numberOfColours < 2) {
                    return "Only colour cannot be transparent for line or polygon";
                }
                this.swapColour(0, 1);
            }
            if (this.numberOfColours > 2 && this.colours.get(2).isTransparent()) {
                if (this.numberOfColours < 4) {
                    return "Only colour cannot be transparent for line or polygon";
                }
                this.swapColour(2, 3);
            }
            if (this.numberOfColours > 1 && this.colours.get(0).isTransparent()) {
                return "Both day foreground and background are transparent";
            }
            if (this.numberOfColours > 3 && this.colours.get(2).isTransparent()) {
                return "Both night foreground and background are transparent";
            }
        } else {
            int transIndex = 0;
            int nTrans = 0;
            int nAlpha = 0;
            int count = 0;
            for (RgbWithTag rgb : this.colours) {
                if (rgb.isTransparent()) {
                    ++nTrans;
                    transIndex = count;
                }
                if (rgb.getA() != 255 && rgb.getA() != 0) {
                    ++nAlpha;
                }
                ++count;
            }
            if (nAlpha > 0 || count > 0 && count == nTrans) {
                this.colourMode = (char)32;
            } else if (nTrans == 1) {
                this.colourMode = (char)16;
                RgbWithTag rgb = this.colours.remove(transIndex);
                this.colours.add(rgb);
            }
        }
        int count = 0;
        for (RgbWithTag rgb : this.colours) {
            this.indexMap.put(rgb.getTag(), count++);
            if (rgb.isTransparent()) continue;
            ++this.numberOfSolidColours;
        }
        return null;
    }

    private void swapColour(int c1, int c2) {
        RgbWithTag tmp = this.colours.get(c1);
        this.colours.set(c1, this.colours.get(c2));
        this.colours.set(c2, tmp);
    }
}

