/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.util.Java2DConverter;

public class QuadTreeNode {
    private static final int MAX_POINTS = 20;
    private Collection<Coord> points;
    private final Area bounds;
    private Area coveredBounds;
    private QuadTreeNode[] children;

    public Area getCoveredBounds() {
        return this.coveredBounds;
    }

    public QuadTreeNode(Area bounds) {
        this(bounds, Collections.emptyList());
    }

    public QuadTreeNode(Area bounds, Collection<Coord> points) {
        this.bounds = bounds;
        this.children = null;
        int minLat = Integer.MAX_VALUE;
        int maxLat = Integer.MIN_VALUE;
        int minLong = Integer.MAX_VALUE;
        int maxLong = Integer.MIN_VALUE;
        for (Coord c : points) {
            if (c.getLatitude() < minLat) {
                minLat = c.getLatitude();
            }
            if (c.getLatitude() > maxLat) {
                maxLat = c.getLatitude();
            }
            if (c.getLongitude() < minLong) {
                minLong = c.getLongitude();
            }
            if (c.getLongitude() <= maxLong) continue;
            maxLong = c.getLongitude();
        }
        this.coveredBounds = new Area(minLat, minLong, maxLat, maxLong);
        if (points.size() > 20) {
            this.points = points;
            this.split();
        } else {
            this.points = new HashSet<Coord>(points);
        }
    }

    public Area getBounds() {
        return this.bounds;
    }

    public boolean add(Coord c) {
        if (this.coveredBounds == null) {
            this.coveredBounds = new Area(c.getLatitude(), c.getLongitude(), c.getLatitude(), c.getLongitude());
        } else if (!this.coveredBounds.contains(c)) {
            this.coveredBounds = new Area(Math.min(this.coveredBounds.getMinLat(), c.getLatitude()), Math.min(this.coveredBounds.getMinLong(), c.getLongitude()), Math.max(this.coveredBounds.getMaxLat(), c.getLatitude()), Math.max(this.coveredBounds.getMaxLong(), c.getLongitude()));
        }
        if (this.isLeaf()) {
            boolean added = this.points.add(c);
            if (this.points.size() > 20) {
                this.split();
            }
            return added;
        }
        for (QuadTreeNode nodes : this.children) {
            if (!nodes.getBounds().contains(c)) continue;
            return nodes.add(c);
        }
        return false;
    }

    public List<Coord> get(Area bbox, List<Coord> resultList) {
        if (this.isLeaf()) {
            if (bbox.contains(this.coveredBounds)) {
                resultList.addAll(this.points);
            } else {
                for (Coord c : this.points) {
                    if (!bbox.contains(c)) continue;
                    resultList.add(c);
                }
            }
        } else {
            for (QuadTreeNode child : this.children) {
                if (!bbox.intersects(child.getCoveredBounds())) continue;
                resultList = child.get(bbox, resultList);
            }
        }
        return resultList;
    }

    public List<Coord> get(QuadTreePolygon polygon, List<Coord> resultList) {
        block4: {
            if (!polygon.getBbox().intersects(this.getBounds())) break block4;
            if (this.isLeaf()) {
                for (Coord c : this.points) {
                    if (!polygon.getArea().contains(c.getLongitude(), c.getLatitude())) continue;
                    resultList.add(c);
                }
            } else {
                for (QuadTreeNode child : this.children) {
                    if (!polygon.getBbox().intersects(child.getBounds())) continue;
                    java.awt.geom.Area subArea = (java.awt.geom.Area)polygon.getArea().clone();
                    subArea.intersect(QuadTreeNode.createArea(child.getBounds()));
                    child.get(new QuadTreePolygon(subArea), resultList);
                }
            }
        }
        return resultList;
    }

    private static java.awt.geom.Area createArea(Area bbox) {
        return new java.awt.geom.Area(new Rectangle(bbox.getMinLong(), bbox.getMinLat(), bbox.getWidth(), bbox.getHeight()));
    }

    public boolean isLeaf() {
        return this.points != null;
    }

    private void split() {
        if (this.bounds.getHeight() <= 1 || this.bounds.getWidth() <= 1) {
            return;
        }
        int halfLat = (this.bounds.getMinLat() + this.bounds.getMaxLat()) / 2;
        int halfLong = (this.bounds.getMinLong() + this.bounds.getMaxLong()) / 2;
        this.children = new QuadTreeNode[4];
        Area swBounds = new Area(this.bounds.getMinLat(), this.bounds.getMinLong(), halfLat, halfLong);
        Area nwBounds = new Area(halfLat, this.bounds.getMinLong(), this.bounds.getMaxLat(), halfLong);
        Area seBounds = new Area(this.bounds.getMinLat(), halfLong, halfLat, this.bounds.getMaxLong());
        Area neBounds = new Area(halfLat, halfLong, this.bounds.getMaxLat(), this.bounds.getMaxLong());
        this.children[0] = new QuadTreeNode(swBounds);
        this.children[1] = new QuadTreeNode(nwBounds);
        this.children[2] = new QuadTreeNode(seBounds);
        this.children[3] = new QuadTreeNode(neBounds);
        Collection<Coord> copyPoints = this.points;
        this.points = null;
        for (Coord c : copyPoints) {
            this.add(c);
        }
    }

    public void clear() {
        this.children = null;
        this.points = new HashSet<Coord>();
        this.coveredBounds = new Area(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static final class QuadTreePolygon {
        private final java.awt.geom.Area javaArea;
        private final Area bbox;

        public QuadTreePolygon(java.awt.geom.Area javaArea) {
            this.javaArea = javaArea;
            Rectangle bboxRect = javaArea.getBounds();
            this.bbox = new Area(bboxRect.y, bboxRect.x, bboxRect.y + bboxRect.height, bboxRect.x + bboxRect.width);
        }

        public QuadTreePolygon(List<Coord> points) {
            this(Java2DConverter.createArea(points));
        }

        public QuadTreePolygon(Collection<List<Coord>> polygonList) {
            this.javaArea = new java.awt.geom.Area();
            for (List<Coord> polygon : polygonList) {
                this.javaArea.add(Java2DConverter.createArea(polygon));
            }
            Rectangle bboxRect = this.javaArea.getBounds();
            this.bbox = new Area(bboxRect.y, bboxRect.x, bboxRect.y + bboxRect.height, bboxRect.x + bboxRect.width);
        }

        public Area getBbox() {
            return this.bbox;
        }

        public java.awt.geom.Area getArea() {
            return this.javaArea;
        }
    }
}

