/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.typ;

import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokenScanner;
import uk.me.parabola.mkgmap.typ.ProcessSection;

class DrawOrderSection
implements ProcessSection {
    private final TypData data;

    DrawOrderSection(TypData data) {
        this.data = data;
    }

    @Override
    public void processLine(TokenScanner scanner, String name, String value) {
        int type;
        int fulltype;
        if (!"Type".equalsIgnoreCase(name)) {
            throw new SyntaxException(scanner, "Unrecognised keyword in draw order section: " + name);
        }
        String[] typeDrawOrder = value.split(",", -1);
        if (typeDrawOrder.length != 2) {
            throw new SyntaxException(scanner, "Unrecognised drawOrder type " + value);
        }
        try {
            fulltype = Integer.decode(typeDrawOrder[0]);
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(scanner, "Bad number " + typeDrawOrder[0]);
        }
        int subtype = 0;
        if (fulltype >= 256) {
            type = fulltype >>> 8 & 0x3FFF;
            subtype = fulltype & 0xFF;
        } else {
            type = fulltype & 0xFF;
        }
        try {
            int level = Integer.parseInt(typeDrawOrder[1]);
            this.data.addPolygonStackOrder(level, type, subtype);
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(scanner, "Bad number '" + typeDrawOrder[1] + "'");
        }
    }

    @Override
    public void finish(TokenScanner scanner) {
    }
}

