/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.polish;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapDetails;
import uk.me.parabola.mkgmap.reader.polish.PolishTurnRestriction;
import uk.me.parabola.mkgmap.reader.polish.RoadHelper;

public class RestrictionHelper {
    private final List<PolishTurnRestriction> allRestrictions = new ArrayList<PolishTurnRestriction>();

    public void processAndAddRestrictions(RoadHelper roadHelper, MapDetails mapper) {
        Map<Long, CoordNode> allNodes = roadHelper.getNodeCoords();
        for (PolishTurnRestriction tr : this.allRestrictions) {
            GeneralRouteRestriction grr;
            if (!tr.isValid() || (grr = tr.toGeneralRouteRestriction(allNodes)) == null) continue;
            mapper.addRestriction(grr);
        }
    }

    public void addRestriction(PolishTurnRestriction restriction) {
        if (restriction.isValid()) {
            this.allRestrictions.add(restriction);
        } else {
            Logger.defaultLogger.warn((Object)("Invalid restriction " + restriction.toString()));
        }
    }
}

