/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.overview;

import java.awt.geom.Path2D;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.combiners.OverviewMap;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.reader.MapperBasedMapDataSource;
import uk.me.parabola.util.Java2DConverter;

public class OverviewMapDataSource
extends MapperBasedMapDataSource
implements OverviewMap {
    private static final Logger log = Logger.getLogger(OverviewMapDataSource.class);
    private final List<String> copyrights = new ArrayList<String>();
    LevelInfo[] levels = null;
    private Path2D tileAreaPath = new Path2D.Double();

    public Path2D getTileAreaPath() {
        return this.tileAreaPath;
    }

    public void addToTileAreaPath(List<Coord> points) {
        this.tileAreaPath.append(Java2DConverter.createPath2D(points), false);
    }

    @Override
    public boolean isFileSupported(String name) {
        return false;
    }

    @Override
    public void load(String name, boolean addBackground) throws FileNotFoundException, FormatException {
        throw new FileNotFoundException("This is not supposed to be called");
    }

    @Override
    public LevelInfo[] mapLevels() {
        return this.levels;
    }

    @Override
    public LevelInfo[] overviewMapLevels() {
        return this.mapLevels();
    }

    @Override
    public void setMapLevels(LevelInfo[] mapLevels) {
        if (this.levels == null) {
            this.levels = mapLevels;
        } else {
            boolean ok = true;
            if (this.levels.length != mapLevels.length) {
                ok = false;
            } else {
                for (int i = 0; i < this.levels.length; ++i) {
                    if (this.levels[i].compareTo(mapLevels[i]) == 0) continue;
                    ok = false;
                }
            }
            if (!ok) {
                log.error((Object)"invalid attempt to change map levels");
            }
        }
    }

    @Override
    public void addCopyright(String cw) {
        this.copyrights.add(cw);
    }

    @Override
    public String[] copyrightMessages() {
        return this.copyrights.toArray(new String[this.copyrights.size()]);
    }

    @Override
    public void addToBounds(Coord p) {
        this.mapper.addToBounds(p);
    }

    @Override
    public void addPoint(MapPoint point) {
        this.mapper.addPoint(point);
    }

    @Override
    public void addLine(MapLine line) {
        this.mapper.addLine(line);
    }

    @Override
    public void addShape(MapShape shape) {
        this.mapper.addShape(shape);
    }

    @Override
    public void addRoad(MapRoad road) {
        this.addLine(road);
    }

    @Override
    public int addRestriction(GeneralRouteRestriction grr) {
        log.error((Object)"This is not supposed to be called");
        return 0;
    }

    public void addThroughRoute(int junctionNodeId, long roadIdA, long roadIdB) {
        log.error((Object)"This is not supposed to be called");
    }

    @Override
    public int getPoiDispFlag() {
        return 0;
    }
}

