/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.ShapeMergeFilter;
import uk.me.parabola.mkgmap.general.LineClipper;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.osmstyle.StyleImpl;
import uk.me.parabola.mkgmap.reader.osm.CoastlineFileLoader;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.GeneralRelation;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.OsmPrecompSeaDataSource;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.SeaPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.Java2DConverter;

public class SeaGenerator
implements OsmReadingHooks {
    private static final Logger log = Logger.getLogger(SeaGenerator.class);
    private String precompSea;
    private boolean generateSeaUsingMP = true;
    private int maxCoastlineGap;
    private boolean allowSeaSectors = true;
    private boolean extendSeaSectors;
    private String[] landTag = new String[]{"natural", "land"};
    private boolean floodblocker;
    private int fbGap = 40;
    private double fbRatio = 0.5;
    private int fbThreshold = 20;
    private boolean fbDebug;
    private boolean checkCoastline = false;
    private ElementSaver saver;
    private List<Way> shoreline = new ArrayList<Way>();
    private List<Way> islands = new ArrayList<Way>();
    private List<Way> antiIslands = new ArrayList<Way>();
    private Area tileBounds;
    private boolean generateSeaBackground = true;
    private String[] coastlineFilenames;
    private StyleImpl fbRules;
    private boolean improveOverview;
    public static final int PRECOMP_RASTER = 32768;
    private static final byte SEA_TILE = 115;
    private static final byte LAND_TILE = 108;
    private static final byte MIXED_TILE = 109;
    private static ThreadLocal<PrecompData> precompIndex = new ThreadLocal();
    private static Map<String, Boolean> checkedPrecomp = new ConcurrentHashMap<String, Boolean>();
    private static final int MIN_LAT = Utils.toMapUnit(-90.0);
    private static final int MAX_LAT = Utils.toMapUnit(90.0);
    private static final int MIN_LON = Utils.toMapUnit(-180.0);
    private static final int MAX_LON = Utils.toMapUnit(180.0);
    private static final int INDEX_WIDTH = (SeaGenerator.getPrecompTileStart(MAX_LON) - SeaGenerator.getPrecompTileStart(MIN_LON)) / 32768;
    private static final int INDEX_HEIGHT = (SeaGenerator.getPrecompTileStart(MAX_LAT) - SeaGenerator.getPrecompTileStart(MIN_LAT)) / 32768;
    private static final Pattern KEY_SPLITTER = Pattern.compile(Pattern.quote("_"));
    private static final Pattern SEMICOLON_SPLITTER = Pattern.compile(Pattern.quote(";"));
    private static final short TK_NATURAL = TagDict.getInstance().xlate("natural");
    private static final long SEA_SIZE = 0x7FFFFFFFFFFFFFFDL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props, Style style) {
        String gs;
        this.saver = saver;
        boolean failOnIndexCheck = props.getProperty("check-precomp-sea", true);
        this.precompSea = props.getProperty("precomp-sea", null);
        this.improveOverview = props.getProperty("improve-overview", false);
        if (this.precompSea != null) {
            Map<String, Boolean> map = checkedPrecomp;
            synchronized (map) {
                SeaGenerator.initPrecompSeaIndex(this.precompSea, failOnIndexCheck);
            }
        }
        if ((gs = props.getProperty("generate-sea", null)) != null) {
            this.parseGenerateSeaOption(gs, this.precompSea != null);
            if (this.precompSea == null) {
                String coastlineFileOpt;
                if (this.floodblocker) {
                    this.loadFloodblockerStyle();
                }
                if ((coastlineFileOpt = props.getProperty("coastlinefile", null)) != null) {
                    this.coastlineFilenames = coastlineFileOpt.split(",");
                    CoastlineFileLoader.getCoastlineLoader().setCoastlineFiles(this.coastlineFilenames);
                    CoastlineFileLoader.getCoastlineLoader().loadCoastlines();
                    log.info((Object)"Coastlines loaded");
                } else {
                    this.coastlineFilenames = null;
                }
            }
        }
        return gs != null || this.precompSea != null;
    }

    public static void checkIndexAgainstRef(String absolutePath) {
        if (precompIndex.get() != null) {
            precompIndex.remove();
        }
        SeaGenerator.initPrecompSeaIndex(absolutePath, true);
        if (precompIndex.get() != null) {
            precompIndex.remove();
        }
    }

    private void loadFloodblockerStyle() {
        try {
            this.fbRules = new StyleImpl(null, "floodblocker");
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Cannot load file floodblocker rules. Continue floodblocking disabled.");
            this.floodblocker = false;
        }
    }

    private void parseGenerateSeaOption(String gs, boolean forPrecompSea) {
        for (String option : gs.split(",")) {
            if ("no-mp".equals(option) || "polygon".equals(option) || "polygons".equals(option)) {
                this.generateSeaUsingMP = false;
                continue;
            }
            if ("multipolygon".equals(option)) {
                this.generateSeaUsingMP = true;
                continue;
            }
            if (option.startsWith("land-tag=")) {
                this.landTag = option.substring(9).split("=");
                continue;
            }
            if (!forPrecompSea) {
                if (option.startsWith("close-gaps=")) {
                    this.maxCoastlineGap = (int)Double.parseDouble(option.substring(11));
                    continue;
                }
                if ("no-sea-sectors".equals(option)) {
                    this.allowSeaSectors = false;
                    continue;
                }
                if ("extend-sea-sectors".equals(option)) {
                    this.allowSeaSectors = false;
                    this.extendSeaSectors = true;
                    continue;
                }
                if ("floodblocker".equals(option)) {
                    this.floodblocker = true;
                    continue;
                }
                if (option.startsWith("fbgap=")) {
                    this.fbGap = (int)Double.parseDouble(option.substring("fbgap=".length()));
                    continue;
                }
                if (option.startsWith("fbratio=")) {
                    this.fbRatio = Double.parseDouble(option.substring("fbratio=".length()));
                    continue;
                }
                if (option.startsWith("fbthres=")) {
                    this.fbThreshold = (int)Double.parseDouble(option.substring("fbthres=".length()));
                    continue;
                }
                if ("fbdebug".equals(option)) {
                    this.fbDebug = true;
                    continue;
                }
                if ("check".equals(option)) {
                    this.checkCoastline = true;
                    continue;
                }
                SeaGenerator.printOptionHelpMsg(forPrecompSea, option);
                continue;
            }
            if (option.isEmpty()) continue;
            SeaGenerator.printOptionHelpMsg(forPrecompSea, option);
        }
    }

    private static void initPrecompSeaIndex(String precompSea, boolean failOnIndexCheck) {
        block18: {
            if (precompIndex.get() != null) {
                return;
            }
            File precompSeaDir = new File(precompSea);
            if (!precompSeaDir.exists()) {
                log.error((Object)("Directory or zip file with precompiled sea does not exist: " + precompSea));
                return;
            }
            String internalPath = null;
            String indexFileName = "index.txt.gz";
            ZipFile zipFile = null;
            PrecompData precompData = null;
            try {
                if (precompSeaDir.isDirectory()) {
                    File indexFile = new File(precompSeaDir, indexFileName);
                    if (!indexFile.exists()) {
                        indexFileName = "index.txt";
                        indexFile = new File(precompSeaDir, indexFileName);
                    }
                    if (indexFile.exists()) {
                        precompData = SeaGenerator.readIndexStream(indexFileName, new FileInputStream(indexFile));
                    }
                } else if (precompSea.endsWith(".zip")) {
                    zipFile = new ZipFile(precompSeaDir);
                    internalPath = "sea/";
                    ZipEntry entry = zipFile.getEntry(internalPath + indexFileName);
                    if (entry == null) {
                        indexFileName = "index.txt";
                        entry = zipFile.getEntry(internalPath + indexFileName);
                    }
                    if (entry == null) {
                        internalPath = "";
                        indexFileName = "index.txt.gz";
                        entry = zipFile.getEntry(internalPath + indexFileName);
                    }
                    if (entry != null) {
                        precompData = SeaGenerator.readIndexStream(indexFileName, zipFile.getInputStream(entry));
                    } else {
                        log.error((Object)("Don't know how to read " + precompSeaDir));
                    }
                } else {
                    log.error((Object)("Don't know how to read " + precompSeaDir));
                }
                if (precompData == null) break block18;
                if (!checkedPrecomp.containsKey(precompSea)) {
                    checkedPrecomp.put(precompSea, Boolean.TRUE);
                    try {
                        SeaGenerator.checkIndex(precompData, failOnIndexCheck);
                    }
                    catch (IOException e) {
                        Logger.defaultLogger.error((Object)("Internal error: Cannot check index file " + indexFileName + " in " + precompSea + ". Resource sea-check.txt is probably wrong."));
                    }
                }
                precompData.dirFile = precompSeaDir;
                if (zipFile != null) {
                    precompData.precompZipFileInternalPath = internalPath;
                    precompData.zipFile = zipFile;
                }
                precompIndex.set(precompData);
            }
            catch (IOException exp) {
                log.error("Cannot read index file", indexFileName, "in", precompSea, exp);
                throw new ExitException("Failed to read required index file in " + precompSeaDir);
            }
        }
    }

    private static PrecompData readIndexStream(String indexFileName, InputStream indexStream) throws IOException {
        if (indexFileName.endsWith(".gz")) {
            indexStream = new GZIPInputStream(indexStream);
        }
        PrecompData precompData = SeaGenerator.loadIndex(indexStream);
        indexStream.close();
        return precompData;
    }

    private static void printOptionHelpMsg(boolean forPrecompSea, String option) {
        if (!"help".equals(option)) {
            System.err.println("Unknown sea generation option '" + option + "'");
        }
        System.err.println("Known sea generation options " + (forPrecompSea ? "with" : "without") + " --precomp-sea  are:");
        System.err.println("  multipolygon        use a multipolygon (default)");
        System.err.println("  polygons | no-mp    use polygons rather than a multipolygon");
        System.err.println("  land-tag=TAG=VAL    tag to use for land polygons (default natural=land)");
        if (forPrecompSea) {
            return;
        }
        System.err.println("  no-sea-sectors      disable use of \"sea sectors\"");
        System.err.println("  extend-sea-sectors  extend coastline to reach border");
        System.err.println("  close-gaps=NUM      close gaps in coastline that are less than this distance (metres)");
        System.err.println("  floodblocker        enable the floodblocker (for multipolgon only)");
        System.err.println("  fbgap=NUM           points closer to the coastline are ignored for flood blocking (default 40)");
        System.err.println("  fbthres=NUM         min points contained in a polygon to be flood blocked (default 20)");
        System.err.println("  fbratio=NUM         min ratio (points/area size) for flood blocking (default 0.5)");
        System.err.println("  check               check for sea polygons within sea and land within land");
    }

    private static PrecompData loadIndex(InputStream fileStream) throws IOException {
        PrecompData pi = null;
        LineNumberReader indexReader = new LineNumberReader(new InputStreamReader(fileStream));
        String indexLine = null;
        byte[][] indexGrid = new byte[INDEX_WIDTH + 1][INDEX_HEIGHT + 1];
        boolean detectExt = true;
        String prefix = null;
        String ext = null;
        while ((indexLine = indexReader.readLine()) != null) {
            int prePos;
            if (indexLine.startsWith("#")) continue;
            String[] items = SEMICOLON_SPLITTER.split(indexLine);
            if (items.length != 2) {
                log.warn("Invalid format in index file name:", indexLine);
                continue;
            }
            String precompKey = items[0];
            byte type = SeaGenerator.updatePrecompSeaTileIndex(precompKey, items[1], indexGrid);
            if (type == 63) {
                log.warn("Invalid format in index file name:", indexLine);
                continue;
            }
            if (type != 109 || (prePos = items[1].indexOf(items[0])) < 0) continue;
            if (detectExt) {
                prefix = items[1].substring(0, prePos);
                ext = items[1].substring(prePos + items[0].length());
                detectExt = false;
                continue;
            }
            String fname = prefix + precompKey + ext;
            if (items[1].equals(fname)) continue;
            log.warn("Unexpected file name in index file:", indexLine);
        }
        pi = new PrecompData();
        PrecompData.access$402(pi, indexGrid);
        pi.precompSeaPrefix = prefix;
        pi.precompSeaExt = ext;
        return pi;
    }

    private static void checkIndex(PrecompData pi, boolean failOnIndexCheck) throws IOException {
        boolean hasError = false;
        try (BufferedInputStream is = new BufferedInputStream(SeaGenerator.class.getResourceAsStream("/sea-check.txt"));){
            for (int h = 1; h <= INDEX_HEIGHT; ++h) {
                for (int w = INDEX_WIDTH; w >= 1; --w) {
                    int ref = is.read();
                    if (ref == -1) {
                        throw new IOException("Failed to read sea-check.txt, mayby file is truncated?");
                    }
                    String err = null;
                    if (ref == 108 && pi.precompIndex[w][h] == 115) {
                        err = "land-only tile is flooded";
                    } else if (ref == 115 && pi.precompIndex[w][h] == 108) {
                        err = "sea-only tile is now land";
                    }
                    if (err == null) continue;
                    hasError = true;
                    int minLat = -1 * (32768 * h - MAX_LAT);
                    int minLon = -1 * (32768 * w - MAX_LON);
                    Coord c = new Coord(minLat + 16384, minLon + 16384);
                    log.error((Object)("Precomp sea data seems to be wrong, " + err + " around " + c + ", index key is " + minLat + "_" + minLon));
                }
                is.read();
            }
        }
        if (hasError && failOnIndexCheck) {
            throw new ExitException("Precomp sea data seems to be wrong. Use option --x-check-precomp-sea=0 to continue risking bad sea data.");
        }
    }

    public static int getPrecompTileStart(int value) {
        int rem = value % 32768;
        if (rem == 0) {
            return value;
        }
        if (value >= 0) {
            return value - rem;
        }
        return value - 32768 - rem;
    }

    public static int getPrecompTileEnd(int value) {
        int rem = value % 32768;
        if (rem == 0) {
            return value;
        }
        if (value >= 0) {
            return value + 32768 - rem;
        }
        return value - rem;
    }

    @Override
    public Set<String> getUsedTags() {
        HashSet<String> usedTags = new HashSet<String>();
        if (this.coastlineFilenames == null) {
            usedTags.add("natural");
        }
        if (this.floodblocker) {
            usedTags.addAll(this.fbRules.getUsedTags());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sea generator used tags: " + usedTags));
        }
        return usedTags;
    }

    @Override
    public void onAddWay(Way way) {
        String natural = way.getTag(TK_NATURAL);
        if (natural == null) {
            return;
        }
        int posn = natural.indexOf("coastline");
        if (posn < 0) {
            return;
        }
        if (posn > 0 && natural.charAt(posn - 1) != ';') {
            return;
        }
        if (natural.length() > posn + 9 && natural.charAt(posn + 9) != ';') {
            return;
        }
        if (this.precompSea != null) {
            this.splitCoastLineToLineAndShape(way, natural);
        } else if (this.coastlineFilenames == null) {
            Way shore = new Way(way.getOriginalId(), way.getPoints());
            shore.markAsGeneratedFrom(way);
            this.shoreline.add(way);
        }
    }

    private void splitCoastLineToLineAndShape(Way way, String naturalVal) {
        if (way.hasIdenticalEndPoints()) {
            Way shapeWay = new Way(way.getOriginalId(), way.getPoints());
            shapeWay.markAsGeneratedFrom(way);
            shapeWay.copyTags(way);
            shapeWay.deleteTag(TK_NATURAL);
            shapeWay.addTag("mkgmap:removed_natural", naturalVal);
            shapeWay.addTag("mkgmap:stylefilter", "polygon");
            this.saver.addWay(shapeWay);
        }
        way.addTag("mkgmap:stylefilter", "polyline");
    }

    private static Collection<Way> loadPrecompTile(InputStream is, String filename) {
        OsmPrecompSeaDataSource src = new OsmPrecompSeaDataSource();
        EnhancedProperties props = new EnhancedProperties();
        props.setProperty("style", "empty");
        src.config(props);
        log.info("Started loading coastlines from", filename);
        try {
            src.parse(is, filename);
        }
        catch (FormatException e) {
            log.error((Object)("Failed to read " + filename));
            log.error((Object)e);
        }
        log.info("Finished loading coastlines from", filename);
        return src.getElementSaver().getWays().values();
    }

    private List<String> getPrecompKeyNames() {
        Area bounds = this.saver.getBoundingBox();
        ArrayList<String> precompKeys = new ArrayList<String>();
        for (int lat = SeaGenerator.getPrecompTileStart(bounds.getMinLat()); lat < SeaGenerator.getPrecompTileEnd(bounds.getMaxLat()); lat += 32768) {
            for (int lon = SeaGenerator.getPrecompTileStart(bounds.getMinLong()); lon < SeaGenerator.getPrecompTileEnd(bounds.getMaxLong()); lon += 32768) {
                precompKeys.add(lat + "_" + lon);
            }
        }
        return precompKeys;
    }

    private static String getTileName(String precompKey) {
        PrecompData pi = precompIndex.get();
        String[] tileCoords = KEY_SPLITTER.split(precompKey);
        int lat = Integer.parseInt(tileCoords[0]);
        int lon = Integer.parseInt(tileCoords[1]);
        int latIndex = (MAX_LAT - lat) / 32768;
        int lonIndex = (MAX_LON - lon) / 32768;
        byte type = pi.precompIndex[lonIndex][latIndex];
        switch (type) {
            case 115: {
                return "sea";
            }
            case 108: {
                return "land";
            }
            case 109: {
                return pi.precompSeaPrefix + precompKey + pi.precompSeaExt;
            }
        }
        return null;
    }

    private static byte updatePrecompSeaTileIndex(String precompKey, String fileName, byte[][] indexGrid) {
        String[] tileCoords = KEY_SPLITTER.split(precompKey);
        int type = 63;
        if (tileCoords.length == 2) {
            int lat = Integer.parseInt(tileCoords[0]);
            int lon = Integer.parseInt(tileCoords[1]);
            int latIndex = (MAX_LAT - lat) / 32768;
            int lonIndex = (MAX_LON - lon) / 32768;
            type = "sea".equals(fileName) ? 115 : ("land".equals(fileName) ? 108 : 109);
            indexGrid[lonIndex][latIndex] = type;
        }
        return (byte)type;
    }

    private void addPrecompSea() {
        log.info((Object)"Load precompiled sea tiles");
        ArrayList<Way> landWays = new ArrayList<Way>();
        ArrayList<Way> seaWays = new ArrayList<Way>();
        boolean distinctTilesOnly = this.loadLandAndSea(landWays, seaWays);
        if (this.generateSeaUsingMP || distinctTilesOnly) {
            for (Way w : seaWays) {
                w.setFullArea(0x7FFFFFFFFFFFFFFDL);
                this.saver.addWay(w);
            }
        } else {
            this.saver.addWay(this.createSeaWay(false));
        }
        boolean changeLandTag = this.landTag != null && "natural".equals(this.landTag[0]) && !"land".equals(this.landTag[1]);
        for (Way w : landWays) {
            if (changeLandTag) {
                w.deleteTag(TK_NATURAL);
                w.addTag(this.landTag[0], this.landTag[1]);
            }
            this.saver.addWay(w);
        }
    }

    private boolean loadLandAndSea(List<Way> landWays, List<Way> seaWays) {
        boolean distinctTilesOnly = true;
        List<java.awt.geom.Area> seaOnlyAreas = new ArrayList<java.awt.geom.Area>();
        List<java.awt.geom.Area> landOnlyAreas = new ArrayList<java.awt.geom.Area>();
        PrecompData pd = precompIndex.get();
        Long2ObjectOpenHashMap<Coord> commonCoordMap = new Long2ObjectOpenHashMap<Coord>();
        for (String precompKey : this.getPrecompKeyNames()) {
            String tileName = SeaGenerator.getTileName(precompKey);
            if (tileName == null) {
                log.error((Object)("Precompile sea tile " + precompKey + " is missing in the index. Skipping."));
                continue;
            }
            if ("sea".equals(tileName) || "land".equals(tileName)) {
                String[] tileCoords = KEY_SPLITTER.split(precompKey);
                int minLat = Integer.parseInt(tileCoords[0]);
                int minLon = Integer.parseInt(tileCoords[1]);
                Rectangle r = new Rectangle(minLon, minLat, 32768, 32768);
                if ("sea".equals(tileName)) {
                    seaOnlyAreas = SeaGenerator.addWithoutCreatingHoles(seaOnlyAreas, new java.awt.geom.Area(r));
                    continue;
                }
                landOnlyAreas = SeaGenerator.addWithoutCreatingHoles(landOnlyAreas, new java.awt.geom.Area(r));
                continue;
            }
            distinctTilesOnly = false;
            SeaGenerator.loadMixedTile(pd, tileName, landWays, seaWays, commonCoordMap);
        }
        landWays.addAll(SeaGenerator.areaToWays(landOnlyAreas, "land", commonCoordMap));
        seaWays.addAll(SeaGenerator.areaToWays(seaOnlyAreas, "sea", commonCoordMap));
        if (this.improveOverview) {
            SeaGenerator.createSeaMP(landWays, seaWays, this.tileBounds, commonCoordMap);
        }
        return distinctTilesOnly;
    }

    private static void createSeaMP(List<Way> landWays, List<Way> seaWays, Area tileBounds, Long2ObjectOpenHashMap<Coord> commonCoordMap) {
        if (landWays.isEmpty() || seaWays.isEmpty()) {
            return;
        }
        log.info("improve-overview: re-creating multipolygon from", landWays.size(), "land areas");
        LinkedHashMap<Long, Way> wayMap = new LinkedHashMap<Long, Way>();
        final Way seaWay = new Way(FakeIdGenerator.makeFakeId(), Area.PLANET.toCoords());
        wayMap.put(seaWay.getId(), seaWay);
        landWays.forEach(w -> w.getPoints().forEach(Coord::resetHighwayCount));
        landWays.forEach(w -> w.getPoints().forEach(Coord::incHighwayCount));
        landWays.forEach(w -> w.getPoints().get(0).decHighwayCount());
        ArrayList<MapShape> landShapesToMerge = new ArrayList<MapShape>();
        for (int i = 0; i < landWays.size(); ++i) {
            Way w2 = landWays.get(i);
            if (w2.getPoints().stream().anyMatch(c -> c.getHighwayCount() > 1)) {
                MapShape ms = new MapShape(w2.getId());
                ms.setType(1);
                ms.setPoints(w2.getPoints());
                landShapesToMerge.add(ms);
                continue;
            }
            wayMap.put(w2.getId(), w2);
        }
        ShapeMergeFilter mergeFilter = new ShapeMergeFilter(-1, false);
        List<MapShape> merged = mergeFilter.merge(landShapesToMerge);
        for (MapShape mapShape : merged) {
            mapShape.getPoints().forEach(Coord::resetHighwayCount);
            mapShape.getPoints().forEach(Coord::incHighwayCount);
            mapShape.getPoints().get(0).decHighwayCount();
            int n = mapShape.getPoints().size();
            boolean isSimple = true;
            for (int i = 0; i < n; ++i) {
                int count = mapShape.getPoints().get(i).getHighwayCount();
                if (count <= 2 && (count <= 1 || i == 0 || i == n - 1)) continue;
                isSimple = false;
            }
            if (isSimple) {
                Way w3 = new Way(FakeIdGenerator.makeFakeId(), mapShape.getPoints());
                wayMap.put(w3.getId(), w3);
                continue;
            }
            Path2D path = Java2DConverter.createPath2D(mapShape.getPoints());
            path.setWindingRule(0);
            List<List<Coord>> shapes = Java2DConverter.areaToShapes(new java.awt.geom.Area(path), commonCoordMap);
            for (List<Coord> points : shapes) {
                if (!Way.clockwise(points)) continue;
                Way w4 = new Way(FakeIdGenerator.makeFakeId(), points);
                wayMap.put(w4.getId(), w4);
            }
        }
        GeneralRelation gr = new GeneralRelation(FakeIdGenerator.makeFakeId());
        for (Way w5 : wayMap.values()) {
            w5.setClosedInOSM(true);
            gr.addElement(w5 == seaWay ? "outer" : "inner", w5);
        }
        MultiPolygonRelation multiPolygonRelation = new MultiPolygonRelation(gr, wayMap, tileBounds){

            @Override
            public Way getLargestOuterRing() {
                if (this.largestOuterPolygon == null) {
                    for (MultiPolygonRelation.JoinedWay w : this.getRings()) {
                        if (!w.getOriginalWays().contains(seaWay)) continue;
                        this.largestOuterPolygon = w;
                        break;
                    }
                }
                return this.largestOuterPolygon;
            }
        };
        seaWays.forEach(w -> w.setMpRel(mpr));
    }

    private static void loadMixedTile(PrecompData pd, String tileName, List<Way> landWays, List<Way> seaWays, Long2ObjectOpenHashMap<Coord> commonCoordMap) {
        try {
            InputStream is = null;
            if (pd.zipFile != null) {
                ZipEntry entry = pd.zipFile.getEntry(pd.precompZipFileInternalPath + tileName);
                if (entry != null) {
                    is = pd.zipFile.getInputStream(entry);
                } else {
                    log.error((Object)("Precompiled sea tile " + tileName + " not found."));
                }
            } else {
                File precompTile = new File(pd.dirFile, tileName);
                is = new FileInputStream(precompTile);
            }
            if (is != null) {
                Collection<Way> seaPrecompWays = SeaGenerator.loadPrecompTile(is, tileName);
                if (log.isDebugEnabled()) {
                    log.debug(seaPrecompWays.size(), "precomp sea ways from", tileName, "loaded.");
                }
                for (Way w : seaPrecompWays) {
                    int n = w.getPoints().size();
                    for (int i = 0; i < n; ++i) {
                        Coord p = w.getPoints().get(i);
                        if (p.getLatitude() % 32768 != 0 && p.getLongitude() % 32768 != 0) continue;
                        long key = Utils.coord2Long(p);
                        Coord replacement = commonCoordMap.get(key);
                        if (replacement == null) {
                            commonCoordMap.put(key, p);
                            continue;
                        }
                        assert (p.highPrecEquals(replacement));
                        w.getPoints().set(i, replacement);
                    }
                    w.markAsGeneratedFrom(w);
                    if ("land".equals(w.getTag(TK_NATURAL))) {
                        landWays.add(w);
                        continue;
                    }
                    seaWays.add(w);
                }
            }
        }
        catch (FileNotFoundException exp) {
            log.error((Object)("Preompiled sea tile " + tileName + " not found."));
        }
        catch (Exception exp) {
            log.error((Object)("Unexpected error reading " + tileName), exp);
        }
    }

    private static List<java.awt.geom.Area> addWithoutCreatingHoles(List<java.awt.geom.Area> areas, java.awt.geom.Area toAdd) {
        LinkedList<java.awt.geom.Area> result = new LinkedList<java.awt.geom.Area>();
        java.awt.geom.Area toMerge = new java.awt.geom.Area(toAdd);
        for (java.awt.geom.Area area : areas) {
            java.awt.geom.Area mergedArea = new java.awt.geom.Area(area);
            mergedArea.add(toMerge);
            if (!mergedArea.isSingular()) {
                result.add(area);
                continue;
            }
            toMerge = mergedArea;
        }
        int dimNew = Math.max(toMerge.getBounds().width, toMerge.getBounds().height);
        boolean added = false;
        for (int i = 0; i < result.size(); ++i) {
            java.awt.geom.Area area = (java.awt.geom.Area)result.get(i);
            if (dimNew >= Math.max(area.getBounds().width, area.getBounds().height)) continue;
            result.add(i, toMerge);
            added = true;
            break;
        }
        if (!added) {
            result.add(toMerge);
        }
        return result;
    }

    private static List<Way> areaToWays(List<java.awt.geom.Area> areas, String type, Long2ObjectOpenHashMap<Coord> commonCoordMap) {
        ArrayList<Way> ways = new ArrayList<Way>();
        for (java.awt.geom.Area area : areas) {
            List<List<Coord>> shapes = Java2DConverter.areaToShapes(area, commonCoordMap);
            for (List<Coord> points : shapes) {
                Way w = new Way(FakeIdGenerator.makeFakeId(), points);
                w.addTag(TK_NATURAL, type);
                ways.add(w);
            }
        }
        return ways;
    }

    public static List<Way> joinWays(Collection<Way> segments) {
        boolean merged;
        ArrayList<Way> joined = new ArrayList<Way>((int)Math.ceil((double)segments.size() * 0.5));
        IdentityHashMap<Coord, Way> beginMap = new IdentityHashMap<Coord, Way>();
        for (Way w : segments) {
            if (w.hasIdenticalEndPoints()) {
                joined.add(w);
                continue;
            }
            if (w.getPoints().size() > 1) {
                beginMap.put(w.getFirstPoint(), w);
                continue;
            }
            log.info("Discarding coastline", w.getBasicLogInformation(), "because it consists of less than 2 points");
        }
        segments.clear();
        block1: do {
            merged = false;
            for (Way w1 : beginMap.values()) {
                Way w2 = (Way)beginMap.get(w1.getLastPoint());
                if (w2 == null) continue;
                SeaGenerator.merge(beginMap, joined, w1, w2);
                merged = true;
                continue block1;
            }
        } while (merged);
        log.info(joined.size(), "closed ways.", beginMap.size(), "unclosed ways.");
        joined.addAll(beginMap.values());
        return joined;
    }

    private static void merge(Map<Coord, Way> beginMap, List<Way> joined, Way w1, Way w2) {
        Way wm;
        log.info("merging:", beginMap.size(), w1.getBasicLogInformation(), "with", w2.getBasicLogInformation());
        if (FakeIdGenerator.isFakeId(w1.getId())) {
            wm = w1;
        } else {
            wm = new Way(w1.getOriginalId(), w1.getPoints());
            wm.markAsGeneratedFrom(w1);
            beginMap.put(wm.getFirstPoint(), wm);
        }
        beginMap.remove(w2.getFirstPoint());
        wm.getPoints().addAll(w2.getPoints().subList(1, w2.getPoints().size()));
        if (wm.hasIdenticalEndPoints()) {
            joined.add(wm);
            beginMap.remove(wm.getFirstPoint());
        }
    }

    @Override
    public void end() {
        this.tileBounds = this.saver.getBoundingBox();
        if (this.precompSea != null && precompIndex.get() != null) {
            this.addPrecompSea();
            return;
        }
        if (this.coastlineFilenames == null) {
            log.info("Shorelines before join", this.shoreline.size());
            this.shoreline = SeaGenerator.joinWays(this.shoreline);
        } else {
            this.shoreline.addAll(CoastlineFileLoader.getCoastlineLoader().getCoastlines(this.tileBounds));
            log.info("Shorelines from extra file:", this.shoreline.size());
        }
        if (log.isInfoEnabled()) {
            long closed = this.shoreline.stream().filter(Way::hasIdenticalEndPoints).count();
            log.info("Closed shorelines", closed);
            log.info("Unclosed shorelines", (long)this.shoreline.size() - closed);
        }
        this.clipShorelineSegments();
        if (this.shoreline.isEmpty()) {
            this.saver.addWay(this.createLandWay());
            return;
        }
        this.handleIslands();
        if (this.maxCoastlineGap > 0 && this.closeGaps()) {
            this.handleIslands();
        }
        if (this.islands.isEmpty()) {
            this.generateSeaBackground = false;
        }
        NavigableMap<Double, Way> hitMap = this.findIntersectionPoints();
        this.verifyHits(hitMap);
        TreeMap<Double, Way> copyHitMap = new TreeMap<Double, Way>((SortedMap<Double, Way>)hitMap);
        List<Way> seaAreas = this.createSeaPolygons(hitMap);
        List<Way> landAreas = this.createLandPolygons(copyHitMap);
        GeneralRelation seaRelation = null;
        if (this.generateSeaUsingMP && this.generateSeaBackground) {
            long multiId = FakeIdGenerator.makeFakeId();
            log.debug("Generate seabounds relation", multiId);
            seaRelation = new GeneralRelation(multiId);
            seaRelation.addTag("type", "multipolygon");
            seaRelation.addTag(TK_NATURAL, "sea");
        }
        this.processSeaAreas(seaAreas, seaRelation);
        this.processLandAreas(landAreas, null);
        this.processSeaAreas(this.antiIslands, seaRelation);
        this.processLandAreas(this.islands, seaRelation);
        if (this.checkCoastline) {
            this.islands.addAll(landAreas);
            this.antiIslands.addAll(seaAreas);
            this.checkIslands(this.generateSeaBackground);
        }
        if (seaRelation != null) {
            SeaPolygonRelation coastRel = this.saver.createSeaPolyRelation(seaRelation);
            coastRel.setFloodBlocker(this.floodblocker);
            if (this.floodblocker) {
                coastRel.setFloodBlockerGap(this.fbGap);
                coastRel.setFloodBlockerRatio(this.fbRatio);
                coastRel.setFloodBlockerThreshold(this.fbThreshold);
                coastRel.setFloodBlockerRules(this.fbRules.getWayRules());
                coastRel.setLandTag(this.landTag[0], this.landTag[1]);
                coastRel.setDebug(this.fbDebug);
            }
            this.saver.addRelation(coastRel);
        }
        this.shoreline = null;
        this.islands = null;
        this.antiIslands = null;
    }

    private void processLandAreas(List<Way> areas, Relation seaRelation) {
        for (Way w : areas) {
            w.addTag(this.landTag[0], this.landTag[1]);
            if (seaRelation != null) {
                seaRelation.addElement("inner", w);
            }
            this.saver.addWay(w);
        }
    }

    private void processSeaAreas(List<Way> areas, Relation seaRelation) {
        for (Way w : areas) {
            w.setFullArea(0x7FFFFFFFFFFFFFFDL);
            if (seaRelation != null) {
                seaRelation.addElement("outer", w);
                continue;
            }
            w.addTag(TK_NATURAL, "sea");
            this.saver.addWay(w);
        }
    }

    private void checkIslands(boolean seaBased) {
        Way containingSea;
        Way containingLand;
        for (Way ai : this.antiIslands) {
            containingLand = null;
            containingSea = null;
            for (Way i : this.islands) {
                if (!i.containsPointsOf(ai) || containingLand != null && !containingLand.containsPointsOf(i)) continue;
                containingLand = i;
            }
            for (Way ai2 : this.antiIslands) {
                if (ai2 == ai || !ai2.containsPointsOf(ai) || containingSea != null && !containingSea.containsPointsOf(ai2)) continue;
                containingSea = ai2;
            }
            if (containingSea != null && containingLand != null) {
                if (containingSea.containsPointsOf(containingLand)) {
                    containingSea = null;
                } else if (containingLand.containsPointsOf(containingSea)) {
                    containingLand = null;
                } else {
                    log.warn("inner sea", ai, "is surrounded by both water", containingSea, "and land", containingLand);
                    containingSea = null;
                    containingLand = null;
                }
            }
            if (containingLand != null || !seaBased && containingSea == null) continue;
            log.error("inner sea", ai, "is surrounded by water", containingSea == null ? "" : containingSea);
        }
        for (Way i : this.islands) {
            containingLand = null;
            containingSea = null;
            for (Way ai : this.antiIslands) {
                if (!ai.containsPointsOf(i) || containingSea != null && !containingSea.containsPointsOf(ai)) continue;
                containingSea = ai;
            }
            for (Way i2 : this.islands) {
                if (i2 == i || !i2.containsPointsOf(i) || containingLand != null && !containingLand.containsPointsOf(i2)) continue;
                containingLand = i2;
            }
            if (containingSea != null && containingLand != null) {
                if (containingSea.containsPointsOf(containingLand)) {
                    containingSea = null;
                } else if (containingLand.containsPointsOf(containingSea)) {
                    containingLand = null;
                } else {
                    log.warn("island", i, "is surrounded by both water", containingSea, "and land", containingLand);
                    containingSea = null;
                    containingLand = null;
                }
            }
            if (containingSea != null || containingLand == null) continue;
            log.error("island", i, "is surrounded by land", containingLand);
        }
    }

    private Way createLandWay() {
        long landId = FakeIdGenerator.makeFakeId();
        Way land = new Way(landId, this.tileBounds.toCoords());
        land.addTag(this.landTag[0], this.landTag[1]);
        return land;
    }

    private Way createSeaWay(boolean enlarge) {
        log.info("generating sea, seaBounds=", this.tileBounds);
        Area bbox = this.tileBounds;
        long seaId = FakeIdGenerator.makeFakeId();
        if (enlarge) {
            bbox = new Area(bbox.getMinLat() - 1, bbox.getMinLong() - 1, bbox.getMaxLat() + 1, bbox.getMaxLong() + 1);
        }
        Way sea = new Way(seaId, bbox.toCoords());
        sea.reverse();
        sea.addTag(TK_NATURAL, "sea");
        sea.setFullArea(0x7FFFFFFFFFFFFFFDL);
        return sea;
    }

    private void clipShorelineSegments() {
        ArrayList<Way> toBeRemoved = new ArrayList<Way>();
        ArrayList<Way> toBeAdded = new ArrayList<Way>();
        for (Way segment : this.shoreline) {
            List<Coord> points = segment.getPoints();
            List<List<Coord>> clipped = LineClipper.clip(this.tileBounds, points);
            if (clipped == null) continue;
            log.info("clipping", segment);
            toBeRemoved.add(segment);
            for (List<Coord> pts : clipped) {
                Way shore = new Way(segment.getOriginalId(), pts);
                shore.markAsGeneratedFrom(segment);
                toBeAdded.add(shore);
            }
        }
        log.info("clipping: adding", toBeAdded.size(), ", removing", toBeRemoved.size());
        this.shoreline.removeAll(toBeRemoved);
        this.shoreline.addAll(toBeAdded);
    }

    private void handleIslands() {
        Iterator<Way> it = this.shoreline.iterator();
        while (it.hasNext()) {
            Way w = it.next();
            if (!w.hasIdenticalEndPoints()) continue;
            if (Way.clockwise(w.getPoints())) {
                this.antiIslands.add(w);
            } else {
                this.islands.add(w);
            }
            it.remove();
        }
    }

    private boolean closeGaps() {
        boolean changed;
        boolean someClosed = false;
        do {
            changed = false;
            Iterator<Way> iter = this.shoreline.iterator();
            while (!changed && iter.hasNext()) {
                Way closed;
                Coord w1e;
                Way w1 = iter.next();
                if (w1.hasIdenticalEndPoints() || this.tileBounds.onBoundary(w1e = w1.getLastPoint()) || (closed = this.tryCloseGap(w1)) == null) continue;
                this.saver.addWay(closed);
                changed = true;
                someClosed = true;
            }
        } while (changed);
        return someClosed;
    }

    private Way tryCloseGap(Way w1) {
        Coord w1e = w1.getLastPoint();
        Way nearest = null;
        double smallestGap = Double.MAX_VALUE;
        for (Way w2 : this.shoreline) {
            double gap;
            Coord w2s;
            if (w1 == w2 || w2.hasIdenticalEndPoints() || this.tileBounds.onBoundary(w2s = w2.getFirstPoint()) || !((gap = w1e.distance(w2s)) < smallestGap)) continue;
            nearest = w2;
            smallestGap = gap;
        }
        if (nearest != null && smallestGap < (double)this.maxCoastlineGap) {
            Way wm;
            Coord w2s = nearest.getFirstPoint();
            log.warn((Object)("Bridging " + (int)smallestGap + "m gap in coastline from " + w1e.toOSMURL() + " to " + w2s.toOSMURL()));
            if (FakeIdGenerator.isFakeId(w1.getId())) {
                wm = w1;
            } else {
                wm = new Way(w1.getOriginalId());
                wm.markAsGeneratedFrom(w1);
                this.shoreline.remove(w1);
                this.shoreline.add(wm);
                wm.getPoints().addAll(w1.getPoints());
                wm.copyTags(w1);
            }
            wm.getPoints().addAll(nearest.getPoints());
            this.shoreline.remove(nearest);
            Way w = new Way(FakeIdGenerator.makeFakeId());
            w.addTag(TK_NATURAL, "mkgmap:coastline-gap");
            w.addPoint(w1e);
            w.addPoint(w2s);
            return w;
        }
        return null;
    }

    private List<Way> createLandPolygons(NavigableMap<Double, Way> hitMap) {
        NavigableSet<Double> hits = hitMap.navigableKeySet();
        ArrayList<Way> areas = new ArrayList<Way>();
        while (!hits.isEmpty()) {
            Double hFirst;
            Double hStart = hFirst = (Double)hits.first();
            Way w = new Way(((Way)hitMap.get(hFirst)).getOriginalId());
            w.markAsGeneratedFrom((Element)hitMap.get(hFirst));
            boolean finished = false;
            do {
                Way segment = (Way)hitMap.get(hStart);
                log.info("current hit:", hStart, "adding:", segment);
                segment.getPoints().forEach(w::addPointIfNotEqualToLastPoint);
                hits.remove(hStart);
                Double hEnd = SeaGenerator.getEdgeHit(this.tileBounds, segment.getLastPoint());
                if (hEnd < hStart) {
                    finished = true;
                } else {
                    hStart = hits.higher(hEnd);
                    if (hStart == null) {
                        hFirst = hFirst + 4.0;
                        finished = true;
                    }
                }
                if (finished) {
                    hStart = hFirst;
                }
                this.addCorners(w, hEnd, hStart);
            } while (!finished);
            w.addPoint(w.getFirstPoint());
            log.info("adding landPoly, hits.size()", hits.size());
            areas.add(w);
        }
        return areas;
    }

    private List<Way> createSeaPolygons(NavigableMap<Double, Way> hitMap) {
        NavigableSet<Double> hits = hitMap.navigableKeySet();
        ArrayList<Way> areas = new ArrayList<Way>();
        while (!hits.isEmpty()) {
            Double hFirst;
            Double hStart = hFirst = (Double)hits.last();
            Way w = new Way(((Way)hitMap.get(hFirst)).getOriginalId());
            w.markAsGeneratedFrom((Element)hitMap.get(hFirst));
            boolean finished = false;
            do {
                Way segment = (Way)hitMap.get(hStart);
                log.info("current hit:", hStart, "adding:", segment);
                segment.getPoints().forEach(w::addPointIfNotEqualToLastPoint);
                hits.remove(hStart);
                Double hEnd = SeaGenerator.getEdgeHit(this.tileBounds, segment.getLastPoint());
                if (hEnd > hStart) {
                    finished = true;
                } else {
                    hStart = hits.lower(hEnd);
                    if (hStart == null) {
                        hEnd = hEnd + 4.0;
                        finished = true;
                    }
                }
                if (finished) {
                    hStart = hFirst;
                }
                this.addCorners(w, hEnd, hStart);
            } while (!finished);
            w.addPoint(w.getFirstPoint());
            log.info("adding seaPoly, hits.size()", hits.size());
            areas.add(w);
        }
        return areas;
    }

    private void addCorners(Way w, double hFrom, double hTo) {
        int toCorner;
        int direction;
        int startEdge = (int)hFrom;
        int endEdge = (int)hTo;
        if (hFrom < hTo) {
            direction = 1;
            toCorner = 1;
        } else {
            direction = -1;
            toCorner = 0;
        }
        log.debug("addCorners", hFrom, hTo, direction, startEdge, endEdge, toCorner);
        while (startEdge != endEdge) {
            Coord p = SeaGenerator.getPoint(this.tileBounds, startEdge + toCorner);
            w.addPointIfNotEqualToLastPoint(p);
            startEdge += direction;
        }
    }

    private NavigableMap<Double, Way> findIntersectionPoints() {
        TreeMap<Double, Way> hitMap = new TreeMap<Double, Way>();
        for (Way w : this.shoreline) {
            Coord pStart = w.getFirstPoint();
            Coord pEnd = w.getLastPoint();
            Double hStart = SeaGenerator.getEdgeHit(this.tileBounds, pStart);
            Double hEnd = SeaGenerator.getEdgeHit(this.tileBounds, pEnd);
            if (hStart != null && hEnd != null) {
                log.debug("hits:", hStart, hEnd);
                hitMap.put(hStart, w);
                hitMap.put(hEnd, null);
                continue;
            }
            if (this.allowSeaSectors) {
                int cornerLon;
                int cornerLat;
                boolean startLatIsCorner;
                Way seaOrLand = new Way(w.getOriginalId(), w.getPoints());
                seaOrLand.markAsGeneratedFrom(w);
                int startLat = pStart.getHighPrecLat();
                int startLon = pStart.getHighPrecLon();
                int endLat = pEnd.getHighPrecLat();
                int endLon = pEnd.getHighPrecLon();
                boolean bl = startLatIsCorner = startLat > endLat == startLon > endLon;
                if (this.generateSeaBackground) {
                    startLatIsCorner = !startLatIsCorner;
                    this.islands.add(seaOrLand);
                } else {
                    this.antiIslands.add(seaOrLand);
                }
                if (startLatIsCorner) {
                    cornerLat = startLat;
                    cornerLon = endLon;
                } else {
                    cornerLat = endLat;
                    cornerLon = startLon;
                }
                seaOrLand.addPoint(Coord.makeHighPrecCoord(cornerLat, cornerLon));
                seaOrLand.addPoint(pStart);
                log.info("seaSector:", this.islands.size(), this.antiIslands.size(), startLatIsCorner, Way.clockwise(seaOrLand.getPoints()), seaOrLand.getBasicLogInformation());
                continue;
            }
            if (this.extendSeaSectors) {
                if (null == hStart) {
                    hStart = SeaGenerator.getNextEdgeHit(this.tileBounds, pStart);
                    w.getPoints().add(0, SeaGenerator.getPoint(this.tileBounds, hStart));
                }
                if (null == hEnd) {
                    hEnd = SeaGenerator.getNextEdgeHit(this.tileBounds, pEnd);
                    w.getPoints().add(SeaGenerator.getPoint(this.tileBounds, hEnd));
                }
                log.debug("hits (second try):", hStart, hEnd);
                hitMap.put(hStart, w);
                hitMap.put(hEnd, null);
                continue;
            }
            log.error("Unresolved section of coastline", w.getBasicLogInformation());
        }
        return hitMap;
    }

    private void verifyHits(NavigableMap<Double, Way> hitMap) {
        log.debug("Shorelines", this.shoreline.size(), "Islands", this.islands.size(), "Seas", this.antiIslands.size(), "hits", hitMap.size());
        NavigableSet<Double> hits = hitMap.navigableKeySet();
        Iterator<Double> iter = hits.iterator();
        int lastStatus = 0;
        Double lastHit = 0.0;
        while (iter.hasNext()) {
            int thisStatus;
            Double aHit = iter.next();
            Way segment = (Way)hitMap.get(aHit);
            log.debug("hitmap", aHit, segment);
            if (segment == null) {
                thisStatus = -1;
                iter.remove();
            } else {
                thisStatus = 1;
            }
            if (thisStatus == lastStatus) {
                log.error("Adjacent coastlines hit tile edge in same direction at", SeaGenerator.getPoint(this.tileBounds, lastHit), "and", SeaGenerator.getPoint(this.tileBounds, aHit), segment);
            }
            lastStatus = thisStatus;
            lastHit = aHit;
        }
    }

    private static Coord getPoint(Area a, double edgePos) {
        int plonHp;
        int platHp;
        log.info("getPoint:", a, edgePos);
        int aMinLongHP = a.getMinLong() << 6;
        int aMaxLongHP = a.getMaxLong() << 6;
        int aMinLatHP = a.getMinLat() << 6;
        int aMaxLatHP = a.getMaxLat() << 6;
        int edge = (int)edgePos;
        double t = edgePos - (double)edge;
        if (edge >= 4) {
            edge -= 4;
        }
        switch (edge) {
            case 0: {
                platHp = aMinLatHP;
                plonHp = (int)Math.round((double)aMinLongHP + t * (double)(aMaxLongHP - aMinLongHP));
                break;
            }
            case 1: {
                platHp = (int)Math.round((double)aMinLatHP + t * (double)(aMaxLatHP - aMinLatHP));
                plonHp = aMaxLongHP;
                break;
            }
            case 2: {
                platHp = aMaxLatHP;
                plonHp = (int)Math.round((double)aMaxLongHP - t * (double)(aMaxLongHP - aMinLongHP));
                break;
            }
            case 3: {
                platHp = (int)Math.round((double)aMaxLatHP - t * (double)(aMaxLatHP - aMinLatHP));
                plonHp = aMinLongHP;
                break;
            }
            default: {
                throw new MapFailedException("GetPoint edge: " + edgePos);
            }
        }
        return Coord.makeHighPrecCoord(platHp, plonHp);
    }

    private static Double getEdgeHit(Area a, Coord p) {
        boolean toleranceHp = false;
        int latHp = p.getHighPrecLat();
        int lonHp = p.getHighPrecLon();
        int minLatHp = a.getMinLat() << 6;
        int maxLatHp = a.getMaxLat() << 6;
        int minLongHp = a.getMinLong() << 6;
        int maxLongHp = a.getMaxLong() << 6;
        log.info((Object)String.format("getEdgeHit: (%d %d) (%d %d %d %d)", latHp, lonHp, minLatHp, minLongHp, maxLatHp, maxLongHp));
        if (latHp <= minLatHp + 0) {
            return (double)(lonHp - minLongHp) / (double)(maxLongHp - minLongHp);
        }
        if (lonHp >= maxLongHp - 0) {
            return 1.0 + (double)(latHp - minLatHp) / (double)(maxLatHp - minLatHp);
        }
        if (latHp >= maxLatHp - 0) {
            return 2.0 + (double)(maxLongHp - lonHp) / (double)(maxLongHp - minLongHp);
        }
        if (lonHp <= minLongHp + 0) {
            return 3.0 + (double)(maxLatHp - latHp) / (double)(maxLatHp - minLatHp);
        }
        return null;
    }

    private static Double getNextEdgeHit(Area a, Coord p) {
        int latHp = p.getHighPrecLat();
        int lonHp = p.getHighPrecLon();
        int minLatHp = a.getMinLat() << 6;
        int maxLatHp = a.getMaxLat() << 6;
        int minLongHp = a.getMinLong() << 6;
        int maxLongHp = a.getMaxLong() << 6;
        log.info((Object)String.format("getNextEdgeHit: (%d %d) (%d %d %d %d)", latHp, lonHp, minLatHp, minLongHp, maxLatHp, maxLongHp));
        int min = latHp - minLatHp;
        int i = 0;
        double t = (double)(lonHp - minLongHp) / (double)(maxLongHp - minLongHp);
        if (maxLongHp - lonHp < min) {
            min = maxLongHp - lonHp;
            i = 1;
            t = (double)(latHp - minLatHp) / (double)(maxLatHp - minLatHp);
        }
        if (maxLatHp - latHp < min) {
            min = maxLatHp - latHp;
            i = 2;
            t = (double)(maxLongHp - lonHp) / (double)(maxLongHp - minLongHp);
        }
        if (lonHp - minLongHp < min) {
            i = 3;
            t = (double)(maxLatHp - latHp) / (double)(maxLatHp - minLatHp);
        }
        return (double)i + t;
    }

    private static class PrecompData {
        private byte[][] precompIndex;
        private String precompSeaExt;
        private String precompSeaPrefix;
        private String precompZipFileInternalPath;
        private ZipFile zipFile;
        private File dirFile;

        private PrecompData() {
        }

        static /* synthetic */ byte[][] access$402(PrecompData x0, byte[][] x1) {
            x0.precompIndex = x1;
            return x1;
        }
    }
}

