/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import uk.me.parabola.mkgmap.osmstyle.NameFinder;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.TypeResult;
import uk.me.parabola.util.EnhancedProperties;

public class RelationStyleHook
implements OsmReadingHooks {
    private Style style;
    private ElementSaver saver;
    private NameFinder nameFinder;

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props, Style style) {
        this.saver = saver;
        this.style = style;
        this.nameFinder = new NameFinder(props);
        return true;
    }

    @Override
    public void end() {
        Rule relationRules = this.style.getRelationRules();
        for (Relation rel : this.saver.getRelations().values()) {
            this.nameFinder.setNameWithNameTagList(rel);
            relationRules.resolveType(rel, TypeResult.NULL_RESULT);
            if (!(rel instanceof RestrictionRelation)) continue;
            ((RestrictionRelation)rel).eval(this.saver.getBoundingBox());
        }
    }
}

