/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.OsmCoastDataSource;
import uk.me.parabola.mkgmap.reader.osm.OsmMapDataSource;
import uk.me.parabola.mkgmap.reader.osm.SeaGenerator;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public final class CoastlineFileLoader {
    private static final Logger log = Logger.getLogger(CoastlineFileLoader.class);
    private final Set<String> coastlineFiles;
    private final Collection<CoastlineWay> coastlines = new ArrayList<CoastlineWay>();
    private final AtomicBoolean coastlinesLoaded = new AtomicBoolean(false);
    private final AtomicBoolean loadingStarted = new AtomicBoolean(false);
    private final EnhancedProperties coastConfig;
    private static final CoastlineFileLoader loader = new CoastlineFileLoader();

    private CoastlineFileLoader() {
        this.coastlineFiles = new HashSet<String>();
        this.coastConfig = new EnhancedProperties();
    }

    public static synchronized CoastlineFileLoader getCoastlineLoader() {
        return loader;
    }

    public synchronized void setCoastlineFiles(String[] coastlineFiles) {
        this.coastlineFiles.addAll(Arrays.asList(coastlineFiles));
    }

    public void loadCoastlines() {
        boolean loadInThisThread = this.loadingStarted.compareAndSet(false, true);
        if (loadInThisThread) {
            this.loadCoastlinesImpl();
        } else {
            log.info((Object)"Coastline loading performed by another thread");
        }
    }

    private OsmMapDataSource loadFromFile(String name) throws FileNotFoundException {
        OsmCoastDataSource src = new OsmCoastDataSource();
        src.config(this.getConfig());
        log.info("Started loading coastlines from", name);
        src.load(name, false);
        log.info("Finished loading coastlines from", name);
        return src;
    }

    private Collection<Way> loadFile(String filename) throws FileNotFoundException {
        OsmMapDataSource src = this.loadFromFile(filename);
        return src.getElementSaver().getWays().values();
    }

    private EnhancedProperties getConfig() {
        return this.coastConfig;
    }

    private synchronized void loadCoastlinesImpl() {
        log.info((Object)"Load coastlines");
        for (String coastlineFile : this.coastlineFiles) {
            try {
                int nBefore = this.coastlines.size();
                Collection<Way> loadedCoastlines = this.loadFile(coastlineFile);
                log.info(loadedCoastlines.size(), "coastline ways from", coastlineFile, "loaded.");
                List<Way> ways = SeaGenerator.joinWays(loadedCoastlines);
                ListIterator<Way> wayIter = ways.listIterator();
                while (wayIter.hasNext()) {
                    Way way = wayIter.next();
                    wayIter.remove();
                    this.coastlines.add(new CoastlineWay(way.getId(), way.getPoints()));
                }
                log.info(this.coastlines.size() - nBefore, "coastlines loaded from", coastlineFile);
            }
            catch (FileNotFoundException exp) {
                log.error((Object)("Coastline file " + coastlineFile + " not found."));
            }
            catch (Exception exp) {
                log.error((Object)("Unexpected exception reading " + coastlineFile), exp);
            }
        }
        this.coastlinesLoaded.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Way> getCoastlines(Area bbox) {
        if (!this.coastlinesLoaded.get()) {
            CoastlineFileLoader coastlineFileLoader = this;
            synchronized (coastlineFileLoader) {
                this.loadCoastlines();
            }
        }
        ArrayList<Way> ways = new ArrayList<Way>();
        for (CoastlineWay w : this.coastlines) {
            if (!w.getBbox().intersects(bbox)) continue;
            Way x = new Way(w.getOriginalId(), w.getPoints());
            x.markAsGeneratedFrom(w);
            x.addTag("natural", "coastline");
            ways.add(x);
        }
        return ways;
    }

    public static class CoastlineWay
    extends Way {
        private final Area bbox;

        public CoastlineWay(long id, List<Coord> points) {
            super(id, points);
            if (points.isEmpty()) {
                throw new IllegalArgumentException("No support for empty ways. WayId: " + id);
            }
            if (log.isDebugEnabled()) {
                log.debug("Create coastline way", id, "with", points.size(), "points");
            }
            this.bbox = Area.getBBox(points);
        }

        @Override
        public String getTag(String key) {
            if ("natural".equals(key)) {
                return "coastline";
            }
            return null;
        }

        @Override
        public String toTagString() {
            return "[natural=coastline]";
        }

        @Override
        public Map<String, String> getTagsWithPrefix(String prefix, boolean removePrefix) {
            if ("natural".startsWith(prefix)) {
                if (removePrefix) {
                    return Collections.singletonMap("natural".substring(prefix.length()), "coastline");
                }
                return Collections.singletonMap("natural", "coastline");
            }
            return Collections.emptyMap();
        }

        @Override
        public void removeAllTags() {
        }

        @Override
        public Iterable<Map.Entry<String, String>> getTagEntryIterator() {
            return Collections.singletonMap("natural", "coastline").entrySet();
        }

        public Area getBbox() {
            return this.bbox;
        }
    }
}

