/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.util.List;
import uk.me.parabola.imgfmt.app.BitWriter;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.log.Logger;

public class LinePreparer {
    private static final Logger log = Logger.getLogger(LinePreparer.class);
    private final Polyline polyline;
    private final boolean extraBit;
    private final boolean extTypeLine;
    private boolean xSameSign;
    private boolean xSignNegative;
    private boolean ySameSign;
    private boolean ySignNegative;
    private int xBase;
    private int yBase;
    private int[] deltas;
    private boolean[] nodes;
    private final boolean ignoreNumberOnlyNodes;

    LinePreparer(Polyline line) {
        this.extraBit = line.isRoad() && line.getSubdiv().getZoom().getLevel() == 0 && (line.hasInternalNodes() || !line.isLastSegment());
        this.ignoreNumberOnlyNodes = !line.hasHouseNumbers();
        this.extTypeLine = line.hasExtendedType();
        this.polyline = line;
        this.calcLatLong();
        this.calcDeltas();
    }

    public BitWriter makeShortestBitStream(int minPointsRequired) {
        BitWriter bstest;
        int notBetter;
        BitWriter bsSimple = this.makeBitStream(minPointsRequired, this.xBase, this.yBase);
        if (bsSimple == null) {
            return bsSimple;
        }
        BitWriter bsBest = bsSimple;
        int xBestBase = this.xBase;
        int yBestBase = this.yBase;
        if ((this.xBase > 0 || this.yBase > 0) && log.isDebugEnabled()) {
            log.debug("start opt:", this.xBase, this.yBase, this.xSameSign, this.xSignNegative, this.ySameSign, this.ySignNegative);
        }
        if (this.xBase > 0) {
            notBetter = 0;
            int xTestBase = this.xBase - 1;
            boolean xSameSignBak = this.xSameSign;
            if (this.xSameSign) {
                this.xSameSign = false;
                --xTestBase;
            }
            while (xTestBase >= 0) {
                bstest = this.makeBitStream(minPointsRequired, xTestBase, this.yBase);
                if (bstest.getBitPosition() >= bsBest.getBitPosition()) {
                    if (++notBetter >= 2) {
                        break;
                    }
                } else {
                    xBestBase = xTestBase;
                    bsBest = bstest;
                    xSameSignBak = false;
                }
                --xTestBase;
            }
            this.xSameSign = xSameSignBak;
        }
        if (this.yBase > 0) {
            notBetter = 0;
            int yTestBase = this.yBase - 1;
            boolean ySameSignBak = this.ySameSign;
            if (this.ySameSign) {
                this.ySameSign = false;
                --yTestBase;
            }
            while (yTestBase >= 0) {
                bstest = this.makeBitStream(minPointsRequired, xBestBase, yTestBase);
                if (bstest.getBitPosition() >= bsBest.getBitPosition()) {
                    if (++notBetter >= 2) {
                        break;
                    }
                } else {
                    yBestBase = yTestBase;
                    bsBest = bstest;
                    ySameSignBak = false;
                }
                --yTestBase;
            }
            this.ySameSign = ySameSignBak;
        }
        if ((this.xBase != xBestBase || yBestBase != this.yBase) && log.isInfoEnabled()) {
            if (bsSimple.getLength() > bsBest.getLength()) {
                log.info("optimizer reduced bit stream byte length from", bsSimple.getLength(), "->", bsBest.getLength(), "(" + (bsSimple.getLength() - bsBest.getLength()), "byte(s)) for", this.polyline.getClass().getSimpleName(), "with", this.polyline.getPoints().size(), "points");
            } else {
                log.info("optimizer only reduced bit stream bit length from", bsSimple.getBitPosition(), "->", bsBest.getBitPosition(), "bits for", this.polyline.getClass().getSimpleName(), "with", this.polyline.getPoints().size(), "points, using original bit stream");
            }
        }
        if (bsSimple.getLength() == bsBest.getLength()) {
            return bsSimple;
        }
        return bsBest;
    }

    public BitWriter makeBitStream(int minPointsRequired, int xb, int yb) {
        assert (xb >= 0 && yb >= 0);
        int xbits = LinePreparer.base2Bits(xb);
        if (!this.xSameSign) {
            ++xbits;
        }
        int ybits = LinePreparer.base2Bits(yb);
        if (!this.ySameSign) {
            ++ybits;
        }
        if (log.isDebugEnabled()) {
            log.debug("xbits", xbits, ", y=", ybits);
        }
        BitWriter bw = new BitWriter();
        bw.putn(xb, 4);
        bw.putn(yb, 4);
        bw.put1(this.xSameSign);
        if (this.xSameSign) {
            bw.put1(this.xSignNegative);
        }
        bw.put1(this.ySameSign);
        if (this.ySameSign) {
            bw.put1(this.ySignNegative);
        }
        if (log.isDebugEnabled()) {
            log.debug("x same is", this.xSameSign, "sign is", this.xSignNegative);
            log.debug("y same is", this.ySameSign, "sign is", this.ySignNegative);
        }
        if (this.extTypeLine) {
            bw.put1(false);
        }
        if (this.extraBit) {
            bw.put1(false);
        }
        int numPointsEncoded = 1;
        for (int i = 0; i < this.deltas.length; i += 2) {
            int dx = this.deltas[i];
            int dy = this.deltas[i + 1];
            if (dx == 0 && dy == 0 && this.extraBit && !this.nodes[i / 2 + 1] && i + 2 != this.deltas.length) continue;
            ++numPointsEncoded;
            if (log.isDebugEnabled()) {
                log.debug("x delta", dx, "~", xbits);
            }
            if (this.xSameSign) {
                bw.putn(Math.abs(dx), xbits);
            } else {
                bw.sputn(dx, xbits);
            }
            if (log.isDebugEnabled()) {
                log.debug("y delta", dy, ybits);
            }
            if (this.ySameSign) {
                bw.putn(Math.abs(dy), ybits);
            } else {
                bw.sputn(dy, ybits);
            }
            if (!this.extraBit) continue;
            bw.put1(this.nodes[i / 2 + 1]);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)bw);
        }
        if (numPointsEncoded < minPointsRequired) {
            return null;
        }
        return bw;
    }

    private void calcLatLong() {
        Coord co = this.polyline.getPoints().get(0);
        this.polyline.setLatitude(co.getLatitude());
        this.polyline.setLongitude(co.getLongitude());
    }

    private void calcDeltas() {
        Subdivision subdiv = this.polyline.getSubdiv();
        if (log.isDebugEnabled()) {
            log.debug("label offset", this.polyline.getLabel().getOffset());
        }
        List<Coord> points = this.polyline.getPoints();
        int numPointsToUse = points.size();
        if (this.polyline instanceof Polygon && points.get(0).equals(points.get(points.size() - 1))) {
            --numPointsToUse;
        }
        this.deltas = new int[2 * (numPointsToUse - 1)];
        if (this.extraBit) {
            this.nodes = new boolean[numPointsToUse];
        }
        boolean first = true;
        int lastLat = 0;
        int lastLong = 0;
        int minDx = 0;
        int maxDx = 0;
        int minDy = 0;
        int maxDy = 0;
        int firstsame = 0;
        for (int i = 0; i < numPointsToUse; ++i) {
            Coord co = points.get(i);
            int lat = subdiv.roundLatToLocalShifted(co.getLatitude());
            int lon = subdiv.roundLonToLocalShifted(co.getLongitude());
            if (log.isDebugEnabled()) {
                log.debug("shifted pos", lat, lon);
            }
            int dx = lon - lastLong;
            int dy = lat - lastLat;
            lastLong = lon;
            lastLat = lat;
            if (first) {
                first = false;
                continue;
            }
            if (this.extraBit) {
                boolean isSpecialNode;
                boolean bl = isSpecialNode = co.getId() > 0 || !this.ignoreNumberOnlyNodes && co.isNumberNode();
                if (dx != 0 || dy != 0 || isSpecialNode) {
                    firstsame = i;
                }
                boolean extra = false;
                if (isSpecialNode) {
                    extra = i < this.nodes.length - 1 ? true : !this.polyline.isLastSegment();
                }
                boolean bl2 = this.nodes[firstsame] = this.nodes[firstsame] || extra;
            }
            if (dx < minDx) {
                minDx = dx;
            }
            if (dx > maxDx) {
                maxDx = dx;
            }
            if (dy < minDy) {
                minDy = dy;
            }
            if (dy > maxDy) {
                maxDy = dy;
            }
            this.deltas[2 * (i - 1)] = dx;
            this.deltas[2 * (i - 1) + 1] = dy;
        }
        int xBits = Math.max(LinePreparer.bitsNeeded(minDx), LinePreparer.bitsNeeded(maxDx));
        int yBits = Math.max(LinePreparer.bitsNeeded(minDy), LinePreparer.bitsNeeded(maxDy));
        if (log.isDebugEnabled()) {
            log.debug("initial xBits, yBits", xBits, yBits);
        }
        this.xBase = LinePreparer.bits2Base(xBits);
        this.yBase = LinePreparer.bits2Base(yBits);
        if (log.isDebugEnabled()) {
            log.debug("initial xBase, yBase", this.xBase, this.yBase);
        }
        this.xSameSign = minDx >= 0 || maxDx <= 0;
        boolean bl = this.ySameSign = minDy >= 0 || maxDy <= 0;
        if (this.xSameSign) {
            boolean bl3 = this.xSignNegative = minDx < 0;
        }
        if (this.ySameSign) {
            this.ySignNegative = minDy < 0;
        }
    }

    public static int bitsNeeded(int val) {
        int n = Math.abs(val);
        int count = 0;
        while (n != 0) {
            n >>>= 1;
            ++count;
        }
        return count;
    }

    public boolean isExtraBit() {
        return this.extraBit;
    }

    private static int base2Bits(int base) {
        int bits = 2;
        if (base < 10) {
            return bits + base;
        }
        return bits + 2 * base - 9;
    }

    private static int bits2Base(int bits) {
        int base = Math.max(0, bits - 2);
        if (base > 10) {
            if ((base & 1) == 0) {
                ++base;
            }
            base = 9 + (base - 9) / 2;
        }
        return base;
    }
}

