/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.imgfmt.app.net.RouteNode;

public class RouteRestriction {
    private static final byte RESTRICTION_TYPE = 5;
    private static final int F_INTERNAL = 32768;
    private final List<RouteArc> arcs;
    private final RouteNode viaNode;
    private int offsetSize;
    private int offsetC;
    private boolean last;
    private final byte exceptMask;
    private final byte flags;
    private static final byte F_EXCEPT_FOOT = 2;
    private static final byte F_EXCEPT_EMERGENCY = 4;
    private static final byte F_MORE_EXCEPTIONS = 8;
    private static final byte EXCEPT_CAR = 1;
    private static final byte EXCEPT_BUS = 2;
    private static final byte EXCEPT_TAXI = 4;
    private static final byte EXCEPT_DELIVERY = 16;
    private static final byte EXCEPT_BICYCLE = 32;
    private static final byte EXCEPT_TRUCK = 64;

    public RouteRestriction(RouteNode viaNode, List<RouteArc> traffArcs, byte mkgmapExceptMask) {
        this.viaNode = viaNode;
        this.arcs = new ArrayList<RouteArc>(traffArcs);
        for (int i = 0; i < this.arcs.size(); ++i) {
            RouteArc arc = this.arcs.get(i);
            assert (arc.getDest() != viaNode);
        }
        int tmpFlags = 0;
        if ((mkgmapExceptMask & 1) != 0) {
            tmpFlags = (byte)(tmpFlags | 2);
        }
        if ((mkgmapExceptMask & 0xFFFFFF80) != 0) {
            tmpFlags = (byte)(tmpFlags | 4);
        }
        this.exceptMask = RouteRestriction.translateExceptMask(mkgmapExceptMask);
        if (this.exceptMask != 0) {
            tmpFlags = (byte)(tmpFlags | 8);
        }
        int numArcs = this.arcs.size();
        assert (numArcs < 8);
        tmpFlags = (byte)(tmpFlags | numArcs << 5);
        this.flags = (byte)tmpFlags;
    }

    private static byte translateExceptMask(byte mkgmapExceptMask) {
        byte mask = 0;
        if ((mkgmapExceptMask & 4) != 0) {
            mask = (byte)(mask | 1);
        }
        if ((mkgmapExceptMask & 0x20) != 0) {
            mask = (byte)(mask | 2);
        }
        if ((mkgmapExceptMask & 0x40) != 0) {
            mask = (byte)(mask | 4);
        }
        if ((mkgmapExceptMask & 8) != 0) {
            mask = (byte)(mask | 0x10);
        }
        if ((mkgmapExceptMask & 2) != 0) {
            mask = (byte)(mask | 0x20);
        }
        if ((mkgmapExceptMask & 0x10) != 0) {
            mask = (byte)(mask | 0x40);
        }
        return mask;
    }

    private static int calcOffset(RouteNode node, int tableOffset) {
        int offset = tableOffset - node.getOffsetNod1();
        assert (offset >= 0) : "node behind start of tables";
        assert (offset < 32768) : "node offset too large";
        return offset | 0x8000;
    }

    public List<RouteArc> getArcs() {
        return this.arcs;
    }

    public void write(ImgFileWriter writer, int tableOffset) {
        writer.put1u(5);
        writer.put(this.flags);
        writer.put1u(0);
        if (this.exceptMask != 0) {
            writer.put1u(this.exceptMask);
        }
        int numArcs = this.arcs.size();
        int[] offsets = new int[numArcs + 1];
        int pos = 0;
        boolean viaWritten = false;
        for (int i = 0; i < numArcs; ++i) {
            RouteArc arc = this.arcs.get(i);
            offsets[pos++] = arc.isInternal() ? RouteRestriction.calcOffset(arc.getDest(), tableOffset) : arc.getIndexB();
            if (viaWritten || arc.getSource() != this.viaNode) continue;
            offsets[pos++] = RouteRestriction.calcOffset(this.viaNode, tableOffset);
            viaWritten = true;
        }
        for (int offset : offsets) {
            writer.put2u(offset);
        }
        Object object = this.arcs.iterator();
        while (object.hasNext()) {
            RouteArc arc = (RouteArc)object.next();
            writer.put1u(arc.getIndexA());
        }
    }

    public void writeOffset(ImgFileWriter writer) {
        assert (0 < this.offsetSize && this.offsetSize <= 2) : "illegal offset size";
        int offset = this.offsetC;
        if (this.offsetSize == 1) {
            assert (offset < 128);
            if (this.last) {
                offset |= 0x80;
            }
            writer.put1u(offset);
        } else {
            assert (offset < 32768);
            if (this.last) {
                offset |= 0x8000;
            }
            writer.put2u(offset);
        }
    }

    public int getSize() {
        int size = 3;
        if (this.exceptMask != 0) {
            ++size;
        }
        return size += this.arcs.size() + (this.arcs.size() + 1) * 2;
    }

    public void setOffsetC(int offsetC) {
        this.offsetC = offsetC;
    }

    public int getOffsetC() {
        return this.offsetC;
    }

    public void setOffsetSize(int size) {
        this.offsetSize = size;
    }

    public void setLast() {
        this.last = true;
    }
}

