/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.imgfmt.app.net.RouteNode;
import uk.me.parabola.imgfmt.app.net.RouteRestriction;
import uk.me.parabola.imgfmt.app.net.TableA;
import uk.me.parabola.imgfmt.app.net.TableB;
import uk.me.parabola.imgfmt.app.net.TableC;
import uk.me.parabola.log.Logger;

public class RouteCenter {
    private static final Logger log = Logger.getLogger(RouteCenter.class);
    private final Area area;
    private final Coord centralPoint;
    private final List<RouteNode> nodes;
    private final TableA tabA;
    private final TableB tabB;
    private final TableC tabC;

    public RouteCenter(Area area, List<RouteNode> nodes, TableA tabA, TableB tabB) {
        this.area = area;
        this.centralPoint = area.getCenter();
        this.nodes = nodes;
        this.tabA = tabA;
        this.tabB = tabB;
        this.tabC = new TableC(tabA);
        log.info((Object)("new RouteCenter at " + this.centralPoint + ", nodes: " + nodes.size() + " tabA: " + tabA.size() + " tabB: " + tabB.size()));
    }

    private void updateOffsets() {
        for (RouteNode node : this.nodes) {
            node.setOffsets(this.centralPoint);
            for (RouteArc arc : node.arcsIteration()) {
                arc.setIndexA(this.tabA.getIndex(arc));
                arc.setInternal(this.nodes.contains(arc.getDest()));
                if (arc.isInternal()) continue;
                arc.setIndexB(this.tabB.getIndex(arc.getDest()));
            }
            for (RouteRestriction restr : node.getRestrictions()) {
                if (restr.getArcs().size() >= 3) {
                    for (RouteArc arc : restr.getArcs()) {
                        if (arc.getSource() == node) continue;
                        arc.setIndexA(this.tabA.getIndex(arc));
                        arc.setInternal(this.nodes.contains(arc.getDest()));
                        if (arc.isInternal()) continue;
                        arc.setIndexB(this.tabB.getIndex(arc.getDest()));
                    }
                }
                restr.setOffsetC(this.tabC.addRestriction(restr));
            }
        }
        this.tabC.propagateSizeBytes();
    }

    public void write(ImgFileWriter writer, int[] classBoundaries) {
        assert (!this.nodes.isEmpty()) : "RouteCenter without nodes";
        this.updateOffsets();
        int centerPos = writer.position();
        for (RouteNode node : this.nodes) {
            node.write(writer);
            int group = node.getGroup();
            if (group == 0 || centerPos >= classBoundaries[group - 1]) continue;
            for (int i = group - 1; i >= 0; --i) {
                if (centerPos >= classBoundaries[i]) continue;
                classBoundaries[i] = centerPos;
            }
        }
        int alignment = 64;
        int alignMask = alignment - 1;
        int tablesOffset = writer.position() + alignment & ~alignMask;
        log.debug("write table a at offset", Integer.toHexString(tablesOffset));
        for (RouteNode node : this.nodes) {
            int pos = node.getOffsetNod1();
            log.debug("node pos", pos);
            byte bo = (byte)RouteCenter.calcLowByte(pos, tablesOffset);
            writer.position(pos);
            log.debug("rewrite taba offset", writer.position(), bo);
            writer.put1u(bo);
            node.writeSecond(writer);
        }
        writer.position(tablesOffset);
        writer.put1u(this.tabC.getFormat());
        Utils.put3sLongitude(writer, this.centralPoint.getLongitude());
        writer.put3s(this.centralPoint.getLatitude());
        writer.put1u(this.tabA.getNumberOfItems());
        writer.put1u(this.tabB.getNumberOfItems());
        this.tabA.write(writer);
        this.tabB.write(writer);
        this.tabC.write(writer, tablesOffset);
        log.info("end of center:", writer.position());
    }

    public void writePost(ImgFileWriter writer) {
        this.tabA.writePost(writer);
        this.tabB.writePost(writer);
    }

    private static int calcLowByte(int nodeOffset, int tablesOffset) {
        assert (nodeOffset < tablesOffset);
        int align = 6;
        int mask = (1 << align) - 1;
        if ((tablesOffset & mask) != 0) {
            log.warn("tablesOffset not a multiple of (1<<align): %x", tablesOffset);
            tablesOffset = (tablesOffset >> align) + 1 << align;
        }
        int low = (tablesOffset >> align) - (nodeOffset >> align) - 1;
        assert (0 <= low && low < 256);
        return low;
    }

    public Area getArea() {
        return this.area;
    }

    public String reportSizes() {
        int nodesSize = 0;
        for (RouteNode n : this.nodes) {
            nodesSize += n.boundSize();
        }
        return "n=(" + this.nodes.size() + "," + nodesSize + "), a=" + this.tabA.size() + ", b=" + this.tabB.size();
    }
}

