/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.Arrays;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;

public class NODHeader
extends CommonHeader {
    public static final int HEADER_LEN = 127;
    static final char DEF_ALIGN = '\u0006';
    private static final char BOUNDARY_ITEM_SIZE = '\t';
    private final Section nodes = new Section();
    private final Section roads = new Section(this.nodes);
    private final Section boundary = new Section(this.roads, 9);
    private final Section highClassBoundary = new Section(this.boundary);
    private final int[] classBoundaries = new int[5];
    private final Section nod5 = new Section();
    private final Section nod6 = new Section();
    private int flags;
    private int align;
    private int mult1;
    private int tableARecordLen;
    private boolean driveOnLeft;
    private int indexIdSize;
    static final int DISTANCE_MULT_SHIFT = 1;
    static final int DISTANCE_MULT = 2;
    private static final double UNIT_TO_METER = 2.4;

    public NODHeader() {
        super(127, "GARMIN NOD");
        Arrays.fill(this.classBoundaries, Integer.MAX_VALUE);
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) {
        this.nodes.readSectionInfo(reader, false);
        this.flags = reader.get2u();
        reader.get2u();
        this.align = reader.get1u();
        this.mult1 = reader.get1u();
        this.tableARecordLen = reader.get2u();
        this.roads.readSectionInfo(reader, false, true);
        this.boundary.readSectionInfo(reader, true, true);
        if (this.getHeaderLength() > 63) {
            this.highClassBoundary.readSectionInfo(reader, false);
            this.classBoundaries[0] = reader.get4();
            this.classBoundaries[1] = this.classBoundaries[0] + reader.get4();
            this.classBoundaries[2] = this.classBoundaries[1] + reader.get4();
            this.classBoundaries[3] = this.classBoundaries[2] + reader.get4();
            this.classBoundaries[4] = this.classBoundaries[3] + reader.get4();
        }
        if (this.getHeaderLength() >= 127) {
            reader.position(reader.getGMPOffset() + 103);
            this.nod5.readSectionInfo(reader, false);
            reader.get2u();
            this.nod6.readSectionInfo(reader, true);
            this.indexIdSize = Utils.numberToPointerSize(this.nod6.getNumItems());
        }
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        this.nodes.setPosition(127);
        this.nodes.writeSectionInfo(writer);
        int flags = 519;
        assert (Integer.bitCount(2) == 1);
        flags |= 0x20;
        if (this.driveOnLeft) {
            flags |= 0x100;
        }
        writer.put4(flags);
        writer.put1u(6);
        writer.put1u(0);
        writer.put2u(5);
        this.roads.writeSectionInfo(writer);
        writer.put4(0);
        this.boundary.writeSectionInfo(writer);
        writer.put4(2);
        this.highClassBoundary.writeSectionInfo(writer);
        writer.put4(this.classBoundaries[0]);
        for (int i = 1; i < this.classBoundaries.length; ++i) {
            writer.put4(this.classBoundaries[i] - this.classBoundaries[i - 1]);
        }
    }

    public static int metersToRaw(double m) {
        double d = m / 4.8;
        return (int)Math.round(d);
    }

    public int getNodeStart() {
        return this.nodes.getPosition();
    }

    public void setNodeStart(int start) {
        this.nodes.setPosition(start);
    }

    public int getNodeSize() {
        return this.nodes.getSize();
    }

    public void setNodeSize(int size) {
        this.nodes.setSize(size);
    }

    public Section getNodeSection() {
        return this.nodes;
    }

    public void setRoadSize(int size) {
        this.roads.setSize(size);
    }

    public Section getRoadSection() {
        return this.roads;
    }

    public void setBoundarySize(int size) {
        this.boundary.setSize(size);
    }

    public Section getBoundarySection() {
        return this.boundary;
    }

    public void setHighClassBoundarySize(int size) {
        this.highClassBoundary.setSize(size);
    }

    public Section getHighClassBoundary() {
        return this.highClassBoundary;
    }

    public int[] getClassBoundaries() {
        return this.classBoundaries;
    }

    public void setDriveOnLeft(boolean dol) {
        this.driveOnLeft = dol;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getAlign() {
        return this.align;
    }

    public int getMult1() {
        return this.mult1;
    }

    public int getTableARecordLen() {
        return this.tableARecordLen;
    }

    public int getIndexIdSize() {
        return this.indexIdSize;
    }
}

