/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.mdr.NamedRecord;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.reader.osm.GType;

public class MdrUtils {
    public static final int STREET_INDEX_PREFIX_LEN = 4;
    public static final int POI_INDEX_PREFIX_LEN = 4;
    public static final int MAX_GROUP = 13;

    private MdrUtils() {
    }

    public static int getGroupForPoi(int fullType) {
        int type = MdrUtils.getTypeFromFullType(fullType);
        int group = 0;
        if (MapPoint.isCityType(fullType)) {
            group = 1;
        } else if (type >= 42 && type <= 48) {
            group = type - 42 + 2;
        } else if (type == 40) {
            group = 9;
        } else if (type >= 100 && type <= 102) {
            group = type - 100 + 11;
        }
        assert (group >= 0 && group <= 13) : "invalid group " + Integer.toHexString(group);
        return group;
    }

    public static boolean canBeIndexed(int fullType) {
        return MdrUtils.getGroupForPoi(fullType) != 0;
    }

    public static int getTypeFromFullType(int fullType) {
        return fullType >> 8 & 0xFFF;
    }

    public static int getSubtypeFromFullType(int fullType) {
        return fullType & 0xFF;
    }

    public static <T extends NamedRecord> List<SortKey<T>> sortList(Sort sort, List<T> list) {
        ArrayList<SortKey<T>> toSort = new ArrayList<SortKey<T>>(list.size());
        for (NamedRecord m : list) {
            SortKey<NamedRecord> sortKey = sort.createSortKey(m, m.getName(), m.getMapIndex());
            toSort.add(sortKey);
        }
        toSort.sort(null);
        return toSort;
    }

    public static int fullTypeToNaturalType(int ftype) {
        int type = MdrUtils.getTypeFromFullType(ftype);
        int sub = MdrUtils.getSubtypeFromFullType(ftype);
        assert (sub <= 31) : "Subtype doesn't fit into 5 bits: " + GType.formatType(ftype);
        return type << 5 | sub;
    }
}

