/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.scan.SyntaxException;

public class MdrConfig {
    private static final int DEFAULT_HEADER_LEN = 568;
    private boolean writable;
    private boolean forDevice;
    private int headerLen = 568;
    private Sort sort;
    private File outputDir;
    private boolean splitName;
    private Set<String> mdr7Excl = Collections.emptySet();
    private Set<String> mdr7Del = Collections.emptySet();
    private Set<Integer> poiExclTypes = Collections.emptySet();

    public MdrConfig() {
    }

    public MdrConfig(MdrConfig base) {
        this.splitName = base.isSplitName();
        this.mdr7Del = base.getMdr7Del();
        this.mdr7Excl = base.getMdr7Excl();
        this.poiExclTypes = base.getPoiExclTypes();
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    public boolean isForDevice() {
        return this.forDevice;
    }

    public void setForDevice(boolean forDevice) {
        this.forDevice = forDevice;
    }

    public int getHeaderLen() {
        return this.headerLen;
    }

    public void setHeaderLen(int headerLen) {
        this.headerLen = headerLen;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        if (outputDir != null) {
            this.outputDir = new File(outputDir);
        }
    }

    public void setSplitName(boolean splitName) {
        this.splitName = splitName;
    }

    public boolean isSplitName() {
        return this.splitName;
    }

    public Set<String> getMdr7Excl() {
        return Collections.unmodifiableSet(this.mdr7Excl);
    }

    public Set<String> getMdr7Del() {
        return Collections.unmodifiableSet(this.mdr7Del);
    }

    public void setPoiExcl(List<String> opts) {
        if (opts.isEmpty()) {
            this.poiExclTypes = Collections.emptyNavigableSet();
        } else {
            this.poiExclTypes = new TreeSet<Integer>();
            for (String range : opts) {
                if (range.contains("-")) {
                    String[] ranges = range.split("-");
                    if (ranges.length != 2) {
                        throw new IllegalArgumentException("invalid range in option " + range);
                    }
                    MdrConfig.genTypesForRange(this.poiExclTypes, ranges[0], ranges[1]);
                    continue;
                }
                MdrConfig.genTypesForRange(this.poiExclTypes, range, range);
            }
        }
    }

    private static void genTypesForRange(Set<Integer> set, String start, String stop) {
        int i;
        GType[] types = new GType[2];
        Object[] ranges = new String[]{start, stop};
        boolean ok = true;
        for (i = 0; i < 2; ++i) {
            try {
                types[i] = new GType(FeatureKind.POINT, ranges[i]);
            }
            catch (ExitException e) {
                ok = false;
            }
            if (ok && GType.checkType(types[i].getFeatureKind(), types[i].getType())) continue;
            throw new SyntaxException("invalid type " + ranges[i] + " for " + (Object)((Object)FeatureKind.POINT) + " in option " + Arrays.toString(ranges));
        }
        if (types[0].getType() > types[1].getType()) {
            GType gt = types[0];
            types[0] = types[1];
            types[1] = gt;
        }
        for (i = types[0].getType(); i <= types[1].getType(); ++i) {
            if ((i & 0xFF) > 31) {
                i = (i >> 8) + 1 << 8;
            }
            set.add(i);
        }
    }

    public Set<Integer> getPoiExclTypes() {
        return Collections.unmodifiableSet(this.poiExclTypes);
    }

    public void setIndexOptions(CommandArgs args) {
        this.setSplitName(args.get("split-name-index", false));
        this.mdr7Excl = args.argToSet("mdr7-excl", null);
        this.mdr7Del = args.argToSet("mdr7-del", null);
        this.setPoiExcl(args.argToList("poi-excl-index", null));
    }
}

